/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.store.mapping.ObjectFactory;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DataBinding;
import org.plasma.common.bind.ValidatingUnmarshaler;
import org.xml.sax.SAXException;

public class StoreMappingDataBinding
implements DataBinding {
    private static Log log = LogFactory.getLog(StoreMappingDataBinding.class);
    public static String FILENAME_SCHEMA_CHAIN_ROOT = "cloudgraph-config.xsd";
    public static Class<?> RESOURCE_CLASS = StoreMappingDataBinding.class;
    private ValidatingUnmarshaler validatingUnmarshaler;
    public static Class<?>[] FACTORIES = new Class[]{ObjectFactory.class};

    private StoreMappingDataBinding() {
    }

    public StoreMappingDataBinding(BindingValidationEventHandler validationEventHandler) throws JAXBException, SAXException {
        log.debug((Object)"loading schema chain...");
        InputStream stream = RESOURCE_CLASS.getResourceAsStream(FILENAME_SCHEMA_CHAIN_ROOT);
        if (stream == null) {
            stream = RESOURCE_CLASS.getClassLoader().getResourceAsStream(FILENAME_SCHEMA_CHAIN_ROOT);
        }
        if (stream == null) {
            throw new StoreMappingException("could not find configuration file schema resource '" + FILENAME_SCHEMA_CHAIN_ROOT + "' on the current classpath");
        }
        this.validatingUnmarshaler = new ValidatingUnmarshaler(stream, JAXBContext.newInstance((Class[])FACTORIES), validationEventHandler);
    }

    public Class<?>[] getObjectFactories() {
        return FACTORIES;
    }

    public String marshal(Object root) throws JAXBException {
        return this.validatingUnmarshaler.marshal(root);
    }

    public void marshal(Object root, OutputStream stream) throws JAXBException {
        this.validatingUnmarshaler.marshal(root, stream);
    }

    public Object unmarshal(String xml) throws JAXBException {
        return this.validatingUnmarshaler.unmarshal(xml);
    }

    public Object unmarshal(InputStream stream) throws JAXBException {
        return this.validatingUnmarshaler.unmarshal(stream);
    }

    public Object validate(String xml) throws JAXBException {
        return this.validatingUnmarshaler.validate(xml);
    }

    public Object validate(InputStream xml) throws JAXBException, UnmarshalException {
        return this.validatingUnmarshaler.validate(xml);
    }

    public BindingValidationEventHandler getValidationEventHandler() throws JAXBException {
        return this.validatingUnmarshaler.getValidationEventHandler();
    }
}

