/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import org.cloudgraph.store.mapping.ConfigurationProperty;
import org.cloudgraph.store.mapping.FetchType;
import org.cloudgraph.store.mapping.ParallelFetchDisposition;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.plasma.query.Query;

public class StoreMappingProp {
    public static FetchType getQueryFetchType(Query query) {
        FetchType fetchType = FetchType.SERIAL;
        String fetchTypeValue = System.getProperty(ConfigurationProperty.CLOUDGRAPH___QUERY___FETCHTYPE.value());
        if (fetchTypeValue != null) {
            try {
                fetchType = FetchType.fromValue(fetchTypeValue);
            }
            catch (IllegalArgumentException e) {
                throw new StoreMappingException("unknown query configuration value '" + fetchTypeValue + "' for property, " + ConfigurationProperty.CLOUDGRAPH___QUERY___FETCHTYPE.value(), e);
            }
        }
        if ((fetchTypeValue = query.getConfigurationProperty(ConfigurationProperty.CLOUDGRAPH___QUERY___FETCHTYPE.value())) != null) {
            try {
                fetchType = FetchType.fromValue(fetchTypeValue);
            }
            catch (IllegalArgumentException e) {
                throw new StoreMappingException("unknown query configuration value '" + fetchTypeValue + "' for property, " + ConfigurationProperty.CLOUDGRAPH___QUERY___FETCHTYPE.value(), e);
            }
        }
        return fetchType;
    }

    public static ParallelFetchDisposition getQueryParallelFetchDisposition(Query query) {
        ParallelFetchDisposition fetchDisposition = ParallelFetchDisposition.TALL;
        String fetchDispositionValue = System.getProperty(ConfigurationProperty.CLOUDGRAPH___QUERY___PARALLELFETCH___DISPOSITION.value());
        if (fetchDispositionValue != null) {
            try {
                fetchDisposition = ParallelFetchDisposition.fromValue(fetchDispositionValue);
            }
            catch (IllegalArgumentException e) {
                throw new StoreMappingException("unknown query configuration value '" + fetchDispositionValue + "' for property, " + ConfigurationProperty.CLOUDGRAPH___QUERY___PARALLELFETCH___DISPOSITION.value(), e);
            }
        }
        if ((fetchDispositionValue = query.getConfigurationProperty(ConfigurationProperty.CLOUDGRAPH___QUERY___PARALLELFETCH___DISPOSITION.value())) != null) {
            try {
                fetchDisposition = ParallelFetchDisposition.fromValue(fetchDispositionValue);
            }
            catch (IllegalArgumentException e) {
                throw new StoreMappingException("unknown query configuration value '" + fetchDispositionValue + "' for property, " + ConfigurationProperty.CLOUDGRAPH___QUERY___PARALLELFETCH___DISPOSITION.value(), e);
            }
        }
        return fetchDisposition;
    }

    public static int getQueryPoolMin() {
        int minPool = StoreMappingProp.findIntValue(ConfigurationProperty.CLOUDGRAPH___QUERY___THREADPOOL___SIZE___MIN.value(), 10);
        return minPool;
    }

    public static int getQueryPoolMax() {
        int maxPool = StoreMappingProp.findIntValue(ConfigurationProperty.CLOUDGRAPH___QUERY___THREADPOOL___SIZE___MAX.value(), 10);
        return maxPool;
    }

    public static int getQueryThreadMaxDepth(Query query) {
        int depthMax = StoreMappingProp.findIntValue(query, ConfigurationProperty.CLOUDGRAPH___QUERY___THREAD___DEPTH___MAX.value(), 3);
        return depthMax;
    }

    private static int findIntValue(String propertyName, int dflt) {
        int intValue = dflt;
        String value = System.getProperty(propertyName);
        if (value != null) {
            try {
                intValue = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                throw new StoreMappingException("invalid system configuration value '" + value + "' for property, " + propertyName, nfe);
            }
        }
        return intValue;
    }

    private static int findIntValue(Query query, String propertyName, int dflt) {
        String stringValue;
        int intValue = dflt;
        String value = System.getProperty(propertyName);
        if (value != null) {
            try {
                intValue = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                throw new StoreMappingException("invalid system query configuration value '" + value + "' for property, " + propertyName, nfe);
            }
        }
        if ((stringValue = query.getConfigurationProperty(propertyName)) != null) {
            try {
                intValue = Integer.valueOf(stringValue);
            }
            catch (NumberFormatException nfe) {
                throw new StoreMappingException("invalid query configuration value '" + stringValue + "' for property, " + propertyName, nfe);
            }
        }
        return intValue;
    }
}

