/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudgraph.store.mapping.StoreMappingException;
import org.plasma.common.bind.BindingValidationEventHandler;

public class StoreMappingValidationEventHandler
implements BindingValidationEventHandler {
    private static Log log = LogFactory.getLog(StoreMappingValidationEventHandler.class);
    private int errorCount;
    private boolean cumulative = true;

    public int getErrorCount() {
        return this.errorCount;
    }

    public StoreMappingValidationEventHandler() {
    }

    public StoreMappingValidationEventHandler(boolean cumulative) {
        this.cumulative = cumulative;
    }

    public boolean handleEvent(ValidationEvent ve) {
        boolean result = this.cumulative;
        ++this.errorCount;
        ValidationEventLocator vel = ve.getLocator();
        String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
        switch (ve.getSeverity()) {
            case 0: {
                log.warn((Object)message);
                break;
            }
            case 1: 
            case 2: {
                log.fatal((Object)message);
                throw new StoreMappingException(message);
            }
            default: {
                log.error((Object)message);
            }
        }
        return result;
    }

    public void reset() {
        this.errorCount = 0;
    }
}

