/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudgraph.store.mapping.Config;
import org.cloudgraph.store.mapping.ConfigurationProperty;
import org.cloudgraph.store.mapping.Property;
import org.cloudgraph.store.mapping.StoreMapping;
import org.cloudgraph.store.mapping.Table;

public class TableMapping {
    private static final String TABLE_NAME_DELIM = ":";
    private static final String TABLE_PATH_DELIM = "/";
    private Table table;
    private Config config;
    private Charset charset;
    private Map<String, Property> propertyNameToPropertyMap = new HashMap<String, Property>();
    private byte[] columnFamilyNameBytes;
    private Boolean uniqueChecksVar = null;
    private Boolean tombstoneRowsVar = null;
    private Boolean tombstoneRowsOverwriteableVar = null;
    private String maprdbTablePathPrefixVar = null;

    private TableMapping() {
    }

    public TableMapping(Table table, Config config) {
        this.table = table;
        this.config = config;
        this.charset = Charset.forName("UTF-8");
        for (Property prop : table.getProperties()) {
            this.propertyNameToPropertyMap.put(prop.getName(), prop);
        }
    }

    public TableMapping(Table table) {
        this(table, StoreMapping.getInstance());
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        String name = this.table.getName();
        String prefix = this.maprdbTablePathPrefix();
        if (prefix != null) {
            if (!prefix.endsWith(TABLE_PATH_DELIM) && !name.startsWith(TABLE_PATH_DELIM)) {
                prefix = prefix + TABLE_PATH_DELIM;
            }
            name = prefix + name;
        }
        return name;
    }

    public String getNamespace() {
        return this.table.getNamespace();
    }

    public String getQualifiedName() {
        return TableMapping.qualifiedNameFor(this.getNamespace(), this.getName());
    }

    public static String qualifiedNameFor(String namespace, String tableName) {
        String qualifiedName = tableName;
        if (namespace != null) {
            qualifiedName = namespace + TABLE_NAME_DELIM + qualifiedName;
        }
        return qualifiedName;
    }

    public String getDataColumnFamilyName() {
        return this.table.getDataColumnFamilyName();
    }

    public byte[] getDataColumnFamilyNameBytes() {
        if (this.columnFamilyNameBytes == null) {
            this.columnFamilyNameBytes = this.table.getDataColumnFamilyName().getBytes(this.charset);
        }
        return this.columnFamilyNameBytes;
    }

    public boolean hasHashAlgorithm() {
        return this.getTable().getHashAlgorithm() != null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public List<Property> getProperties() {
        return this.table.properties;
    }

    public Property findProperty(String name) {
        return this.propertyNameToPropertyMap.get(name);
    }

    public boolean uniqueChecks() {
        if (this.uniqueChecksVar == null) {
            this.uniqueChecksVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___UNIQUE___CHECKS, this.table.isUniqueChecks(), true);
        }
        return this.uniqueChecksVar;
    }

    public boolean tombstoneRows() {
        if (this.tombstoneRowsVar == null) {
            this.tombstoneRowsVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___TOMBSTONE___ROWS, this.table.isTombstoneRows(), true);
        }
        return this.tombstoneRowsVar;
    }

    public boolean tombstoneRowsOverwriteable() {
        if (this.tombstoneRowsOverwriteableVar == null) {
            this.tombstoneRowsOverwriteableVar = this.getTablePropertyBoolean(ConfigurationProperty.CLOUDGRAPH___TOMBSTONE___ROWS___OVERWRITEABLE, this.table.isTombstoneRowsOverwriteable(), false);
        }
        return this.tombstoneRowsOverwriteableVar;
    }

    public String maprdbTablePathPrefix() {
        if (this.maprdbTablePathPrefixVar == null) {
            this.maprdbTablePathPrefixVar = this.getTablePropertyString(ConfigurationProperty.CLOUDGRAPH___MAPRDB___TABLE___PATH___PREFIX, this.table.getMaprdbTablePathPrefix(), null);
        }
        return this.maprdbTablePathPrefixVar;
    }

    private String getTablePropertyString(ConfigurationProperty prop, String tableValue, String defaultValue) {
        Property globalProp;
        Property tableProp;
        String value = this.config.getConfigProperties().getString(prop.value());
        String result = value != null ? value : (defaultValue != tableValue ? tableValue : ((tableProp = this.findProperty(prop.value())) != null ? tableProp.getValue() : ((globalProp = this.config.findProperty(prop.value())) != null ? globalProp.getValue() : defaultValue)));
        return result;
    }

    private Boolean getTablePropertyBoolean(ConfigurationProperty prop, boolean tableValue, boolean defaultValue) {
        Property globalProp;
        Property tableProp;
        String value = this.config.getConfigProperties().getString(prop.value());
        Boolean result = value != null ? Boolean.valueOf(value) : (defaultValue != tableValue ? Boolean.valueOf(tableValue) : ((tableProp = this.findProperty(prop.value())) != null ? Boolean.valueOf(tableProp.getValue()) : ((globalProp = this.config.findProperty(prop.value())) != null ? Boolean.valueOf(globalProp.getValue()) : Boolean.valueOf(defaultValue))));
        return result;
    }
}

