/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping.codec;

import org.cloudgraph.common.Bytes;
import org.cloudgraph.common.hash.Jenkins32;
import org.cloudgraph.common.hash.Murmur128;
import org.cloudgraph.common.hash.Murmur32;
import org.cloudgraph.store.mapping.HashAlgorithmName;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.codec.CodecException;
import org.cloudgraph.store.mapping.codec.DefaultKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.plasma.sdo.helper.DataConverter;

public class HashKeyFieldCodec
extends DefaultKeyFieldCodec
implements KeyFieldCodec {
    protected HashAlgorithmName hashName;

    @Override
    public boolean isLexicographic() {
        return false;
    }

    @Override
    public boolean isTransforming() {
        return true;
    }

    public HashKeyFieldCodec(KeyFieldMapping keyField, HashAlgorithmName hash) {
        super(keyField);
        this.hashName = hash;
    }

    @Override
    public byte[] encode(Object value) {
        byte[] bytesValue = DataConverter.INSTANCE.toBytes(this.keyField.getDataType(), value);
        byte[] result = null;
        switch (this.hashName) {
            case JENKINS_32: {
                result = Bytes.toBytes((int)Jenkins32.instance().hash(bytesValue));
                break;
            }
            case MURMUR_32: {
                result = Bytes.toBytes((int)Murmur32.instance().hash(bytesValue));
                break;
            }
            case MURMUR_128: {
                result = Bytes.toBytes((long)Murmur128.instance().hash(bytesValue));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown hash, " + (Object)((Object)this.hashName));
            }
        }
        return result;
    }

    @Override
    public boolean checkEncodeOverflow(byte[] keyValue) {
        int delta = this.keyField.getMaxLength() - keyValue.length;
        return delta < 0;
    }

    @Override
    public Object decode(byte[] value) {
        throw new CodecException("operation not supported for codec - cannont decode a one-way hash");
    }

    @Override
    public byte[] encodeNext(Object value) {
        throw new CodecException("operation not supported for non-lexicographic codec");
    }
}

