/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping.codec;

import org.cloudgraph.common.hash.Jenkins32;
import org.cloudgraph.common.hash.Murmur128;
import org.cloudgraph.common.hash.Murmur32;
import org.cloudgraph.store.mapping.HashAlgorithmName;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.codec.CodecException;
import org.cloudgraph.store.mapping.codec.DefaultKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.plasma.sdo.DataType;
import org.plasma.sdo.helper.DataConverter;

public class LexicoHashKeyFieldCodec
extends DefaultKeyFieldCodec
implements KeyFieldCodec {
    protected HashAlgorithmName hashName;
    public static final int MAX_LENGTH = 11;

    @Override
    public boolean isLexicographic() {
        return true;
    }

    @Override
    public boolean isTransforming() {
        return true;
    }

    public LexicoHashKeyFieldCodec(KeyFieldMapping keyField, HashAlgorithmName hash) {
        super(keyField);
        this.hashName = hash;
    }

    @Override
    public byte[] encode(Object value) {
        byte[] bytesValue = null;
        switch (this.keyField.getDataFlavor()) {
            case other: 
            case temporal: {
                String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
                bytesValue = DataConverter.INSTANCE.toBytes(DataType.String, (Object)stringValue);
                break;
            }
            default: {
                bytesValue = DataConverter.INSTANCE.toBytes(this.keyField.getDataType(), value);
            }
        }
        String hashValueStr = null;
        switch (this.hashName) {
            case JENKINS_32: {
                int hashValue = Jenkins32.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Int, (Object)hashValue);
                break;
            }
            case MURMUR_32: {
                int hashValue = Murmur32.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Int, (Object)hashValue);
                break;
            }
            case MURMUR_128: {
                long hashValueLong = Murmur128.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Long, (Object)hashValueLong);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown hash, " + (Object)((Object)this.hashName));
            }
        }
        byte[] result = hashValueStr.getBytes(KeyFieldMapping.CHARSET);
        return result;
    }

    @Override
    public boolean checkEncodeOverflow(byte[] keyValue) {
        int delta = this.keyField.getMaxLength() - keyValue.length;
        return delta < 0;
    }

    @Override
    public Object decode(byte[] value) {
        throw new CodecException("operation not supported for codec - cannont decode a one-way hash");
    }

    @Override
    public byte[] encodeNext(Object value) {
        byte[] bytesValue = null;
        switch (this.keyField.getDataFlavor()) {
            case other: 
            case temporal: {
                String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
                bytesValue = DataConverter.INSTANCE.toBytes(DataType.String, (Object)stringValue);
                break;
            }
            default: {
                bytesValue = DataConverter.INSTANCE.toBytes(this.keyField.getDataType(), value);
            }
        }
        String hashValueStr = null;
        switch (this.hashName) {
            case JENKINS_32: {
                int hashValue = Jenkins32.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Int, (Object)(++hashValue));
                break;
            }
            case MURMUR_32: {
                int hashValue = Murmur32.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Int, (Object)(++hashValue));
                break;
            }
            case MURMUR_128: {
                long hashValueLong = Murmur128.instance().hash(bytesValue);
                hashValueStr = DataConverter.INSTANCE.toString(DataType.Long, (Object)(++hashValueLong));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown hash, " + (Object)((Object)this.hashName));
            }
        }
        byte[] result = hashValueStr.getBytes(KeyFieldMapping.CHARSET);
        return result;
    }
}

