/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping.codec;

import org.cloudgraph.common.Padding;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.codec.DefaultKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.helper.DataConverter;

public class LexicoPadKeyFieldCodec
extends DefaultKeyFieldCodec
implements KeyFieldCodec {
    private Padding padding = new Padding(KeyFieldMapping.CHARSET);

    public LexicoPadKeyFieldCodec(KeyFieldMapping keyField) {
        super(keyField);
    }

    @Override
    public boolean isLexicographic() {
        return true;
    }

    @Override
    public boolean isTransforming() {
        return false;
    }

    public int getMaxLength() {
        return this.keyField.getMaxLength();
    }

    public DataFlavor getDataFlavor() {
        return this.keyField.getDataFlavor();
    }

    @Override
    public byte[] encode(Object value) {
        String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
        byte[] bytesValue = stringValue.getBytes(KeyFieldMapping.CHARSET);
        return this.padding.pad(bytesValue, this.getMaxLength(), this.getDataFlavor());
    }

    @Override
    public boolean checkEncodeOverflow(byte[] keyValue) {
        int delta = this.keyField.getMaxLength() - keyValue.length;
        return delta < 0;
    }

    @Override
    public Object decode(byte[] value) {
        byte[] value2 = value;
        if (value[value.length - 1] == -128) {
            value2 = new byte[value.length - 1];
            System.arraycopy(value, 0, value2, 0, value.length - 1);
        }
        byte[] bytesValue = this.padding.strip(value2, this.getMaxLength(), this.getDataFlavor());
        String stringValue = new String(bytesValue, KeyFieldMapping.CHARSET);
        Object result = DataConverter.INSTANCE.fromString(this.keyField.getDataType(), stringValue);
        return result;
    }

    @Override
    public byte[] encodeNext(Object value) {
        String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
        byte[] bytesValue = stringValue.getBytes(KeyFieldMapping.CHARSET);
        byte[] paddedValue = this.padding.pad(bytesValue, this.getMaxLength(), this.getDataFlavor());
        byte[] result = new byte[paddedValue.length + 1];
        System.arraycopy(paddedValue, 0, result, 0, paddedValue.length);
        result[result.length - 1] = -128;
        return result;
    }
}

