/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping.codec;

import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.codec.DefaultKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.helper.DataConverter;

public class LexicoSimpleKeyFieldCodec
extends DefaultKeyFieldCodec
implements KeyFieldCodec {
    public LexicoSimpleKeyFieldCodec(KeyFieldMapping keyField) {
        super(keyField);
    }

    @Override
    public boolean isLexicographic() {
        return true;
    }

    @Override
    public boolean isTransforming() {
        return false;
    }

    @Override
    public byte[] encode(Object value) {
        String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
        byte[] result = stringValue.getBytes(KeyFieldMapping.CHARSET);
        return result;
    }

    @Override
    public boolean checkEncodeOverflow(byte[] keyValue) {
        int delta = this.keyField.getMaxLength() - keyValue.length;
        return delta < 0;
    }

    @Override
    public byte[] encodeNext(Object value) {
        String stringValue = DataConverter.INSTANCE.toString(this.keyField.getDataType(), value);
        byte[] bytesValue = stringValue.getBytes(KeyFieldMapping.CHARSET);
        byte[] result = new byte[bytesValue.length + 1];
        System.arraycopy(bytesValue, 0, result, 0, bytesValue.length);
        result[bytesValue.length] = -128;
        return result;
    }

    @Override
    public Object decode(byte[] value) {
        String stringResult = new String(value, KeyFieldMapping.CHARSET);
        Object result = DataConverter.INSTANCE.fromString(this.keyField.getDataType(), stringResult);
        return result;
    }

    public DataFlavor getDataFlavor() {
        return this.keyField.getDataFlavor();
    }
}

