/*
 * Decompiled with CFR 0.152.
 */
package org.cloudgraph.store.mapping.codec;

import java.math.BigInteger;
import org.apache.jena.ext.com.google.common.primitives.UnsignedInteger;
import org.apache.jena.ext.com.google.common.primitives.UnsignedLong;
import org.cloudgraph.store.mapping.KeyFieldMapping;
import org.cloudgraph.store.mapping.codec.CodecException;
import org.cloudgraph.store.mapping.codec.DefaultKeyFieldCodec;
import org.cloudgraph.store.mapping.codec.KeyFieldCodec;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.helper.DataConverter;

public class NativeKeyFieldCodec
extends DefaultKeyFieldCodec
implements KeyFieldCodec {
    private static final short INCREMENT_INTEGRAL = 1;

    public NativeKeyFieldCodec(KeyFieldMapping keyField) {
        super(keyField);
        this.keyField = keyField;
    }

    @Override
    public boolean isLexicographic() {
        return false;
    }

    @Override
    public boolean isTransforming() {
        return true;
    }

    @Override
    public byte[] encode(Object value) {
        byte[] bytesValue = DataConverter.INSTANCE.toBytes(this.keyField.getDataType(), value);
        return bytesValue;
    }

    @Override
    public boolean checkEncodeOverflow(byte[] keyValue) {
        int delta = this.keyField.getMaxLength() - keyValue.length;
        return delta < 0;
    }

    @Override
    public byte[] encodeNext(Object value) {
        throw new CodecException("operation not supported for non-lexicographic codec");
    }

    @Override
    public Object decode(byte[] value) {
        return DataConverter.INSTANCE.fromBytes(this.keyField.getDataType(), value);
    }

    public DataFlavor getDataFlavor() {
        return this.keyField.getDataFlavor();
    }

    private Object increment(Object value) {
        Number result = null;
        switch (this.keyField.getDataType()) {
            case Short: {
                Short shortValue = DataConverter.INSTANCE.toShort(DataType.Short, value);
                result = (short)(shortValue + 1);
                break;
            }
            case Int: {
                Integer intValue = DataConverter.INSTANCE.toInt(DataType.Int, value);
                result = intValue + 1;
                break;
            }
            case UnsignedInt: {
                UnsignedInteger uintValue = DataConverter.INSTANCE.toUnsignedInt(DataType.UnsignedInt, value);
                result = UnsignedInteger.valueOf((long)(uintValue.longValue() + 1L));
                break;
            }
            case Long: {
                Long longValue = DataConverter.INSTANCE.toLong(DataType.Long, value);
                result = longValue + 1L;
                break;
            }
            case UnsignedLong: {
                UnsignedLong ulongValue = DataConverter.INSTANCE.toUnsignedLong(DataType.UnsignedLong, value);
                BigInteger bigIntValue = ulongValue.bigIntegerValue();
                bigIntValue = bigIntValue.add(BigInteger.valueOf(1L));
                result = UnsignedLong.valueOf((BigInteger)bigIntValue);
                break;
            }
            case Integer: {
                BigInteger integerValue = DataConverter.INSTANCE.toInteger(DataType.Integer, value);
                result = integerValue.add(BigInteger.valueOf(1L));
                break;
            }
            default: {
                throw new CodecException("expected integral datatype not, " + this.keyField.getDataType().name());
            }
        }
        return result;
    }
}

