/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.OtpErlangPid;

class Links {
    Link[] links;
    int count;

    Links() {
        this(10);
    }

    Links(int initialSize) {
        this.links = new Link[initialSize];
        this.count = 0;
    }

    synchronized void addLink(OtpErlangPid local, OtpErlangPid remote) {
        if (this.find(local, remote) == -1) {
            if (this.count >= this.links.length) {
                Link[] tmp = new Link[this.count * 2];
                System.arraycopy(this.links, 0, tmp, 0, this.count);
                this.links = tmp;
            }
            this.links[this.count++] = new Link(local, remote);
        }
    }

    synchronized void removeLink(OtpErlangPid local, OtpErlangPid remote) {
        int i = this.find(local, remote);
        if (i != -1) {
            --this.count;
            this.links[i] = this.links[this.count];
            this.links[this.count] = null;
        }
    }

    synchronized boolean exists(OtpErlangPid local, OtpErlangPid remote) {
        return this.find(local, remote) != -1;
    }

    synchronized int find(OtpErlangPid local, OtpErlangPid remote) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.links[i].equals(local, remote)) continue;
            return i;
        }
        return -1;
    }

    int count() {
        return this.count;
    }

    synchronized OtpErlangPid[] localPids() {
        OtpErlangPid[] ret = null;
        if (this.count != 0) {
            ret = new OtpErlangPid[this.count];
            for (int i = 0; i < this.count; ++i) {
                ret[i] = this.links[i].local();
            }
        }
        return ret;
    }

    synchronized OtpErlangPid[] remotePids() {
        OtpErlangPid[] ret = null;
        if (this.count != 0) {
            ret = new OtpErlangPid[this.count];
            for (int i = 0; i < this.count; ++i) {
                ret[i] = this.links[i].remote();
            }
        }
        return ret;
    }

    synchronized Link[] clearLinks() {
        Link[] ret = null;
        if (this.count != 0) {
            ret = new Link[this.count];
            for (int i = 0; i < this.count; ++i) {
                ret[i] = this.links[i];
                this.links[i] = null;
            }
            this.count = 0;
        }
        return ret;
    }

    synchronized Link[] links() {
        Link[] ret = null;
        if (this.count != 0) {
            ret = new Link[this.count];
            System.arraycopy(this.links, 0, ret, 0, this.count);
        }
        return ret;
    }
}

