/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OtpErlangList
extends OtpErlangObject
implements Iterable<OtpErlangObject> {
    private static final long serialVersionUID = 5999112769036676548L;
    private static final OtpErlangObject[] NO_ELEMENTS = new OtpErlangObject[0];
    private final OtpErlangObject[] elems;
    private OtpErlangObject lastTail = null;

    public OtpErlangList() {
        this.elems = NO_ELEMENTS;
    }

    public OtpErlangList(String str) {
        if (str == null || str.length() == 0) {
            this.elems = NO_ELEMENTS;
        } else {
            int[] codePoints = OtpErlangString.stringToCodePoints(str);
            this.elems = new OtpErlangObject[codePoints.length];
            for (int i = 0; i < this.elems.length; ++i) {
                this.elems[i] = new OtpErlangInt(codePoints[i]);
            }
        }
    }

    public OtpErlangList(OtpErlangObject elem) {
        this.elems = new OtpErlangObject[]{elem};
    }

    public OtpErlangList(OtpErlangObject[] elems) {
        this(elems, 0, elems.length);
    }

    public OtpErlangList(OtpErlangObject[] elems, OtpErlangObject lastTail) throws OtpErlangException {
        this(elems, 0, elems.length);
        if (elems.length == 0 && lastTail != null) {
            throw new OtpErlangException("Bad list, empty head, non-empty tail");
        }
        this.lastTail = lastTail;
    }

    public OtpErlangList(OtpErlangObject[] elems, int start, int count) {
        if (elems != null && count > 0) {
            this.elems = new OtpErlangObject[count];
            System.arraycopy(elems, start, this.elems, 0, count);
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public OtpErlangList(OtpInputStream buf) throws OtpErlangDecodeException {
        int arity = buf.read_list_head();
        if (arity > 0) {
            this.elems = new OtpErlangObject[arity];
            for (int i = 0; i < arity; ++i) {
                this.elems[i] = buf.read_any();
            }
            if (buf.peek1() == 106) {
                buf.read_nil();
            } else {
                this.lastTail = buf.read_any();
            }
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public int arity() {
        return this.elems.length;
    }

    public OtpErlangObject elementAt(int i) {
        if (i >= this.arity() || i < 0) {
            return null;
        }
        return this.elems[i];
    }

    public OtpErlangObject[] elements() {
        if (this.arity() == 0) {
            return NO_ELEMENTS;
        }
        OtpErlangObject[] res = new OtpErlangObject[this.arity()];
        System.arraycopy(this.elems, 0, res, 0, res.length);
        return res;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    protected String toString(int start) {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = start; i < this.arity(); ++i) {
            if (i > start) {
                s.append(",");
            }
            s.append(this.elems[i].toString());
        }
        if (this.lastTail != null) {
            s.append("|").append(this.lastTail.toString());
        }
        s.append("]");
        return s.toString();
    }

    @Override
    public void encode(OtpOutputStream buf) {
        this.encode(buf, 0);
    }

    protected void encode(OtpOutputStream buf, int start) {
        int arity = this.arity() - start;
        if (arity > 0) {
            buf.write_list_head(arity);
            for (int i = start; i < arity + start; ++i) {
                buf.write_any(this.elems[i]);
            }
        }
        if (this.lastTail == null) {
            buf.write_nil();
        } else {
            buf.write_any(this.lastTail);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangList)) {
            return false;
        }
        OtpErlangList l = (OtpErlangList)o;
        int a = this.arity();
        if (a != l.arity()) {
            return false;
        }
        for (int i = 0; i < a; ++i) {
            if (this.elementAt(i).equals(l.elementAt(i))) continue;
            return false;
        }
        OtpErlangObject otherTail = l.getLastTail();
        if (this.getLastTail() == null && otherTail == null) {
            return true;
        }
        if (this.getLastTail() == null) {
            return false;
        }
        return this.getLastTail().equals(l.getLastTail());
    }

    @Override
    public <T> boolean match(OtpErlangObject term, T bindings) {
        if (!(term instanceof OtpErlangList)) {
            return false;
        }
        OtpErlangList that = (OtpErlangList)term;
        int thisArity = this.arity();
        int thatArity = that.arity();
        OtpErlangObject thisTail = this.getLastTail();
        OtpErlangObject thatTail = that.getLastTail();
        if (thisTail == null ? thisArity != thatArity || thatTail != null : thisArity > thatArity) {
            return false;
        }
        for (int i = 0; i < thisArity; ++i) {
            if (this.elementAt(i).match(that.elementAt(i), bindings)) continue;
            return false;
        }
        if (thisTail == null) {
            return true;
        }
        return thisTail.match(that.getNthTail(thisArity), bindings);
    }

    @Override
    public <T> OtpErlangObject bind(T binds) throws OtpErlangException {
        OtpErlangList list = (OtpErlangList)this.clone();
        int a = list.elems.length;
        for (int i = 0; i < a; ++i) {
            list.elems[i] = list.elems[i].bind(binds);
        }
        if (list.lastTail != null) {
            list.lastTail = list.lastTail.bind(binds);
        }
        return list;
    }

    public OtpErlangObject getLastTail() {
        return this.lastTail;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(4);
        int a = this.arity();
        if (a == 0) {
            return -826096594;
        }
        for (int i = 0; i < a; ++i) {
            hash.combine(this.elementAt(i).hashCode());
        }
        OtpErlangObject t = this.getLastTail();
        if (t != null) {
            int h = t.hashCode();
            hash.combine(h, h);
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        try {
            return new OtpErlangList(this.elements(), this.getLastTail());
        }
        catch (OtpErlangException e) {
            throw new AssertionError(this);
        }
    }

    @Override
    public Iterator<OtpErlangObject> iterator() {
        return this.iterator(0);
    }

    private Iterator<OtpErlangObject> iterator(int start) {
        return new Itr(start);
    }

    public boolean isProper() {
        return this.lastTail == null;
    }

    public OtpErlangObject getHead() {
        if (this.arity() > 0) {
            return this.elems[0];
        }
        return null;
    }

    public OtpErlangObject getTail() {
        return this.getNthTail(1);
    }

    public OtpErlangObject getNthTail(int n) {
        int arity = this.arity();
        if (arity >= n) {
            if (arity == n && this.lastTail != null) {
                return this.lastTail;
            }
            return new SubList(this, n);
        }
        return null;
    }

    public String stringValue() throws OtpErlangException {
        if (!this.isProper()) {
            throw new OtpErlangException("Non-proper list: " + this);
        }
        int[] values = new int[this.arity()];
        for (int i = 0; i < values.length; ++i) {
            OtpErlangObject o = this.elementAt(i);
            if (!(o instanceof OtpErlangLong)) {
                throw new OtpErlangException("Non-integer term: " + o);
            }
            OtpErlangLong l = (OtpErlangLong)o;
            values[i] = l.intValue();
        }
        return new String(values, 0, values.length);
    }

    private class Itr
    implements Iterator<OtpErlangObject> {
        private int cursor;

        private Itr(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < OtpErlangList.this.elems.length;
        }

        @Override
        public OtpErlangObject next() {
            try {
                return OtpErlangList.this.elems[this.cursor++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("OtpErlangList cannot be modified!");
        }
    }

    public static class SubList
    extends OtpErlangList {
        private static final long serialVersionUID = 5999112769036676548L;
        private final int start;
        private final OtpErlangList parent;

        private SubList(OtpErlangList parent, int start) {
            this.parent = parent;
            this.start = start;
        }

        @Override
        public int arity() {
            return this.parent.arity() - this.start;
        }

        @Override
        public OtpErlangObject elementAt(int i) {
            return this.parent.elementAt(i + this.start);
        }

        @Override
        public OtpErlangObject[] elements() {
            int n = this.parent.arity() - this.start;
            OtpErlangObject[] res = new OtpErlangObject[n];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.parent.elementAt(i + this.start);
            }
            return res;
        }

        @Override
        public boolean isProper() {
            return this.parent.isProper();
        }

        @Override
        public OtpErlangObject getHead() {
            return this.parent.elementAt(this.start);
        }

        @Override
        public OtpErlangObject getNthTail(int n) {
            return this.parent.getNthTail(n + this.start);
        }

        @Override
        public String toString() {
            return this.parent.toString(this.start);
        }

        @Override
        public void encode(OtpOutputStream stream) {
            this.parent.encode(stream, this.start);
        }

        @Override
        public OtpErlangObject getLastTail() {
            return this.parent.getLastTail();
        }

        @Override
        public Iterator<OtpErlangObject> iterator() {
            return this.parent.iterator(this.start);
        }
    }
}

