/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangPid
extends OtpErlangObject
implements Comparable<Object> {
    private static final long serialVersionUID = 1664394142301803659L;
    private final int tag;
    private final String node;
    private final int id;
    private final int serial;
    private final int creation;

    @Deprecated
    public OtpErlangPid(OtpLocalNode self) {
        OtpErlangPid p = self.createPid();
        this.tag = p.tag;
        this.id = p.id;
        this.serial = p.serial;
        this.creation = p.creation;
        this.node = p.node;
    }

    public OtpErlangPid(OtpInputStream buf) throws OtpErlangDecodeException {
        OtpErlangPid p = buf.read_pid();
        this.tag = p.tag;
        this.node = p.node();
        this.id = p.id();
        this.serial = p.serial();
        this.creation = p.creation();
    }

    public OtpErlangPid(String node, int id, int serial, int creation) {
        this(103, node, id, serial, creation);
    }

    protected OtpErlangPid(int tag, String node, int id, int serial, int creation) {
        this.tag = tag;
        this.node = node;
        if (tag == 103) {
            this.id = id & Short.MAX_VALUE;
            this.serial = serial & 0x1FFF;
            this.creation = creation & 3;
        } else {
            this.id = id;
            this.serial = serial;
            this.creation = creation;
        }
    }

    protected int tag() {
        return this.tag;
    }

    public int serial() {
        return this.serial;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        return "#Pid<" + this.node.toString() + "." + this.id + "." + this.serial + ">";
    }

    @Override
    public void encode(OtpOutputStream buf) {
        buf.write_pid(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangPid)) {
            return false;
        }
        OtpErlangPid pid = (OtpErlangPid)o;
        return this.creation == pid.creation && this.serial == pid.serial && this.id == pid.id && this.node.compareTo(pid.node) == 0;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(5);
        hash.combine(this.creation, this.serial);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof OtpErlangPid)) {
            return -1;
        }
        OtpErlangPid pid = (OtpErlangPid)o;
        if (this.creation == pid.creation) {
            if (this.serial == pid.serial) {
                if (this.id == pid.id) {
                    return this.node.compareTo(pid.node);
                }
                return this.id - pid.id;
            }
            return this.serial - pid.serial;
        }
        return this.creation - pid.creation;
    }
}

