/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangPort;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class OtpOutputStream
extends ByteArrayOutputStream {
    public static final int defaultInitialSize = 2048;
    public static final int defaultIncrement = 2048;
    private static final DecimalFormat eform = new DecimalFormat("e+00;e-00");
    private static final BigDecimal ten = new BigDecimal(10.0);
    private static final BigDecimal one = new BigDecimal(1.0);
    private int fixedSize = Integer.MAX_VALUE;

    public OtpOutputStream() {
        this(2048);
    }

    public OtpOutputStream(int size) {
        super(size);
    }

    public OtpOutputStream(OtpErlangObject o) {
        this();
        this.write_any(o);
    }

    OtpInputStream getOtpInputStream(int offset) {
        return new OtpInputStream(this.buf, offset, this.count - offset, 0);
    }

    public int getPos() {
        return this.count;
    }

    public void trimToSize() {
        this.resize(this.count);
    }

    private void resize(int size) {
        if (size < this.buf.length) {
            byte[] tmp = new byte[size];
            System.arraycopy(this.buf, 0, tmp, 0, size);
            this.buf = tmp;
        } else if (size > this.buf.length) {
            this.ensureCapacity(size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.fixedSize) {
            throw new IllegalArgumentException("Trying to increase fixed-size buffer");
        }
        int oldCapacity = this.buf.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < oldCapacity + 2048) {
                newCapacity = oldCapacity + 2048;
            }
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            newCapacity = Math.min(this.fixedSize, newCapacity);
            byte[] tmp = new byte[newCapacity];
            System.arraycopy(this.buf, 0, tmp, 0, this.count);
            this.buf = tmp;
        }
    }

    public void write(byte b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count++] = b;
    }

    @Override
    public void write(byte[] abuf) {
        this.write(abuf, 0, abuf.length);
    }

    @Override
    public synchronized void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public synchronized void writeTo(OutputStream out) throws IOException {
        super.writeTo(out);
    }

    public synchronized void writeToAndFlush(OutputStream out) throws IOException {
        super.writeTo(out);
        out.flush();
    }

    public void write1(long n) {
        this.write((byte)(n & 0xFFL));
    }

    public void writeN(byte[] bytes) {
        this.write(bytes);
    }

    public int length() {
        return this.buf.length;
    }

    @Deprecated
    public int count() {
        return this.count;
    }

    public void write2BE(long n) {
        this.write((byte)((n & 0xFF00L) >> 8));
        this.write((byte)(n & 0xFFL));
    }

    public void write4BE(long n) {
        this.write((byte)((n & 0xFFFFFFFFFF000000L) >> 24));
        this.write((byte)((n & 0xFF0000L) >> 16));
        this.write((byte)((n & 0xFF00L) >> 8));
        this.write((byte)(n & 0xFFL));
    }

    public void write8BE(long n) {
        this.write((byte)(n >> 56 & 0xFFL));
        this.write((byte)(n >> 48 & 0xFFL));
        this.write((byte)(n >> 40 & 0xFFL));
        this.write((byte)(n >> 32 & 0xFFL));
        this.write((byte)(n >> 24 & 0xFFL));
        this.write((byte)(n >> 16 & 0xFFL));
        this.write((byte)(n >> 8 & 0xFFL));
        this.write((byte)(n & 0xFFL));
    }

    public void writeLE(long n, int b) {
        long v = n;
        for (int i = 0; i < b; ++i) {
            this.write((byte)(v & 0xFFL));
            v >>= 8;
        }
    }

    public void write2LE(long n) {
        this.write((byte)(n & 0xFFL));
        this.write((byte)((n & 0xFF00L) >> 8));
    }

    public void write4LE(long n) {
        this.write((byte)(n & 0xFFL));
        this.write((byte)((n & 0xFF00L) >> 8));
        this.write((byte)((n & 0xFF0000L) >> 16));
        this.write((byte)((n & 0xFFFFFFFFFF000000L) >> 24));
    }

    public void write8LE(long n) {
        this.write((byte)(n & 0xFFL));
        this.write((byte)(n >> 8 & 0xFFL));
        this.write((byte)(n >> 16 & 0xFFL));
        this.write((byte)(n >> 24 & 0xFFL));
        this.write((byte)(n >> 32 & 0xFFL));
        this.write((byte)(n >> 40 & 0xFFL));
        this.write((byte)(n >> 48 & 0xFFL));
        this.write((byte)(n >> 56 & 0xFFL));
    }

    public void poke4BE(int offset, long n) {
        if (offset < this.count) {
            this.buf[offset + 0] = (byte)((n & 0xFFFFFFFFFF000000L) >> 24);
            this.buf[offset + 1] = (byte)((n & 0xFF0000L) >> 16);
            this.buf[offset + 2] = (byte)((n & 0xFF00L) >> 8);
            this.buf[offset + 3] = (byte)(n & 0xFFL);
        }
    }

    public void write_atom(String atom) {
        String enc_atom = atom.codePointCount(0, atom.length()) <= 255 ? atom : new String(OtpErlangString.stringToCodePoints(atom), 0, 255);
        try {
            byte[] bytes = enc_atom.getBytes("UTF-8");
            int length = bytes.length;
            if (length < 256) {
                this.write1(119L);
                this.write1(length);
            } else {
                this.write1(118L);
                this.write2BE(length);
            }
            this.writeN(bytes);
        }
        catch (UnsupportedEncodingException e) {
            this.write1(119L);
            this.write1(2L);
            this.write2BE(65535L);
        }
    }

    public void write_binary(byte[] bin) {
        this.write1(109L);
        this.write4BE(bin.length);
        this.writeN(bin);
    }

    public void write_bitstr(byte[] bin, int pad_bits) {
        if (pad_bits == 0) {
            this.write_binary(bin);
            return;
        }
        this.write1(77L);
        this.write4BE(bin.length);
        this.write1(8 - pad_bits);
        this.writeN(bin);
    }

    public void write_boolean(boolean b) {
        this.write_atom(String.valueOf(b));
    }

    public void write_byte(byte b) {
        this.write_long((long)b & 0xFFL, true);
    }

    public void write_char(char c) {
        this.write_long((long)c & 0xFFFFL, true);
    }

    public void write_double(double d) {
        this.write1(70L);
        this.write8BE(Double.doubleToLongBits(d));
    }

    public void write_float(float f) {
        this.write_double(f);
    }

    public void write_big_integer(BigInteger v) {
        if (v.bitLength() < 64) {
            this.write_long(v.longValue(), true);
            return;
        }
        int signum = v.signum();
        BigInteger val = v;
        if (signum < 0) {
            val = val.negate();
        }
        byte[] magnitude = val.toByteArray();
        int n = magnitude.length;
        int j = n;
        for (int i = 0; i < j--; ++i) {
            byte b = magnitude[i];
            magnitude[i] = magnitude[j];
            magnitude[j] = b;
        }
        if ((n & 0xFF) == n) {
            this.write1(110L);
            this.write1(n);
        } else {
            this.write1(111L);
            this.write4BE(n);
        }
        this.write1(signum < 0 ? 1L : 0L);
        this.writeN(magnitude);
    }

    void write_long(long v, boolean unsigned) {
        if ((v & 0xFFL) == v) {
            this.write1(97L);
            this.write1(v);
        } else if (v < 0L && unsigned || v < -134217728L || v > 0x7FFFFFFL) {
            long abs;
            long l = unsigned ? v : (abs = v < 0L ? -v : v);
            int sign = unsigned ? 0 : (v < 0L ? 1 : 0);
            long mask = 0xFFFFFFFFL;
            int n = 4;
            while ((abs & mask) != abs) {
                ++n;
                mask = mask << 8 | 0xFFL;
            }
            this.write1(110L);
            this.write1(n);
            this.write1(sign);
            this.writeLE(abs, n);
        } else {
            this.write1(98L);
            this.write4BE(v);
        }
    }

    public void write_long(long l) {
        this.write_long(l, false);
    }

    public void write_ulong(long ul) {
        this.write_long(ul, true);
    }

    public void write_int(int i) {
        this.write_long(i, false);
    }

    public void write_uint(int ui) {
        this.write_long((long)ui & 0xFFFFFFFFL, true);
    }

    public void write_short(short s) {
        this.write_long(s, false);
    }

    public void write_ushort(short us) {
        this.write_long((long)us & 0xFFFFL, true);
    }

    public void write_list_head(int arity) {
        if (arity == 0) {
            this.write_nil();
        } else {
            this.write1(108L);
            this.write4BE(arity);
        }
    }

    public void write_nil() {
        this.write1(106L);
    }

    public void write_tuple_head(int arity) {
        if (arity < 255) {
            this.write1(104L);
            this.write1(arity);
        } else {
            this.write1(105L);
            this.write4BE(arity);
        }
    }

    public void write_pid(String node, int id, int serial, int creation) {
        this.write1(103L);
        this.write_atom(node);
        this.write4BE(id & Short.MAX_VALUE);
        this.write4BE(serial & 0x1FFF);
        this.write1(creation & 3);
    }

    public void write_pid(OtpErlangPid pid) {
        this.write1(pid.tag());
        this.write_atom(pid.node());
        this.write4BE(pid.id());
        this.write4BE(pid.serial());
        switch (pid.tag()) {
            case 103: {
                this.write1(pid.creation());
                break;
            }
            case 88: {
                this.write4BE(pid.creation());
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid pid tag " + pid.tag()));
            }
        }
    }

    public void write_port(String node, int id, int creation) {
        this.write1(102L);
        this.write_atom(node);
        this.write4BE(id & 0xFFFFFFF);
        this.write1(creation & 3);
    }

    public void write_port(OtpErlangPort port) {
        this.write1(port.tag());
        this.write_atom(port.node());
        this.write4BE(port.id());
        switch (port.tag()) {
            case 102: {
                this.write1(port.creation());
                break;
            }
            case 89: {
                this.write4BE(port.creation());
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid port tag " + port.tag()));
            }
        }
    }

    public void write_ref(String node, int id, int creation) {
        int[] ids = new int[]{id};
        this.write_ref(node, ids, creation);
    }

    public void write_ref(String node, int[] ids, int creation) {
        int arity = ids.length;
        if (arity > 3) {
            arity = 3;
        }
        this.write1(114L);
        this.write2BE(arity);
        this.write_atom(node);
        this.write1(creation & 3);
        this.write4BE(ids[0] & 0x3FFFF);
        for (int i = 1; i < arity; ++i) {
            this.write4BE(ids[i]);
        }
    }

    public void write_ref(OtpErlangRef ref) {
        int[] ids = ref.ids();
        int arity = ids.length;
        this.write1(ref.tag());
        this.write2BE(arity);
        this.write_atom(ref.node());
        switch (ref.tag()) {
            case 114: {
                this.write1(ref.creation());
                this.write4BE(ids[0] & 0x3FFFF);
                break;
            }
            case 90: {
                this.write4BE(ref.creation());
                this.write4BE(ids[0]);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid ref tag " + ref.tag()));
            }
        }
        for (int i = 1; i < arity; ++i) {
            this.write4BE(ids[i]);
        }
    }

    public void write_string(String s) {
        int len = s.length();
        switch (len) {
            case 0: {
                this.write_nil();
                break;
            }
            default: {
                if (len <= 65535 && this.is8bitString(s)) {
                    try {
                        byte[] bytebuf = s.getBytes("ISO-8859-1");
                        this.write1(107L);
                        this.write2BE(len);
                        this.writeN(bytebuf);
                    }
                    catch (UnsupportedEncodingException e) {
                        this.write_nil();
                    }
                    break;
                }
                int[] codePoints = OtpErlangString.stringToCodePoints(s);
                this.write_list_head(codePoints.length);
                for (int codePoint : codePoints) {
                    this.write_int(codePoint);
                }
                this.write_nil();
            }
        }
    }

    private boolean is8bitString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public void write_compressed(OtpErlangObject o) {
        this.write_compressed(o, -1);
    }

    public void write_compressed(OtpErlangObject o, int level) {
        int destCount;
        OtpOutputStream oos = new OtpOutputStream(o);
        if (oos.size() < 5) {
            try {
                oos.writeToAndFlush(this);
                this.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Intermediate stream failed for Erlang object " + o);
            }
        }
        int startCount = this.count;
        this.fixedSize = destCount = startCount + oos.size();
        Deflater def = new Deflater(level);
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)this, def);
        try {
            this.write1(80L);
            this.write4BE(oos.size());
            oos.writeTo(dos);
            dos.close();
        }
        catch (IllegalArgumentException e) {
            def.end();
            this.count = startCount;
            try {
                oos.writeTo(this);
                this.close();
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("Intermediate stream failed for Erlang object " + o);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Intermediate stream failed for Erlang object " + o);
        }
        finally {
            this.fixedSize = Integer.MAX_VALUE;
        }
    }

    public void write_any(OtpErlangObject o) {
        o.encode(this);
    }

    public void write_fun(OtpErlangPid pid, String module, long old_index, int arity, byte[] md5, long index, long uniq, OtpErlangObject[] freeVars) {
        if (arity == -1) {
            this.write1(117L);
            this.write4BE(freeVars.length);
            pid.encode(this);
            this.write_atom(module);
            this.write_long(index);
            this.write_long(uniq);
            for (OtpErlangObject fv : freeVars) {
                fv.encode(this);
            }
        } else {
            this.write1(112L);
            int saveSizePos = this.getPos();
            this.write4BE(0L);
            this.write1(arity);
            this.writeN(md5);
            this.write4BE(index);
            this.write4BE(freeVars.length);
            this.write_atom(module);
            this.write_long(old_index);
            this.write_long(uniq);
            pid.encode(this);
            for (OtpErlangObject fv : freeVars) {
                fv.encode(this);
            }
            this.poke4BE(saveSizePos, this.getPos() - saveSizePos);
        }
    }

    public void write_external_fun(String module, String function, int arity) {
        this.write1(113L);
        this.write_atom(module);
        this.write_atom(function);
        this.write_long(arity);
    }

    public void write_map_head(int arity) {
        this.write1(116L);
        this.write4BE(arity);
    }
}

