/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;

public abstract class VmAllocationPolicyAbstract
implements VmAllocationPolicy {
    private Datacenter datacenter;
    private Map<Host, Long> hostFreePesMap;
    private Map<Vm, Long> usedPes;

    public VmAllocationPolicyAbstract() {
        this.setDatacenter(Datacenter.NULL);
    }

    @Override
    public final <T extends Host> List<T> getHostList() {
        return this.datacenter.getHostList();
    }

    @Override
    public boolean allocateHostForVm(Vm vm) {
        Host host;
        switch (vm.getId()) {
            case 0: 
            case 1: 
            case 2: {
                host = (Host)this.getHostList().get(0);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                host = (Host)this.getHostList().get(1);
                break;
            }
            default: {
                host = (Host)this.getHostList().get(0);
            }
        }
        return this.allocateHostForVm(vm, host);
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        if (Objects.isNull(datacenter)) {
            datacenter = Datacenter.NULL;
        }
        this.datacenter = datacenter;
        this.addPesFromHostsToFreePesList();
    }

    private void addPesFromHostsToFreePesList() {
        this.setHostFreePesMap(new HashMap<Host, Long>(this.getHostList().size()));
        this.setUsedPes(new HashMap<Vm, Long>());
        this.getHostList().forEach(host -> this.hostFreePesMap.put((Host)host, host.getNumberOfWorkingPes()));
    }

    protected final Map<Host, Long> getHostFreePesMap() {
        return this.hostFreePesMap;
    }

    protected final VmAllocationPolicy setHostFreePesMap(Map<Host, Long> hostFreePesMap) {
        this.hostFreePesMap = hostFreePesMap;
        return this;
    }

    protected Map<Vm, Long> getUsedPes() {
        return this.usedPes;
    }

    protected void addUsedPes(Vm vm) {
        this.usedPes.put(vm, vm.getNumberOfPes());
    }

    protected long removeUsedPes(Vm vm) {
        Long pes = this.usedPes.remove(vm);
        return pes == null ? 0L : pes;
    }

    protected final void setUsedPes(Map<Vm, Long> usedPes) {
        Objects.requireNonNull(usedPes);
        this.usedPes = usedPes;
    }

    @Override
    public boolean scaleVmVertically(VerticalVmScaling scaling) {
        if (scaling.isVmUnderloaded()) {
            return this.downScaleVmVertically(scaling);
        }
        if (scaling.isVmOverloaded()) {
            return this.upScaleVmVertically(scaling);
        }
        return false;
    }

    private boolean upScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.upScaleVmNonCpuResource(scaling);
    }

    private boolean downScaleVmVertically(VerticalVmScaling scaling) {
        return this.isRequestingCpuScaling(scaling) ? this.scaleVmPesUpOrDown(scaling) : this.downScaleVmNonCpuResource(scaling);
    }

    private boolean scaleVmPesUpOrDown(VerticalVmScaling scaling) {
        double numberOfPesForScaling = scaling.getResourceAmountToScale();
        if (numberOfPesForScaling == 0.0) {
            return false;
        }
        Vm vm = scaling.getVm();
        if (scaling.isVmOverloaded() && this.isNotHostPesSuitableToUpScaleVm(scaling)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        vm.getHost().getVmScheduler().deallocatePesFromVm(vm);
        if (scaling.isVmUnderloaded()) {
            vm.getProcessor().removeCapacity((long)numberOfPesForScaling);
        } else {
            vm.getProcessor().addCapacity((long)numberOfPesForScaling);
        }
        vm.getHost().getVmScheduler().allocatePesForVm(vm);
        return true;
    }

    private boolean isNotHostPesSuitableToUpScaleVm(VerticalVmScaling scaling) {
        Vm vm = scaling.getVm();
        double numberOfPesForScaling = scaling.getResourceAmountToScale();
        List<Double> additionalVmMips = LongStream.range(0L, (long)numberOfPesForScaling).mapToObj(i -> vm.getMips()).collect(Collectors.toList());
        return !vm.getHost().getVmScheduler().isSuitableForVm(additionalVmMips);
    }

    private boolean isRequestingCpuScaling(VerticalVmScaling scaling) {
        return Processor.class.equals(scaling.getResourceClass());
    }

    private boolean upScaleVmNonCpuResource(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double extraAmountToAllocate = scaling.getResourceAmountToScale();
        if (!hostResource.isResourceAmountAvailable(extraAmountToAllocate)) {
            return false;
        }
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() + extraAmountToAllocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            this.showResourceIsUnavailable(scaling);
            return false;
        }
        Log.printFormattedLine("%.2f: %s: %.0f more %s allocated to Vm %d: new capacity is %d. Current resource usage is %.2f%%", scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm().getId(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0);
        return true;
    }

    private void showResourceIsUnavailable(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable hostResource = scaling.getVm().getHost().getResource(resourceClass);
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double extraAmountToAllocate = scaling.getResourceAmountToScale();
        Log.printFormattedLine("%.2f: %s: Vm %d requested more %d of %s capacity but the Host %d has just %d of available %s", scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), scaling.getVm().getId(), extraAmountToAllocate, resourceClass.getSimpleName(), scaling.getVm().getHost().getId(), hostResource.getAvailableResource(), resourceClass.getSimpleName());
    }

    private boolean downScaleVmNonCpuResource(VerticalVmScaling scaling) {
        Class<? extends ResourceManageable> resourceClass = scaling.getResourceClass();
        ResourceManageable vmResource = scaling.getVm().getResource(resourceClass);
        double amountToDeallocate = scaling.getResourceAmountToScale();
        ResourceProvisioner provisioner = scaling.getVm().getHost().getProvisioner(resourceClass);
        double newTotalVmResource = (double)vmResource.getCapacity() - amountToDeallocate;
        if (!provisioner.allocateResourceForVm(scaling.getVm(), newTotalVmResource)) {
            Log.printFormattedLine("%.2f: %s: Vm %d requested to reduce %s capacity by %d but an unexpected error occurred and the resource was not resized", scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), scaling.getVm().getId(), resourceClass.getSimpleName(), amountToDeallocate);
            return false;
        }
        Log.printFormattedLine("%.2f: %s: %d %s deallocated from Vm %d: new capacity is %d. Current resource usage is %.2f%%", scaling.getVm().getSimulation().clock(), scaling.getClass().getSimpleName(), amountToDeallocate, resourceClass.getSimpleName(), scaling.getVm().getId(), vmResource.getCapacity(), vmResource.getPercentUtilization() * 100.0);
        return true;
    }
}

