/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.core.Identificable;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class VmAllocationPolicySimple
extends VmAllocationPolicyAbstract {
    @Override
    public boolean allocateHostForVm(Vm vm) {
        if (this.getHostList().isEmpty()) {
            Log.printFormattedLine("%.2f: %s: Vm %s could not be allocated because there isn't any Host for Datacenter %d", vm.getSimulation().clock(), vm.getId(), this.getDatacenter().getId());
            return false;
        }
        if (vm.isCreated()) {
            return false;
        }
        ArrayList<Host> hostsWhereVmCreationFailed = new ArrayList<Host>();
        for (int tries = 0; tries < this.getHostFreePesMap().size(); ++tries) {
            Host host = this.getHostWithLessUsedPes(hostsWhereVmCreationFailed);
            if (this.allocateHostForVm(vm, host)) {
                return true;
            }
            hostsWhereVmCreationFailed.add(host);
        }
        return false;
    }

    @Override
    public boolean allocateHostForVm(Vm vm, Host host) {
        if (!host.createVm(vm)) {
            return false;
        }
        this.addUsedPes(vm);
        this.getHostFreePesMap().put(host, this.getHostFreePesMap().get(host) - vm.getNumberOfPes());
        Log.printFormattedLine("%.2f: %s: VM #%d has been allocated to the host #%d", vm.getSimulation().clock(), this.getClass().getSimpleName(), vm.getId(), host.getId());
        return true;
    }

    private Host getHostWithLessUsedPes(List<Host> ignoredHosts) {
        Map<Host, Long> map = this.getHostFreePesMap();
        return map.keySet().stream().filter(h -> !ignoredHosts.contains(h)).sorted(Comparator.comparingInt(Identificable::getId)).max(Comparator.comparingLong(h -> (Long)map.get(h))).orElseGet(() -> Host.NULL);
    }

    @Override
    public void deallocateHostForVm(Vm vm) {
        Host host = vm.getHost();
        long pes = this.removeUsedPes(vm);
        if (host != Host.NULL) {
            host.destroyVm(vm);
            this.getHostFreePesMap().put(host, this.getHostFreePesMap().get(host) + pes);
        }
    }

    @Override
    public Map<Vm, Host> optimizeAllocation(List<? extends Vm> vmList) {
        return Collections.EMPTY_MAP;
    }
}

