/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.power;

import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicy;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class PowerVmAllocationPolicyAbstract
extends VmAllocationPolicyAbstract
implements PowerVmAllocationPolicy {
    @Override
    public boolean allocateHostForVm(Vm vm) {
        return this.allocateHostForVm(vm, this.findHostForVm(vm));
    }

    @Override
    public boolean allocateHostForVm(Vm vm, Host host) {
        Simulation simulation = vm.getSimulation();
        if (host == PowerHost.NULL) {
            Log.printFormattedLine("%.2f: No suitable host found for VM #" + vm.getId() + "\n", simulation.clock());
            return false;
        }
        if (host.createVm(vm)) {
            Log.printFormattedLine("%.2f: VM #" + vm.getId() + " has been allocated to the host #" + host.getId(), simulation.clock());
            return true;
        }
        Log.printFormattedLine("%.2f: Creation of VM #" + vm.getId() + " on the host #" + host.getId() + " failed\n", simulation.clock());
        return false;
    }

    @Override
    public PowerHost findHostForVm(Vm vm) {
        return this.getHostList().stream().sorted().filter(h -> h.isSuitableForVm(vm)).findFirst().orElse(PowerHost.NULL);
    }

    @Override
    public void deallocateHostForVm(Vm vm) {
        vm.getHost().destroyVm(vm);
    }
}

