/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.power;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigration;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.hosts.power.PowerHostUtilizationHistory;
import org.cloudbus.cloudsim.lists.VmList;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class PowerVmAllocationPolicyMigrationAbstract
extends PowerVmAllocationPolicyAbstract
implements PowerVmAllocationPolicyMigration {
    private double underUtilizationThreshold = 0.35;
    private PowerVmSelectionPolicy vmSelectionPolicy;
    private final Map<Vm, Host> savedAllocation = new HashMap<Vm, Host>();
    private final Map<Host, List<Double>> utilizationHistory = new HashMap<Host, List<Double>>();
    private final Map<Host, List<Double>> metricHistory = new HashMap<Host, List<Double>>();
    private final Map<Host, List<Double>> timeHistory = new HashMap<Host, List<Double>>();

    public PowerVmAllocationPolicyMigrationAbstract(PowerVmSelectionPolicy vmSelectionPolicy) {
        this.setVmSelectionPolicy(vmSelectionPolicy);
    }

    @Override
    public Map<Vm, Host> optimizeAllocation(List<? extends Vm> vmList) {
        Set<PowerHostUtilizationHistory> overloadedHosts = this.getOverloadedHosts();
        this.printOverUtilizedHosts(overloadedHosts);
        this.saveAllocation();
        Map<Vm, Host> migrationMap = this.getMigrationMapFromOverloadedHosts(overloadedHosts);
        this.updateMigrationMapFromUnderloadedHosts(overloadedHosts, migrationMap);
        this.restoreAllocation();
        return migrationMap;
    }

    private void updateMigrationMapFromUnderloadedHosts(Set<PowerHostUtilizationHistory> overloadedHosts, Map<Vm, Host> migrationMap) {
        PowerHost underloadedHost;
        List<PowerHost> switchedOffHosts = this.getSwitchedOffHosts();
        HashSet<Host> excludedHostsFromUnderloadSearch = new HashSet<Host>();
        excludedHostsFromUnderloadSearch.addAll(overloadedHosts);
        excludedHostsFromUnderloadSearch.addAll(switchedOffHosts);
        excludedHostsFromUnderloadSearch.addAll(migrationMap.values());
        HashSet<PowerHost> excludedHostsForFindingNewVmPlacement = new HashSet<PowerHost>();
        excludedHostsForFindingNewVmPlacement.addAll(overloadedHosts);
        excludedHostsForFindingNewVmPlacement.addAll(switchedOffHosts);
        int numberOfHosts = this.getHostList().size();
        while (numberOfHosts != excludedHostsFromUnderloadSearch.size() && (underloadedHost = this.getUnderloadedHost(excludedHostsFromUnderloadSearch)) != PowerHost.NULL) {
            Log.printFormattedLine("%.2f: PowerVmAllocationPolicy: Underloaded hosts: %s", this.getDatacenter().getSimulation().clock(), underloadedHost);
            excludedHostsFromUnderloadSearch.add(underloadedHost);
            excludedHostsForFindingNewVmPlacement.add(underloadedHost);
            List<? extends Vm> vmsToMigrateFromUnderloadedHost = this.getVmsToMigrateFromUnderUtilizedHost(underloadedHost);
            if (vmsToMigrateFromUnderloadedHost.isEmpty()) continue;
            Log.printFormatted("\tVMs to be reallocated from the underloaded Host %d: ", underloadedHost.getId());
            this.printVmIds(vmsToMigrateFromUnderloadedHost);
            Map<Vm, Host> newVmPlacement = this.getNewVmPlacementFromUnderloadedHost(vmsToMigrateFromUnderloadedHost, excludedHostsForFindingNewVmPlacement);
            excludedHostsFromUnderloadSearch.addAll(this.extractHostListFromMigrationMap(newVmPlacement));
            migrationMap.putAll(newVmPlacement);
            Log.printLine();
        }
    }

    private void printVmIds(List<? extends Vm> vmList) {
        if (!Log.isDisabled()) {
            vmList.forEach(vm -> Log.printFormatted("Vm %d ", vm.getId()));
            Log.printLine();
        }
    }

    private void printOverUtilizedHosts(Set<PowerHostUtilizationHistory> overloadedHosts) {
        if (!Log.isDisabled() && !overloadedHosts.isEmpty()) {
            Log.printFormattedLine("%.2f: PowerVmAllocationPolicy: Overloaded hosts in %s: %s", this.getDatacenter().getSimulation().clock(), this.getDatacenter(), overloadedHosts.stream().map(h -> String.valueOf(h.getId())).collect(Collectors.joining(",")));
        }
    }

    protected double getPowerAfterAllocationDifference(PowerHost host, Vm vm) {
        double powerAfterAllocation = this.getPowerAfterAllocation(host, vm);
        if (powerAfterAllocation > 0.0) {
            return powerAfterAllocation - host.getPower();
        }
        return 0.0;
    }

    protected boolean isNotHostOverloadedAfterAllocation(PowerHost host, Vm vm) {
        boolean isHostOverUsedAfterAllocation = true;
        if (host.createTemporaryVm(vm)) {
            isHostOverUsedAfterAllocation = this.isHostOverloaded(host);
            host.destroyTemporaryVm(vm);
        }
        return !isHostOverUsedAfterAllocation;
    }

    @Override
    public PowerHost findHostForVm(Vm vm) {
        HashSet<Host> excludedHosts = new HashSet<Host>();
        excludedHosts.add(vm.getHost());
        return this.findHostForVm(vm, excludedHosts);
    }

    public PowerHost findHostForVm(Vm vm, Set<? extends Host> excludedHosts) {
        return this.findHostForVm(vm, excludedHosts, host -> true);
    }

    public PowerHost findHostForVm(Vm vm, Set<? extends Host> excludedHosts, Predicate<PowerHost> predicate) {
        Stream<PowerHost> stream = this.getHostList().stream().filter(h -> !excludedHosts.contains(h)).filter(h -> h.isSuitableForVm(vm)).filter(h -> this.isNotHostOverloadedAfterAllocation((PowerHost)h, vm)).filter(predicate);
        return this.findHostForVmInternal(vm, stream).orElse(PowerHost.NULL);
    }

    protected Optional<PowerHost> findHostForVmInternal(Vm vm, Stream<PowerHost> hostStream) {
        Comparator<PowerHost> hostPowerConsumptionComparator = Comparator.comparingDouble(h -> this.getPowerAfterAllocationDifference((PowerHost)h, vm));
        return this.additionalHostFilters(vm, hostStream).min(hostPowerConsumptionComparator);
    }

    protected Stream<PowerHost> additionalHostFilters(Vm vm, Stream<PowerHost> hostStream) {
        return hostStream.filter(h -> this.getPowerAfterAllocation((PowerHost)h, vm) > 0.0);
    }

    protected List<Host> extractHostListFromMigrationMap(Map<Vm, Host> migrationMap) {
        return migrationMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    protected Map<Vm, Host> getMigrationMapFromOverloadedHosts(Set<PowerHostUtilizationHistory> overloadedHosts) {
        List<Vm> vmsToMigrate = this.getVmsToMigrateFromOverloadedHosts(overloadedHosts);
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        if (overloadedHosts.isEmpty()) {
            return migrationMap;
        }
        Log.printLine("\tReallocation of VMs from overloaded hosts: ");
        VmList.sortByCpuUtilization(vmsToMigrate, this.getDatacenter().getSimulation().clock());
        for (Vm vm : vmsToMigrate) {
            PowerHost targetHost = this.findHostForVm(vm, overloadedHosts);
            if (targetHost == PowerHost.NULL) continue;
            targetHost.createTemporaryVm(vm);
            Log.printConcatLine("\tVM #", vm.getId(), " will be migrated to host #", targetHost.getId());
            migrationMap.put(vm, targetHost);
        }
        Log.printLine();
        return migrationMap;
    }

    protected Map<Vm, Host> getNewVmPlacementFromUnderloadedHost(List<? extends Vm> vmsToMigrate, Set<? extends Host> excludedHosts) {
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        VmList.sortByCpuUtilization(vmsToMigrate, this.getDatacenter().getSimulation().clock());
        for (Vm vm : vmsToMigrate) {
            PowerHost targetHost = this.findHostForVm(vm, excludedHosts, host -> !this.isHostUnderloaded((PowerHost)host));
            if (PowerHost.NULL == targetHost) {
                Log.printFormattedLine("\tA new Host, which isn't also underloaded or won't be overloaded, couldn't be found to migrate %s.", vm);
                Log.printFormattedLine("\tMigration of VMs from the underloaded %s cancelled.", vm.getHost());
                return new HashMap<Vm, Host>();
            }
            targetHost.createTemporaryVm(vm);
            Log.printConcatLine("\tVM #", vm.getId(), " will be allocated to host #", targetHost.getId());
            migrationMap.put(vm, targetHost);
        }
        return migrationMap;
    }

    protected List<Vm> getVmsToMigrateFromOverloadedHosts(Set<PowerHostUtilizationHistory> overloadedHosts) {
        LinkedList<Vm> vmsToMigrate = new LinkedList<Vm>();
        for (PowerHostUtilizationHistory host : overloadedHosts) {
            vmsToMigrate.addAll(this.getVmsToMigrateFromOverloadedHost(host));
        }
        return vmsToMigrate;
    }

    private List<Vm> getVmsToMigrateFromOverloadedHost(PowerHostUtilizationHistory host) {
        Vm vm;
        LinkedList<Vm> vmsToMigrate = new LinkedList<Vm>();
        while (Vm.NULL != (vm = this.getVmSelectionPolicy().getVmToMigrate(host))) {
            vmsToMigrate.add(vm);
            host.destroyTemporaryVm(vm);
            if (this.isHostOverloaded(host)) continue;
            break;
        }
        return vmsToMigrate;
    }

    protected List<? extends Vm> getVmsToMigrateFromUnderUtilizedHost(PowerHost host) {
        return host.getVmList().stream().filter(vm -> !vm.isInMigration()).collect(Collectors.toCollection(LinkedList::new));
    }

    protected List<PowerHost> getSwitchedOffHosts() {
        return this.getHostList().stream().filter(host -> !host.isActive() || host.isFailed()).collect(Collectors.toList());
    }

    protected Set<PowerHostUtilizationHistory> getOverloadedHosts() {
        return this.getHostList().stream().filter(this::isHostOverloaded).filter(h -> h.getVmsMigratingOut().isEmpty()).collect(Collectors.toSet());
    }

    private PowerHost getUnderloadedHost(Set<? extends Host> excludedHosts) {
        return this.getHostList().stream().filter(h -> !excludedHosts.contains(h)).filter(h -> h.getUtilizationOfCpu() > 0.0).filter(this::isHostUnderloaded).filter(h -> h.getVmsMigratingIn().isEmpty()).filter(this::isNotAllVmsMigratingOut).min(Comparator.comparingDouble(Host::getUtilizationOfCpu)).orElse(PowerHost.NULL);
    }

    @Override
    public boolean isHostUnderloaded(PowerHost host) {
        return this.getHostCpuUtilizationPercentage(host) < this.getUnderUtilizationThreshold();
    }

    @Override
    public boolean isHostOverloaded(PowerHost host) {
        double upperThreshold = this.getOverUtilizationThreshold(host);
        this.addHistoryEntryIfAbsent(host, upperThreshold);
        return this.getHostCpuUtilizationPercentage(host) > upperThreshold;
    }

    private double getHostCpuUtilizationPercentage(PowerHost host) {
        return this.getHostTotalRequestedMips(host) / host.getTotalMipsCapacity();
    }

    private double getHostTotalRequestedMips(PowerHost host) {
        return host.getVmList().stream().mapToDouble(Vm::getCurrentRequestedTotalMips).sum();
    }

    protected boolean isNotAllVmsMigratingOut(PowerHost host) {
        return host.getVmList().stream().anyMatch(vm -> !vm.isInMigration());
    }

    protected void saveAllocation() {
        this.savedAllocation.clear();
        for (Host host : this.getHostList()) {
            for (Vm vm : host.getVmList()) {
                if (host.getVmsMigratingIn().contains(vm)) continue;
                this.savedAllocation.put(vm, host);
            }
        }
    }

    protected void restoreAllocation() {
        for (Host host : this.getHostList()) {
            host.destroyAllVms();
            host.reallocateMigratingInVms();
        }
        for (Vm vm : this.savedAllocation.keySet()) {
            PowerHost host = (PowerHost)this.savedAllocation.get(vm);
            if (host.createTemporaryVm(vm)) continue;
            Log.printFormattedLine("Couldn't restore VM #%d on Host #%d", vm.getId(), host.getId());
            return;
        }
    }

    protected double getPowerAfterAllocation(PowerHost host, Vm vm) {
        try {
            return host.getPowerModel().getPower(this.getMaxUtilizationAfterAllocation(host, vm));
        }
        catch (Exception e) {
            Log.printFormattedLine("[ERROR] Power consumption for Host %d could not be determined: ", host.getId(), e.getMessage());
            return 0.0;
        }
    }

    protected double getMaxUtilizationAfterAllocation(PowerHost host, Vm vm) {
        double requestedTotalMips = vm.getCurrentRequestedTotalMips();
        double hostUtilizationMips = this.getUtilizationOfCpuMips(host);
        double hostPotentialMipsUse = hostUtilizationMips + requestedTotalMips;
        return hostPotentialMipsUse / host.getTotalMipsCapacity();
    }

    protected double getUtilizationOfCpuMips(PowerHost host) {
        double hostUtilizationMips = 0.0;
        for (Vm vm2 : host.getVmList()) {
            if (host.getVmsMigratingIn().contains(vm2)) {
                hostUtilizationMips += host.getTotalAllocatedMipsForVm(vm2) * 0.9 / 0.1;
            }
            hostUtilizationMips += host.getTotalAllocatedMipsForVm(vm2);
        }
        return hostUtilizationMips;
    }

    protected void addHistoryEntryIfAbsent(PowerHost host, double metric) {
        this.timeHistory.putIfAbsent(host, new LinkedList());
        this.utilizationHistory.putIfAbsent(host, new LinkedList());
        this.metricHistory.putIfAbsent(host, new LinkedList());
        Simulation simulation = host.getSimulation();
        if (!this.timeHistory.get(host).contains(simulation.clock())) {
            this.timeHistory.get(host).add(simulation.clock());
            this.utilizationHistory.get(host).add(host.getUtilizationOfCpu());
            this.metricHistory.get(host).add(metric);
        }
    }

    protected Map<Vm, Host> getSavedAllocation() {
        return this.savedAllocation;
    }

    protected final void setVmSelectionPolicy(PowerVmSelectionPolicy vmSelectionPolicy) {
        this.vmSelectionPolicy = vmSelectionPolicy;
    }

    protected PowerVmSelectionPolicy getVmSelectionPolicy() {
        return this.vmSelectionPolicy;
    }

    @Override
    public Map<Host, List<Double>> getUtilizationHistory() {
        return Collections.unmodifiableMap(this.utilizationHistory);
    }

    @Override
    public Map<Host, List<Double>> getMetricHistory() {
        return Collections.unmodifiableMap(this.metricHistory);
    }

    @Override
    public Map<Host, List<Double>> getTimeHistory() {
        return Collections.unmodifiableMap(this.timeHistory);
    }

    @Override
    public double getUnderUtilizationThreshold() {
        return this.underUtilizationThreshold;
    }

    @Override
    public void setUnderUtilizationThreshold(double underUtilizationThreshold) {
        this.underUtilizationThreshold = underUtilizationThreshold;
    }
}

