/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.power;

import java.util.Objects;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigrationAbstract;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigrationDynamicUpperThreshold;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.hosts.power.PowerHostUtilizationHistory;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;

public abstract class PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract
extends PowerVmAllocationPolicyMigrationAbstract
implements PowerVmAllocationPolicyMigrationDynamicUpperThreshold {
    private double safetyParameter;
    private PowerVmAllocationPolicyMigration fallbackVmAllocationPolicy;

    public PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract(PowerVmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, 0.0, PowerVmAllocationPolicyMigration.NULL);
    }

    public PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract(PowerVmSelectionPolicy vmSelectionPolicy, double safetyParameter, PowerVmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        super(vmSelectionPolicy);
        this.setSafetyParameter(safetyParameter);
        this.setFallbackVmAllocationPolicy(fallbackVmAllocationPolicy);
    }

    @Override
    public boolean isHostOverloaded(PowerHost host) {
        if (this.getOverUtilizationThreshold(host) == Double.MAX_VALUE) {
            return this.getFallbackVmAllocationPolicy().isHostOverloaded(host);
        }
        return super.isHostOverloaded(host);
    }

    @Override
    public double getOverUtilizationThreshold(PowerHost host) {
        try {
            return 1.0 - this.getSafetyParameter() * this.computeHostUtilizationMeasure((PowerHostUtilizationHistory)host);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return Double.MAX_VALUE;
        }
    }

    protected final void setSafetyParameter(double safetyParameter) {
        if (safetyParameter < 0.0) {
            throw new IllegalArgumentException("The safety parameter must be a positive value. It is a percentage value in scale from 0 to 1 where, for instance, 1 means 100% and 1.5 means 150%.");
        }
        this.safetyParameter = safetyParameter;
    }

    @Override
    public double getSafetyParameter() {
        return this.safetyParameter;
    }

    @Override
    public final void setFallbackVmAllocationPolicy(PowerVmAllocationPolicyMigration fallbackPolicy) {
        this.fallbackVmAllocationPolicy = Objects.isNull(fallbackPolicy) ? PowerVmAllocationPolicyMigration.NULL : fallbackPolicy;
    }

    @Override
    public PowerVmAllocationPolicyMigration getFallbackVmAllocationPolicy() {
        return this.fallbackVmAllocationPolicy;
    }
}

