/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.power;

import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract;
import org.cloudbus.cloudsim.hosts.power.PowerHostUtilizationHistory;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;

public class PowerVmAllocationPolicyMigrationInterQuartileRange
extends PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract {
    private static final int MIN_NUM_OF_HISTORY_ENTRIES_TO_COMPUTE_IRQ = 12;

    public PowerVmAllocationPolicyMigrationInterQuartileRange(PowerVmSelectionPolicy vmSelectionPolicy) {
        super(vmSelectionPolicy);
    }

    public PowerVmAllocationPolicyMigrationInterQuartileRange(PowerVmSelectionPolicy vmSelectionPolicy, double safetyParameter, PowerVmAllocationPolicyMigration fallbackPolicy) {
        super(vmSelectionPolicy, safetyParameter, fallbackPolicy);
    }

    @Override
    public double computeHostUtilizationMeasure(PowerHostUtilizationHistory host) throws IllegalArgumentException {
        double[] data = host.getUtilizationHistory();
        if (MathUtil.countNonZeroBeginning(data) >= 12) {
            return MathUtil.iqr(data);
        }
        throw new IllegalArgumentException("There is not enough Host history to compute Host utilization IRQ");
    }
}

