/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.power;

import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigration;
import org.cloudbus.cloudsim.allocationpolicies.power.PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.hosts.power.PowerHostUtilizationHistory;
import org.cloudbus.cloudsim.resources.ResourceCapacity;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.Vm;

public class PowerVmAllocationPolicyMigrationLocalRegression
extends PowerVmAllocationPolicyMigrationDynamicUpperThresholdAbstract {
    private double schedulingInterval;

    public PowerVmAllocationPolicyMigrationLocalRegression(PowerVmSelectionPolicy vmSelectionPolicy) {
        super(vmSelectionPolicy);
    }

    public PowerVmAllocationPolicyMigrationLocalRegression(PowerVmSelectionPolicy vmSelectionPolicy, double safetyParameter, PowerVmAllocationPolicyMigration fallbackVmAllocationPolicy) {
        super(vmSelectionPolicy, safetyParameter, fallbackVmAllocationPolicy);
    }

    @Override
    public boolean isHostOverloaded(PowerHost host) {
        double predictedUsageThreshold = this.getOverUtilizationThreshold(host);
        if (predictedUsageThreshold == Double.MAX_VALUE) {
            return this.getFallbackVmAllocationPolicy().isHostOverloaded(host);
        }
        this.addHistoryEntryIfAbsent(host, predictedUsageThreshold);
        return predictedUsageThreshold >= 1.0;
    }

    @Override
    public double getOverUtilizationThreshold(PowerHost host) {
        try {
            double predictedUtilization = this.computeHostUtilizationMeasure((PowerHostUtilizationHistory)host);
            return predictedUtilization * this.getSafetyParameter();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return Double.MAX_VALUE;
        }
    }

    @Override
    public double computeHostUtilizationMeasure(PowerHostUtilizationHistory host) throws IllegalArgumentException {
        double[] utilizationHistory = host.getUtilizationHistory();
        int length = 10;
        if (utilizationHistory.length < 10) {
            throw new IllegalArgumentException("There is not enough Host history to estimate its utilization using Local Regression");
        }
        double[] utilizationHistoryReversed = new double[10];
        for (int i = 0; i < 10; ++i) {
            utilizationHistoryReversed[i] = utilizationHistory[10 - i - 1];
        }
        double[] estimates = this.getParameterEstimates(utilizationHistoryReversed);
        double migrationIntervals = Math.ceil(this.getMaximumVmMigrationTime(host) / this.getSchedulingInterval());
        return estimates[0] + estimates[1] * (10.0 + migrationIntervals);
    }

    protected double[] getParameterEstimates(double[] utilizationHistoryReversed) {
        return MathUtil.getLoessParameterEstimates(utilizationHistoryReversed);
    }

    protected double getMaximumVmMigrationTime(PowerHost host) {
        double maxRam = host.getVmList().stream().map(Vm::getRam).mapToDouble(ResourceCapacity::getCapacity).max().orElse(0.0);
        return maxRam / (double)(host.getBw().getCapacity() / 16L);
    }

    public final PowerVmAllocationPolicyMigrationLocalRegression setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
        return this;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }
}

