/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CustomerEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.listeners.DatacenterBrokerEventInfo;
import org.cloudsimplus.listeners.EventListener;

public abstract class DatacenterBrokerAbstract
extends CloudSimEntity
implements DatacenterBroker {
    private static final Function<Vm, Double> DEFAULT_VM_DESTRUCTION_DELAY_FUNCTION = vm -> -1.0;
    private Map<EventListener<DatacenterBrokerEventInfo>, Boolean> onVmsCreatedListeners = new HashMap<EventListener<DatacenterBrokerEventInfo>, Boolean>();
    private Vm lastSelectedVm;
    private Datacenter lastSelectedDc;
    private final List<Vm> vmWaitingList;
    private final Map<Vm, Datacenter> vmCreationRequestsMap;
    private final List<Vm> vmExecList;
    private final List<Vm> vmCreatedList;
    private final List<Cloudlet> cloudletWaitingList;
    private final Map<Cloudlet, Datacenter> cloudletCreationRequestsMap;
    private Supplier<Datacenter> datacenterSupplier;
    private Supplier<Datacenter> fallbackDatacenterSupplier;
    private Function<Cloudlet, Vm> vmMapper;
    private Comparator<Vm> vmComparator;
    private Comparator<Cloudlet> cloudletComparator;
    private final List<Cloudlet> cloudletsFinishedList;
    private int cloudletsCreated = 0;
    private int vmCreationRequests = 0;
    private int vmCreationAcks = 0;
    private List<Datacenter> datacenterList;
    private final Set<Datacenter> datacenterRequestedList;
    private final Map<Vm, Datacenter> vmsToDatacentersMap;
    private Cloudlet lastSubmittedCloudlet = Cloudlet.NULL;
    private Vm lastSubmittedVm = Vm.NULL;
    private Function<Vm, Double> vmDestructionDelayFunction;

    public DatacenterBrokerAbstract(CloudSim simulation) {
        super(simulation);
        this.lastSelectedVm = Vm.NULL;
        this.lastSelectedDc = Datacenter.NULL;
        this.vmWaitingList = new ArrayList<Vm>();
        this.vmExecList = new ArrayList<Vm>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.cloudletWaitingList = new ArrayList<Cloudlet>();
        this.cloudletsFinishedList = new ArrayList<Cloudlet>();
        this.setDatacenterList(new TreeSet<Datacenter>());
        this.datacenterRequestedList = new TreeSet<Datacenter>();
        this.vmCreationRequestsMap = new HashMap<Vm, Datacenter>();
        this.cloudletCreationRequestsMap = new HashMap<Cloudlet, Datacenter>();
        this.vmsToDatacentersMap = new HashMap<Vm, Datacenter>();
        this.setDefaultPolicies();
        this.vmDestructionDelayFunction = DEFAULT_VM_DESTRUCTION_DELAY_FUNCTION;
    }

    private void setDefaultPolicies() {
        this.datacenterSupplier = () -> Datacenter.NULL;
        this.fallbackDatacenterSupplier = this.datacenterSupplier;
        this.vmMapper = cloudlet -> Vm.NULL;
    }

    @Override
    public void submitVmList(List<? extends Vm> list, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.submitVmList(list);
    }

    @Override
    public void submitVmList(List<? extends Vm> list) {
        this.sortVmsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedVm = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedVm);
        this.vmWaitingList.addAll(list);
        if (this.isStarted() && !list.isEmpty()) {
            this.println(String.format("%.2f: %s: List of %d VMs submitted to the broker during simulation execution.\n\t VMs creation request sent to Datacenter.", this.getSimulation().clock(), this.getName(), list.size()));
            this.requestDatacenterToCreateWaitingVms();
        }
    }

    private void setBrokerForEntities(List<? extends CustomerEntity> customerEntities) {
        customerEntities.forEach(e -> e.setBroker(this));
    }

    private <T extends CustomerEntity> T setIdForEntitiesWithoutOne(List<? extends T> list, T lastSubmittedEntity) {
        return (T)(Simulation.setIdForEntitiesWithoutOne(list, lastSubmittedEntity) ? (CustomerEntity)list.get(list.size() - 1) : lastSubmittedEntity);
    }

    private void sortVmsIfComparatorIsSet(List<? extends Vm> list) {
        if (!Objects.isNull(this.vmComparator)) {
            list.sort(this.vmComparator);
        }
    }

    @Override
    public void submitVm(Vm vm) {
        if (vm == null || vm == Vm.NULL) {
            return;
        }
        ArrayList<Vm> newList = new ArrayList<Vm>(1);
        newList.add(vm);
        this.submitVmList(newList);
    }

    @Override
    public void submitCloudlet(Cloudlet cloudlet) {
        if (cloudlet == null || cloudlet == Cloudlet.NULL) {
            return;
        }
        ArrayList<Cloudlet> newList = new ArrayList<Cloudlet>(1);
        newList.add(cloudlet);
        this.submitCloudletList(newList);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, double submissionDelay) {
        this.submitCloudletList(list, Vm.NULL, submissionDelay);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, Vm vm) {
        this.submitCloudletList(list, vm, -1.0);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list, Vm vm, double submissionDelay) {
        this.setDelayForEntitiesWithNoDelay(list, submissionDelay);
        this.bindCloudletsToVm(list, vm);
        this.submitCloudletList(list);
    }

    @Override
    public void submitCloudletList(List<? extends Cloudlet> list) {
        this.sortCloudletsIfComparatorIsSet(list);
        this.setBrokerForEntities(list);
        this.lastSubmittedCloudlet = this.setIdForEntitiesWithoutOne(list, this.lastSubmittedCloudlet);
        if (list.isEmpty()) {
            return;
        }
        this.setSimulationForCloudletUtilizationModels(list);
        this.cloudletWaitingList.addAll(list);
        if (!this.isStarted()) {
            return;
        }
        this.println(String.format("%.2f: %s: List of %d Cloudlets submitted to the broker during simulation execution.", this.getSimulation().clock(), this.getName(), list.size()));
        if (this.vmWaitingList.isEmpty()) {
            this.println(" Cloudlets creation request sent to Datacenter.");
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnCreationOfWaitingVmsFinishListeners();
        } else {
            this.println(String.format(" Waiting creation of %d VMs to send Cloudlets creation request to Datacenter.", this.vmWaitingList.size()));
        }
    }

    private void bindCloudletsToVm(List<? extends Cloudlet> cloudlets, Vm vm) {
        if (Vm.NULL.equals(vm)) {
            return;
        }
        cloudlets.forEach(c -> c.setVm(vm));
    }

    private void sortCloudletsIfComparatorIsSet(List<? extends Cloudlet> list) {
        if (!Objects.isNull(this.cloudletComparator)) {
            list.sort(this.cloudletComparator);
        }
    }

    private void setSimulationForCloudletUtilizationModels(List<? extends Cloudlet> list) {
        for (Cloudlet cloudlet : list) {
            this.setSimulationForUtilizationModelIfNotSet(cloudlet.getUtilizationModelCpu());
            this.setSimulationForUtilizationModelIfNotSet(cloudlet.getUtilizationModelBw());
            this.setSimulationForUtilizationModelIfNotSet(cloudlet.getUtilizationModelRam());
        }
    }

    private void setSimulationForUtilizationModelIfNotSet(UtilizationModel cloudletUtilizationModel) {
        if (Objects.isNull(cloudletUtilizationModel.getSimulation()) || cloudletUtilizationModel.getSimulation() == Simulation.NULL) {
            cloudletUtilizationModel.setSimulation(this.getSimulation());
        }
    }

    private void setDelayForEntitiesWithNoDelay(List<? extends CustomerEntity> list, double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        list.stream().filter(e -> e.getSubmissionDelay() <= 0.0).forEach(e -> e.setSubmissionDelay(submissionDelay));
    }

    @Override
    public boolean bindCloudletToVm(Cloudlet cloudlet, Vm vm) {
        if (!this.cloudletWaitingList.contains(cloudlet)) {
            return false;
        }
        cloudlet.setVm(vm);
        return true;
    }

    @Override
    public void processEvent(SimEvent ev) {
        switch (ev.getTag()) {
            case 4: {
                this.processDatacenterListRequest(ev);
                break;
            }
            case 32: {
                this.processVmCreateResponseFromDatacenter(ev);
                break;
            }
            case 33: {
                this.processBrokerVmDestroyRequest((Vm)ev.getData());
                break;
            }
            case 42: {
                this.requestVmVerticalScaling(ev);
                break;
            }
            case 20: {
                this.processCloudletReturn(ev);
                break;
            }
            case -1: {
                this.shutdownEntity();
                break;
            }
        }
    }

    private void processBrokerVmDestroyRequest(Vm vm) {
        if (vm.getCloudletScheduler().isEmpty()) {
            this.requestIdleVmDestruction(vm, __ -> 0.0);
        }
    }

    private void requestVmVerticalScaling(SimEvent ev) {
        if (!(ev.getData() instanceof VerticalVmScaling)) {
            return;
        }
        VerticalVmScaling scaling = (VerticalVmScaling)ev.getData();
        this.getSimulation().sendNow(ev.getSource(), scaling.getVm().getHost().getDatacenter().getId(), 42, scaling);
    }

    protected void processDatacenterListRequest(SimEvent ev) {
        this.setDatacenterList((Set)ev.getData());
        this.println(String.format("\n%.2f: %s: List of Datacenters received with %d datacenters(s).", this.getSimulation().clock(), this.getName(), this.datacenterList.size()));
        this.requestDatacenterToCreateWaitingVms();
    }

    protected boolean processVmCreateResponseFromDatacenter(SimEvent ev) {
        Vm vm = (Vm)ev.getData();
        boolean vmCreated = false;
        ++this.vmCreationAcks;
        if (vm.isCreated()) {
            this.processSuccessVmCreationInDatacenter(vm, vm.getHost().getDatacenter());
            vmCreated = true;
        } else {
            this.processFailedVmCreationInDatacenter(vm, this.lastSelectedDc);
        }
        if (this.vmWaitingList.isEmpty()) {
            this.requestDatacentersToCreateWaitingCloudlets();
            this.notifyOnCreationOfWaitingVmsFinishListeners();
        } else if (this.getVmCreationRequests() == this.getVmCreationAcks()) {
            this.requestCreationOfWaitingVmsToFallbackDatacenter();
        }
        return vmCreated;
    }

    private void notifyOnCreationOfWaitingVmsFinishListeners() {
        this.onVmsCreatedListeners.entrySet().forEach(entry -> ((EventListener)entry.getKey()).update(DatacenterBrokerEventInfo.of(this)));
        this.onVmsCreatedListeners.entrySet().removeIf(this::isOneTimeListener);
    }

    private boolean isOneTimeListener(Map.Entry<EventListener<DatacenterBrokerEventInfo>, Boolean> eventListenerBooleanEntry) {
        return eventListenerBooleanEntry.getValue();
    }

    protected void requestCreationOfWaitingVmsToFallbackDatacenter() {
        Datacenter nextDatacenter;
        this.lastSelectedDc = nextDatacenter = this.fallbackDatacenterSupplier.get();
        if (nextDatacenter != Datacenter.NULL) {
            this.clearVmCreationRequestsMapToTryNextDatacenter();
            this.requestDatacenterToCreateWaitingVms(nextDatacenter);
            return;
        }
        if (this.vmExecList.isEmpty()) {
            this.println(String.format("%.2f: %s: %s", this.getSimulation().clock(), this.getName(), "none of the required VMs could be created. Aborting"));
            this.requestShutDown();
            return;
        }
        this.requestDatacentersToCreateWaitingCloudlets();
    }

    private void clearVmCreationRequestsMapToTryNextDatacenter() {
        for (Vm vm : this.vmWaitingList) {
            this.vmCreationRequestsMap.remove(vm);
        }
    }

    protected void processSuccessVmCreationInDatacenter(Vm vm, Datacenter datacenter) {
        this.vmsToDatacentersMap.put(vm, datacenter);
        this.vmWaitingList.remove(vm);
        this.vmExecList.add(vm);
        this.vmCreatedList.add(vm);
        this.println(String.format("%.2f: %s: %s has been created in %s.", this.getSimulation().clock(), this.getName(), vm, vm.getHost()));
    }

    protected void processFailedVmCreationInDatacenter(Vm vm, Datacenter datacenter) {
        vm.notifyOnCreationFailureListeners(datacenter);
        this.println(String.format("%.2f: %s: Creation of %s failed in Datacenter #%s", this.getSimulation().clock(), this.getName(), vm, datacenter.getId()));
    }

    protected void processCloudletReturn(SimEvent ev) {
        Function<Vm, Double> func;
        Cloudlet c = (Cloudlet)ev.getData();
        this.cloudletsFinishedList.add(c);
        this.println(String.format("%.2f: %s: %s %d finished and returned to broker.", this.getSimulation().clock(), this.getName(), c.getClass().getSimpleName(), c.getId()));
        --this.cloudletsCreated;
        if (this.isNotAllRunningCloudletsReturned()) {
            this.requestIdleVmDestruction(c.getVm(), this.vmDestructionDelayFunction);
            return;
        }
        Function<Vm, Double> function = func = this.vmDestructionDelayFunction.apply(c.getVm()) < 0.0 ? vm -> 0.0 : this.vmDestructionDelayFunction;
        if (this.cloudletWaitingList.isEmpty()) {
            this.println(String.format("%.2f: %s: All submitted Cloudlets finished executing.", this.getSimulation().clock(), this.getName()));
            this.requestIdleVmsDestruction(func);
            return;
        }
        this.requestIdleVmsDestruction(func);
        this.requestDatacenterToCreateWaitingVms();
    }

    private boolean isNotAllRunningCloudletsReturned() {
        return this.cloudletsCreated > 0;
    }

    protected void requestIdleVmsDestruction(Function<Vm, Double> vmDestructionDelayFunction) {
        for (int i = this.vmExecList.size() - 1; i >= 0; --i) {
            this.requestIdleVmDestruction(this.vmExecList.get(i), vmDestructionDelayFunction);
        }
    }

    private boolean requestIdleVmDestruction(Vm vm, Function<Vm, Double> vmDestructionDelayFunction) {
        double delay = vmDestructionDelayFunction.apply(vm);
        if (delay <= -1.0) {
            return false;
        }
        if (vm.getIdleInterval() >= delay) {
            if (!this.vmExecList.contains(vm)) {
                return true;
            }
            this.println(String.format("%.2f: %s: Destroying %s", this.getSimulation().clock(), this.getName(), vm));
            this.sendNow(this.getVmDatacenter(vm).getId(), 33, (Object)vm);
            this.vmExecList.remove(vm);
            if (this.cloudletWaitingList.isEmpty() && this.vmExecList.isEmpty()) {
                this.println(String.format("%.2f: %s: Destroying VMs and requesting broker shutdown...", this.getSimulation().clock(), this.getName()));
                this.requestShutDown();
            }
            return true;
        }
        this.send(this.getId(), delay, 33, (Object)vm);
        return false;
    }

    protected void requestDatacenterToCreateWaitingVms() {
        this.lastSelectedDc = Datacenter.NULL.equals(this.lastSelectedDc) ? this.datacenterSupplier.get() : this.lastSelectedDc;
        this.requestDatacenterToCreateWaitingVms(this.lastSelectedDc);
    }

    protected void requestDatacenterToCreateWaitingVms(Datacenter datacenter) {
        int requestedVms = 0;
        for (Vm vm : this.vmWaitingList) {
            if (this.vmsToDatacentersMap.containsKey(vm) || this.vmCreationRequestsMap.containsKey(vm)) continue;
            this.println(String.format("%.2f: %s: Trying to Create %s in %s", this.getSimulation().clock(), this.getName(), vm, datacenter.getName()));
            this.sendNow(datacenter.getId(), 32, (Object)vm);
            this.vmCreationRequestsMap.put(vm, datacenter);
            ++requestedVms;
        }
        this.datacenterRequestedList.add(datacenter);
        this.vmCreationRequests += requestedVms;
    }

    protected void requestDatacentersToCreateWaitingCloudlets() {
        ArrayList<Cloudlet> successfullySubmitted = new ArrayList<Cloudlet>();
        for (Cloudlet cloudlet : this.cloudletWaitingList) {
            if (this.cloudletCreationRequestsMap.containsKey(cloudlet)) continue;
            this.lastSelectedVm = this.vmMapper.apply(cloudlet);
            if (this.lastSelectedVm == Vm.NULL) {
                this.println(String.format("%.2f: %s: : Postponing execution of cloudlet %d: bind VM not available.", this.getSimulation().clock(), this.getName(), cloudlet.getId()));
                continue;
            }
            String delayStr = cloudlet.getSubmissionDelay() > 0.0 ? String.format(" with a requested delay of %.0f seconds", cloudlet.getSubmissionDelay()) : "";
            this.println(String.format("%.2f: %s: Sending %s %d to %s in %s%s.", this.getSimulation().clock(), this.getName(), cloudlet.getClass().getSimpleName(), cloudlet.getId(), this.lastSelectedVm, this.lastSelectedVm.getHost(), delayStr));
            cloudlet.setVm(this.lastSelectedVm);
            this.send(this.getVmDatacenter(this.lastSelectedVm).getId(), cloudlet.getSubmissionDelay(), 21, (Object)cloudlet);
            this.cloudletCreationRequestsMap.put(cloudlet, this.getVmDatacenter(this.lastSelectedVm));
            ++this.cloudletsCreated;
            successfullySubmitted.add(cloudlet);
        }
        this.cloudletWaitingList.removeAll(successfullySubmitted);
    }

    protected void requestShutDown() {
        this.sendNow(this.getId(), -1);
    }

    @Override
    public void shutdownEntity() {
        this.println(String.format("%s is shutting down...", this.getName()));
    }

    @Override
    public void startEntity() {
        this.println(String.format("%s is starting...", this.getName()));
        this.schedule(this.getSimulation().getCloudInfoServiceEntityId(), 0.0, 4);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return this.vmCreatedList;
    }

    @Override
    public <T extends Vm> List<T> getVmExecList() {
        return this.vmExecList;
    }

    @Override
    public <T extends Vm> List<T> getVmWaitingList() {
        return this.vmWaitingList;
    }

    @Override
    public Vm getWaitingVm(int index) {
        if (index >= 0 && index < this.vmWaitingList.size()) {
            return this.vmWaitingList.get(index);
        }
        return Vm.NULL;
    }

    @Override
    public Set<Cloudlet> getCloudletCreatedList() {
        return this.cloudletCreationRequestsMap.keySet();
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletWaitingList() {
        return this.cloudletWaitingList;
    }

    @Override
    public <T extends Cloudlet> List<T> getCloudletFinishedList() {
        return new ArrayList<Cloudlet>(this.cloudletsFinishedList);
    }

    protected Vm getVmFromCreatedList(int vmIndex) {
        return vmIndex >= 0 && vmIndex < this.vmExecList.size() ? this.vmExecList.get(vmIndex) : Vm.NULL;
    }

    protected int getVmCreationRequests() {
        return this.vmCreationRequests;
    }

    protected int getVmCreationAcks() {
        return this.vmCreationAcks;
    }

    protected List<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    protected final void setDatacenterList(Set<Datacenter> datacenterList) {
        this.datacenterList = new ArrayList<Datacenter>(datacenterList);
    }

    protected Datacenter getVmDatacenter(Vm vm) {
        return this.vmsToDatacentersMap.get(vm);
    }

    protected Set<Datacenter> getDatacenterRequestedList() {
        return this.datacenterRequestedList;
    }

    protected Vm getLastSelectedVm() {
        return this.lastSelectedVm;
    }

    @Override
    public final void setDatacenterSupplier(Supplier<Datacenter> datacenterSupplier) {
        Objects.requireNonNull(datacenterSupplier);
        this.datacenterSupplier = datacenterSupplier;
    }

    @Override
    public final void setFallbackDatacenterSupplier(Supplier<Datacenter> fallbackDatacenterSupplier) {
        Objects.requireNonNull(fallbackDatacenterSupplier);
        this.fallbackDatacenterSupplier = fallbackDatacenterSupplier;
    }

    @Override
    public final void setVmMapper(Function<Cloudlet, Vm> vmMapper) {
        Objects.requireNonNull(vmMapper);
        this.vmMapper = vmMapper;
    }

    @Override
    public void setVmComparator(Comparator<Vm> comparator) {
        this.vmComparator = comparator;
    }

    @Override
    public void setCloudletComparator(Comparator<Cloudlet> comparator) {
        this.cloudletComparator = comparator;
    }

    @Override
    public DatacenterBroker addOnVmsCreatedListener(EventListener<DatacenterBrokerEventInfo> listener) {
        return this.addOneTimeOnCreationOfWaitingVmsFinishListener(listener, false);
    }

    @Override
    public DatacenterBroker addOneTimeOnVmsCreatedListener(EventListener<DatacenterBrokerEventInfo> listener) {
        return this.addOneTimeOnCreationOfWaitingVmsFinishListener(listener, true);
    }

    public DatacenterBroker addOneTimeOnCreationOfWaitingVmsFinishListener(EventListener<DatacenterBrokerEventInfo> listener, Boolean oneTimeListener) {
        Objects.requireNonNull(listener);
        this.onVmsCreatedListeners.put(listener, oneTimeListener);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Function<Vm, Double> getVmDestructionDelayFunction() {
        return this.vmDestructionDelayFunction;
    }

    @Override
    public DatacenterBroker setVmDestructionDelayFunction(Function<Vm, Double> function) {
        this.vmDestructionDelayFunction = function == null ? DEFAULT_VM_DESTRUCTION_DELAY_FUNCTION : function;
        return this;
    }

    @Override
    public boolean isThereWaitingCloudlets() {
        return !this.cloudletWaitingList.isEmpty();
    }
}

