/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import java.util.stream.Collectors;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.heuristics.CloudletToVmMappingHeuristic;
import org.cloudsimplus.heuristics.CloudletToVmMappingSolution;
import org.cloudsimplus.heuristics.Heuristic;

public class DatacenterBrokerHeuristic
extends DatacenterBrokerSimple {
    private CloudletToVmMappingHeuristic heuristic;

    public DatacenterBrokerHeuristic(CloudSim simulation) {
        super(simulation);
        this.setVmMapper(this::selectVmForWaitingCloudlet);
        this.heuristic = CloudletToVmMappingHeuristic.NULL;
    }

    @Override
    protected void requestDatacentersToCreateWaitingCloudlets() {
        this.setupAndStartHeuristic();
        super.requestDatacentersToCreateWaitingCloudlets();
    }

    private void setupAndStartHeuristic() {
        this.heuristic.setVmList(this.getVmExecList());
        this.heuristic.setCloudletList(this.getCloudletWaitingList().stream().filter(c -> !c.isBindToVm()).collect(Collectors.toList()));
        Log.printFormattedLine("\n# Broker %d started the heuristic to get a suboptimal solution for mapping Cloudlets to Vm's running %d neighborhood searches by iteration", this.getId(), this.heuristic.getNumberOfNeighborhoodSearchesByIteration());
        Log.printLine("Please wait... It may take a while, depending on heuristic parameters and number of Cloudlets and Vm's.");
        CloudletToVmMappingSolution solution = (CloudletToVmMappingSolution)this.heuristic.solve();
        Log.printFormattedLine("# Broker %d finished the solution find for mapping Cloudlets to Vm's in %.2f seconds with a solution cost of %.2f\n", this.getId(), this.heuristic.getSolveTime(), solution.getCost());
    }

    @Override
    protected Vm selectVmForWaitingCloudlet(Cloudlet cloudlet) {
        Vm fallbackVm = super.selectVmForWaitingCloudlet(cloudlet);
        return ((CloudletToVmMappingSolution)this.heuristic.getBestSolutionSoFar()).getResult().getOrDefault(cloudlet, fallbackVm);
    }

    public Heuristic<CloudletToVmMappingSolution> getHeuristic() {
        return this.heuristic;
    }

    public DatacenterBrokerHeuristic setHeuristic(CloudletToVmMappingHeuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }
}

