/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import org.cloudbus.cloudsim.brokers.DatacenterBrokerAbstract;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.vms.Vm;

public class DatacenterBrokerSimple
extends DatacenterBrokerAbstract {
    public DatacenterBrokerSimple(CloudSim simulation) {
        super(simulation);
        this.setDatacenterSupplier(this::selectDatacenterForWaitingVms);
        this.setFallbackDatacenterSupplier(this::selectFallbackDatacenterForWaitingVms);
        this.setVmMapper(this::selectVmForWaitingCloudlet);
    }

    protected Datacenter selectDatacenterForWaitingVms() {
        return this.getDatacenterList().isEmpty() ? Datacenter.NULL : this.getDatacenterList().get(0);
    }

    protected Datacenter selectFallbackDatacenterForWaitingVms() {
        return this.getDatacenterList().stream().filter(dc -> !this.getDatacenterRequestedList().contains(dc)).findFirst().orElse(Datacenter.NULL);
    }

    protected Vm selectVmForWaitingCloudlet(Cloudlet cloudlet) {
        if (cloudlet.isBindToVm() && this.getVmExecList().contains(cloudlet.getVm())) {
            return cloudlet.getVm();
        }
        return this.getVmFromCreatedList(this.getNextVmIndex());
    }

    private int getNextVmIndex() {
        if (this.getVmExecList().isEmpty()) {
            return -1;
        }
        int vmIndex = this.getVmExecList().indexOf(this.getLastSelectedVm());
        return (vmIndex + 1) % this.getVmExecList().size();
    }
}

