/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletDatacenterExecution;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.UniquelyIdentificable;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventListener;

public abstract class CloudletAbstract
implements Cloudlet {
    private int id;
    private final String newline;
    private final DecimalFormat num;
    private final List<CloudletDatacenterExecution> cloudletDatacenterExecutionList = new ArrayList<CloudletDatacenterExecution>(2);
    private DatacenterBroker broker;
    private long length;
    private long numberOfPes;
    private Cloudlet.Status status;
    private double execStartTime;
    private boolean recordTransactionHistory;
    private int priority;
    private int netServiceLevel;
    private Vm vm;
    private List<String> requiredFiles = new LinkedList<String>();
    private int lastExecutedDatacenterIdx;
    private long fileSize;
    private long outputSize;
    private double finishTime;
    private StringBuffer history;
    private double costPerBw;
    private double accumulatedBwCost;
    private UtilizationModel utilizationModelCpu;
    private UtilizationModel utilizationModelRam;
    private UtilizationModel utilizationModelBw;
    private Set<EventListener<CloudletVmEventInfo>> onFinishListeners;
    private Set<EventListener<CloudletVmEventInfo>> onUpdateProcessingListeners;
    private double submissionDelay;

    public CloudletAbstract(int cloudletId, long length, long pesNumber) {
        this.num = new DecimalFormat("#0.00#");
        this.newline = System.getProperty("line.separator");
        this.id = cloudletId;
        this.netServiceLevel = 0;
        this.execStartTime = 0.0;
        this.status = Cloudlet.Status.INSTANTIATED;
        this.priority = 0;
        this.setNumberOfPes(pesNumber);
        this.recordTransactionHistory = false;
        this.lastExecutedDatacenterIdx = -1;
        this.setBroker(DatacenterBroker.NULL);
        this.setFinishTime(-1.0);
        this.setVm(Vm.NULL);
        this.setLength(length);
        this.setFileSize(1L);
        this.setOutputSize(1L);
        this.setAccumulatedBwCost(0.0);
        this.setCostPerBw(0.0);
        this.setSubmissionDelay(0.0);
        this.setUtilizationModelCpu(UtilizationModel.NULL);
        this.setUtilizationModelRam(UtilizationModel.NULL);
        this.setUtilizationModelBw(UtilizationModel.NULL);
        this.onFinishListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
        this.onUpdateProcessingListeners = new HashSet<EventListener<CloudletVmEventInfo>>();
    }

    public CloudletAbstract(long length, int pesNumber) {
        this(-1, length, pesNumber);
    }

    protected int getLastExecutedDatacenterIdx() {
        return this.lastExecutedDatacenterIdx;
    }

    protected void setLastExecutedDatacenterIdx(int lastExecutedDatacenterIdx) {
        this.lastExecutedDatacenterIdx = lastExecutedDatacenterIdx;
    }

    @Override
    public Cloudlet setUtilizationModel(UtilizationModel utilizationModel) {
        this.setUtilizationModelBw(utilizationModel);
        this.setUtilizationModelRam(utilizationModel);
        this.setUtilizationModelCpu(utilizationModel);
        return this;
    }

    @Override
    public Cloudlet addOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Cloudlet addOnFinishListener(EventListener<CloudletVmEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onFinishListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnFinishListener(EventListener<CloudletVmEventInfo> listener) {
        return this.onFinishListeners.remove(listener);
    }

    @Override
    public void notifyOnUpdateProcessingListeners(double time) {
        CloudletVmEventInfo info = CloudletVmEventInfo.of(time, this);
        this.onUpdateProcessingListeners.forEach(l -> l.update(info));
    }

    @Override
    public final Cloudlet setLength(long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("Cloudlet length has to be greater than zero.");
        }
        this.length = length;
        return this;
    }

    @Override
    public boolean setNetServiceLevel(int netServiceLevel) {
        if (netServiceLevel > 0) {
            this.netServiceLevel = netServiceLevel;
            return true;
        }
        return false;
    }

    @Override
    public int getNetServiceLevel() {
        return this.netServiceLevel;
    }

    @Override
    public double getWaitingTime() {
        if (this.cloudletDatacenterExecutionList.isEmpty()) {
            return 0.0;
        }
        double subTime = this.getLastExecutionInDatacenterInfo().getArrivalTime();
        return this.execStartTime - subTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final Cloudlet setNumberOfPes(long numberOfPes) {
        if (numberOfPes <= 0L) {
            throw new IllegalArgumentException("Cloudlet number of PEs has to be greater than zero.");
        }
        this.numberOfPes = numberOfPes;
        return this;
    }

    @Override
    public long getNumberOfPes() {
        return this.numberOfPes;
    }

    @Override
    public String getHistory() {
        if (Objects.isNull(this.history)) {
            return String.format("No history is recorded for Cloudlet #%d", this.id);
        }
        return this.history.toString();
    }

    @Override
    public long getFinishedLengthSoFar(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getFinishedSoFar();
    }

    @Override
    public long getFinishedLengthSoFar() {
        if (this.cloudletDatacenterExecutionList.isEmpty()) {
            return 0L;
        }
        return Math.min(this.getLastExecutionInDatacenterInfo().getFinishedSoFar(), this.getLength());
    }

    @Override
    public boolean isFinished() {
        if (this.cloudletDatacenterExecutionList.isEmpty()) {
            return false;
        }
        return this.getLastExecutionInDatacenterInfo().getFinishedSoFar() >= this.getLength();
    }

    @Override
    public boolean setFinishedLengthSoFar(long length) {
        if ((double)length < 0.0 || this.cloudletDatacenterExecutionList.isEmpty()) {
            return false;
        }
        this.getLastExecutionInDatacenterInfo().setFinishedSoFar(Math.min(length, this.getLength()));
        this.write("Set the length's finished so far to %d", length);
        this.notifyListenersIfCloudletIsFinished();
        return true;
    }

    private void notifyListenersIfCloudletIsFinished() {
        if (this.isFinished()) {
            CloudletVmEventInfo info = CloudletVmEventInfo.of(this);
            this.onFinishListeners.forEach(l -> l.update(info));
        }
    }

    @Override
    public final Cloudlet setBroker(DatacenterBroker broker) {
        if (Objects.isNull(broker)) {
            broker = DatacenterBroker.NULL;
        }
        this.broker = broker;
        return this;
    }

    @Override
    public DatacenterBroker getBroker() {
        return this.broker;
    }

    @Override
    public Datacenter getLastDatacenter() {
        return this.getLastExecutionInDatacenterInfo().getDatacenter();
    }

    private CloudletDatacenterExecution getLastExecutionInDatacenterInfo() {
        if (this.cloudletDatacenterExecutionList.isEmpty()) {
            return CloudletDatacenterExecution.NULL;
        }
        return this.cloudletDatacenterExecutionList.get(this.cloudletDatacenterExecutionList.size() - 1);
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    public double getExecStartTime() {
        return this.execStartTime;
    }

    @Override
    public void setExecStartTime(double clockTime) {
        this.execStartTime = clockTime;
        this.write("Sets the execution start time to %s", this.num.format(clockTime));
    }

    @Override
    public boolean setWallClockTime(double wallTime, double actualCpuTime) {
        if (wallTime < 0.0 || actualCpuTime < 0.0 || this.cloudletDatacenterExecutionList.isEmpty()) {
            return false;
        }
        CloudletDatacenterExecution datacenter = this.getLastExecutionInDatacenterInfo();
        datacenter.setWallClockTime(wallTime);
        datacenter.setActualCpuTime(actualCpuTime);
        this.write("Sets the wall clock time to %s and the actual CPU time to %s", this.num.format(wallTime), this.num.format(actualCpuTime));
        return true;
    }

    @Override
    public boolean setStatus(Cloudlet.Status newStatus) {
        if (this.status == newStatus) {
            return false;
        }
        if (newStatus == Cloudlet.Status.SUCCESS) {
            this.setFinishTime(this.getSimulation().clock());
        }
        this.write("Sets Cloudlet status from %s to %s", this.status.name(), newStatus.name());
        this.status = newStatus;
        return true;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getTotalLength() {
        return this.length * this.numberOfPes;
    }

    @Override
    public double getCostPerSec() {
        return this.getLastExecutionInDatacenterInfo().getCostPerSec();
    }

    @Override
    public double getCostPerSec(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getCostPerSec();
    }

    @Override
    public double getWallClockTimeInLastExecutedDatacenter() {
        return this.getLastExecutionInDatacenterInfo().getWallClockTime();
    }

    @Override
    public double getActualCpuTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getActualCpuTime();
    }

    @Override
    public double getActualCpuTime() {
        if (this.getFinishTime() == -1.0) {
            return -1.0;
        }
        return this.finishTime - this.execStartTime;
    }

    @Override
    public double getArrivalTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getArrivalTime();
    }

    @Override
    public double getWallClockTime(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter).getWallClockTime();
    }

    private CloudletDatacenterExecution getDatacenterInfo(int datacenterId) {
        return this.cloudletDatacenterExecutionList.stream().filter(info -> info.getDatacenter().getId() == datacenterId).findFirst().orElse(CloudletDatacenterExecution.NULL);
    }

    private CloudletDatacenterExecution getDatacenterInfo(Datacenter datacenter) {
        return this.getDatacenterInfo(datacenter.getId());
    }

    @Override
    public double getFinishTime() {
        return this.finishTime;
    }

    protected final void setFinishTime(double finishTime) {
        this.finishTime = finishTime;
    }

    protected void write(String str) {
        if (Objects.isNull(str)) {
            return;
        }
        if (!this.recordTransactionHistory) {
            return;
        }
        if (Objects.isNull(this.history)) {
            this.history = new StringBuffer(1000);
            this.history.append("Time below denotes the simulation time.");
            this.history.append(this.newline);
            this.history.append("Time (sec)       Description Cloudlet #").append(this.id);
            this.history.append(this.newline);
            this.history.append("------------------------------------------");
            this.history.append(this.newline);
            this.history.append(this.num.format(this.getSimulation().clock()));
            this.history.append("   Creates Cloudlet ID #").append(this.id);
            this.history.append(this.newline);
        }
        this.history.append(this.num.format(this.getSimulation().clock()));
        this.history.append("   ").append(str).append(this.newline);
    }

    protected void write(String format, Object ... args) {
        this.write(String.format(format, args));
    }

    @Override
    public Cloudlet.Status getStatus() {
        return this.status;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public final Cloudlet setVm(Vm vm) {
        this.vm = vm;
        return this;
    }

    @Override
    public double getTotalCost() {
        double totalCost = this.getTotalCpuCostForAllDatacenters();
        totalCost += this.accumulatedBwCost;
        return totalCost += this.costPerBw * (double)this.outputSize;
    }

    private double getTotalCpuCostForAllDatacenters() {
        return this.cloudletDatacenterExecutionList.stream().mapToDouble(dcInfo -> dcInfo.getActualCpuTime() * dcInfo.getCostPerSec()).sum();
    }

    @Override
    public List<String> getRequiredFiles() {
        return this.requiredFiles;
    }

    public final void setRequiredFiles(List<String> requiredFiles) {
        this.requiredFiles = Objects.isNull(requiredFiles) ? new LinkedList<String>() : requiredFiles;
    }

    @Override
    public boolean addRequiredFile(String fileName) {
        if (this.getRequiredFiles().stream().anyMatch(s -> s.equals(fileName))) {
            return false;
        }
        this.requiredFiles.add(fileName);
        return true;
    }

    @Override
    public boolean addRequiredFiles(List<String> fileNames) {
        boolean atLeastOneFileAdded = false;
        for (String fileName : fileNames) {
            atLeastOneFileAdded |= this.addRequiredFile(fileName);
        }
        return atLeastOneFileAdded;
    }

    @Override
    public boolean deleteRequiredFile(String filename) {
        for (int i = 0; i < this.getRequiredFiles().size(); ++i) {
            String temp = this.requiredFiles.get(i);
            if (!temp.equals(filename)) continue;
            this.requiredFiles.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean requiresFiles() {
        boolean result = false;
        if (this.getRequiredFiles().size() > 0) {
            result = true;
        }
        return result;
    }

    @Override
    public UtilizationModel getUtilizationModelCpu() {
        return this.utilizationModelCpu;
    }

    @Override
    public final Cloudlet setUtilizationModelCpu(UtilizationModel utilizationModelCpu) {
        this.utilizationModelCpu = Objects.isNull(utilizationModelCpu) ? UtilizationModel.NULL : utilizationModelCpu;
        return this;
    }

    @Override
    public UtilizationModel getUtilizationModelRam() {
        return this.utilizationModelRam;
    }

    @Override
    public final Cloudlet setUtilizationModelRam(UtilizationModel utilizationModelRam) {
        this.utilizationModelRam = Objects.isNull(utilizationModelRam) ? UtilizationModel.NULL : utilizationModelRam;
        return this;
    }

    @Override
    public UtilizationModel getUtilizationModelBw() {
        return this.utilizationModelBw;
    }

    @Override
    public final Cloudlet setUtilizationModelBw(UtilizationModel utilizationModelBw) {
        this.utilizationModelBw = Objects.isNull(utilizationModelBw) ? UtilizationModel.NULL : utilizationModelBw;
        return this;
    }

    @Override
    public double getUtilizationOfCpu() {
        return this.getUtilizationOfCpu(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfCpu(double time) {
        return this.getUtilizationModelCpu().getUtilization(time);
    }

    @Override
    public double getUtilizationOfBw() {
        return this.getUtilizationOfBw(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfBw(double time) {
        return this.getUtilizationModelBw().getUtilization(time);
    }

    @Override
    public double getUtilizationOfRam() {
        return this.getUtilizationOfRam(this.getSimulation().clock());
    }

    @Override
    public double getUtilizationOfRam(double time) {
        return this.getUtilizationModelRam().getUtilization(time);
    }

    @Override
    public double getCostPerBw() {
        return this.costPerBw;
    }

    protected final void setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
    }

    @Override
    public double getAccumulatedBwCost() {
        return this.accumulatedBwCost;
    }

    protected final void setAccumulatedBwCost(double accumulatedBwCost) {
        this.accumulatedBwCost = accumulatedBwCost;
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        this.submissionDelay = submissionDelay;
    }

    @Override
    public boolean isBindToVm() {
        return this.vm != null && this.vm != Vm.NULL;
    }

    @Override
    public final Cloudlet setFileSize(long fileSize) {
        if (fileSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet fize size has to be greater than zero.");
        }
        this.fileSize = fileSize;
        return this;
    }

    @Override
    public final Cloudlet setOutputSize(long outputSize) {
        if (outputSize <= 0L) {
            throw new IllegalArgumentException("Cloudlet output size has to be greater than zero.");
        }
        this.outputSize = outputSize;
        return this;
    }

    public boolean isRecordTransactionHistory() {
        return this.recordTransactionHistory;
    }

    public void setRecordTransactionHistory(boolean recordTransactionHistory) {
        this.recordTransactionHistory = recordTransactionHistory;
    }

    @Override
    public void assignToDatacenter(Datacenter datacenter) {
        CloudletDatacenterExecution dcInfo = new CloudletDatacenterExecution();
        dcInfo.setDatacenter(datacenter);
        dcInfo.setCostPerSec(datacenter.getCharacteristics().getCostPerSecond());
        this.cloudletDatacenterExecutionList.add(dcInfo);
        if (this.isRecordTransactionHistory()) {
            if (this.isAssignedToDatacenter()) {
                Datacenter oldDc = this.getLastExecutionInDatacenterInfo().getDatacenter();
                this.write("Moves Cloudlet from %s (ID #%d) to %s (ID #%d) with cost = $%.2f/sec", oldDc.getName(), oldDc.getId(), dcInfo.getDatacenter().getName(), dcInfo.getDatacenter().getId(), dcInfo.getCostPerSec());
            } else {
                this.write("Allocates this Cloudlet to %s (ID #%d) with cost = $%.2f/sec", dcInfo.getDatacenter().getName(), dcInfo.getDatacenter().getId(), dcInfo.getCostPerSec());
            }
        }
        this.setLastExecutedDatacenterIdx(this.getLastExecutedDatacenterIdx() + 1);
        this.setCostPerBw(datacenter.getCharacteristics().getCostPerBw());
        this.setAccumulatedBwCost(this.costPerBw * (double)this.fileSize);
    }

    @Override
    public double registerArrivalInDatacenter() {
        if (!this.isAssignedToDatacenter()) {
            return -1.0;
        }
        CloudletDatacenterExecution dcInfo = this.cloudletDatacenterExecutionList.get(this.lastExecutedDatacenterIdx);
        dcInfo.setArrivalTime(this.getSimulation().clock());
        return dcInfo.getArrivalTime();
    }

    @Override
    public boolean isAssignedToDatacenter() {
        return !this.cloudletDatacenterExecutionList.isEmpty();
    }

    @Override
    public double getLastDatacenterArrivalTime() {
        return this.getLastExecutionInDatacenterInfo().getArrivalTime();
    }

    @Override
    public String getUid() {
        return UniquelyIdentificable.getUid(this.broker.getId(), this.id);
    }

    @Override
    public Simulation getSimulation() {
        return this.broker.getSimulation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudletAbstract)) {
            return false;
        }
        CloudletAbstract that = (CloudletAbstract)o;
        if (this.id != that.id) {
            return false;
        }
        return this.broker.equals(that.broker);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.broker.hashCode();
        return result;
    }
}

