/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets;

import java.util.Objects;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;

public class CloudletExecution {
    public static final CloudletExecution NULL = new CloudletExecution(Cloudlet.NULL);
    private final Cloudlet cloudlet;
    private double fileTransferTime;
    private double arrivalTime;
    private double finishedTime;
    private long instructionsFinishedSoFar;
    private double startExecTime;
    private double lastProcessingTime;
    private double totalCompletionTime;
    private double virtualRuntime;
    private double timeSlice;

    public CloudletExecution(Cloudlet cloudlet) {
        this(cloudlet, 0L);
    }

    public CloudletExecution(Cloudlet cloudlet, long startTime) {
        this.cloudlet = cloudlet;
        this.arrivalTime = cloudlet.registerArrivalInDatacenter();
        this.finishedTime = -1.0;
        this.lastProcessingTime = -1.0;
        this.totalCompletionTime = 0.0;
        this.startExecTime = 0.0;
        this.virtualRuntime = 0.0;
        this.instructionsFinishedSoFar = cloudlet.getFinishedLengthSoFar() * 1000000L;
    }

    public long getCloudletLength() {
        return this.cloudlet.getLength();
    }

    public long getNumberOfPes() {
        return this.cloudlet.getNumberOfPes();
    }

    public boolean setCloudletStatus(Cloudlet.Status newStatus) {
        Cloudlet.Status prevStatus = this.cloudlet.getStatus();
        if (prevStatus.equals((Object)newStatus)) {
            return false;
        }
        double clock = this.cloudlet.getSimulation().clock();
        this.cloudlet.setStatus(newStatus);
        if (prevStatus == Cloudlet.Status.INEXEC && CloudletExecution.isNotRunning(newStatus)) {
            this.totalCompletionTime += clock - this.startExecTime;
            return true;
        }
        if (prevStatus == Cloudlet.Status.RESUMED && newStatus == Cloudlet.Status.SUCCESS) {
            this.totalCompletionTime += clock - this.startExecTime;
            return true;
        }
        this.startOrResumeCloudlet(newStatus, prevStatus);
        return true;
    }

    private void startOrResumeCloudlet(Cloudlet.Status newStatus, Cloudlet.Status oldStatus) {
        double clock = this.cloudlet.getSimulation().clock();
        if (newStatus == Cloudlet.Status.INEXEC || oldStatus == Cloudlet.Status.PAUSED && newStatus == Cloudlet.Status.RESUMED) {
            this.startExecTime = clock;
            if (this.cloudlet.getExecStartTime() == 0.0) {
                this.cloudlet.setExecStartTime(this.startExecTime);
            }
        }
    }

    private static boolean isNotRunning(Cloudlet.Status status) {
        return status == Cloudlet.Status.CANCELED || status == Cloudlet.Status.PAUSED || status == Cloudlet.Status.SUCCESS;
    }

    public long getRemainingCloudletLength() {
        double remainingMI = (double)this.cloudlet.getLength() - (double)this.instructionsFinishedSoFar / 1000000.0;
        return remainingMI < 0.0 ? 0L : (long)remainingMI;
    }

    public void finalizeCloudlet() {
        double wallClockTime = this.cloudlet.getSimulation().clock() - this.arrivalTime;
        this.cloudlet.setWallClockTime(wallClockTime, this.totalCompletionTime);
        long finishedLength = this.cloudlet.getStatus() == Cloudlet.Status.SUCCESS ? this.cloudlet.getLength() : this.instructionsFinishedSoFar / 1000000L;
        this.cloudlet.setFinishedLengthSoFar(finishedLength);
    }

    public void updateProcessing(long executedInstructions) {
        this.setLastProcessingTime(this.cloudlet.getSimulation().clock());
        if (executedInstructions <= 0L) {
            return;
        }
        this.instructionsFinishedSoFar += executedInstructions;
        this.instructionsFinishedSoFar = Math.min(this.instructionsFinishedSoFar, this.cloudlet.getLength() * 1000000L);
        double finishedSoFarByPeMI = this.instructionsFinishedSoFar / 1000000L;
        this.cloudlet.setFinishedLengthSoFar((long)finishedSoFarByPeMI);
    }

    public double getCloudletArrivalTime() {
        return this.arrivalTime;
    }

    public double getFinishTime() {
        return this.finishedTime;
    }

    public void setFinishTime(double time) {
        if (time < 0.0) {
            return;
        }
        this.finishedTime = time;
    }

    public Cloudlet getCloudlet() {
        return this.cloudlet;
    }

    public int getCloudletId() {
        return this.cloudlet.getId();
    }

    public double getFileTransferTime() {
        return this.fileTransferTime;
    }

    public void setFileTransferTime(double fileTransferTime) {
        this.fileTransferTime = fileTransferTime;
    }

    public double getLastProcessingTime() {
        return this.lastProcessingTime;
    }

    public void setLastProcessingTime(double lastProcessingTime) {
        this.lastProcessingTime = lastProcessingTime;
        this.cloudlet.notifyOnUpdateProcessingListeners(lastProcessingTime);
    }

    public double getVirtualRuntime() {
        return this.virtualRuntime;
    }

    public double addVirtualRuntime(double timeToAdd) {
        if (timeToAdd >= 0.0) {
            this.setVirtualRuntime(this.virtualRuntime + timeToAdd);
        }
        return this.virtualRuntime;
    }

    public void setVirtualRuntime(double virtualRuntime) {
        this.virtualRuntime = virtualRuntime;
    }

    public double getTimeSlice() {
        return this.timeSlice;
    }

    public void setTimeSlice(double timeSlice) {
        this.timeSlice = timeSlice;
    }

    public String toString() {
        return String.format("Cloudlet %d", this.cloudlet.getId());
    }

    public boolean equals(Object obj) {
        return obj instanceof CloudletExecution && ((CloudletExecution)obj).cloudlet.getId() == this.cloudlet.getId();
    }

    public int hashCode() {
        return Objects.hash(this.cloudlet.getId());
    }
}

