/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.network.CloudletTask;
import org.cloudbus.cloudsim.network.VmPacket;

public class CloudletSendTask
extends CloudletTask {
    private final List<VmPacket> packetsToSend = new ArrayList<VmPacket>();

    public CloudletSendTask(int id) {
        super(id);
    }

    public VmPacket addPacket(Cloudlet destinationCloudlet, long dataLength) {
        if (Objects.isNull(this.getCloudlet())) {
            throw new RuntimeException("You must assign a NetworkCloudlet to this Task before adding packets.");
        }
        if (!this.getCloudlet().isBindToVm()) {
            throw new IllegalArgumentException("The source Cloudlet has to have an assigned VM.");
        }
        if (!destinationCloudlet.isBindToVm()) {
            throw new IllegalArgumentException("The destination Cloudlet has to have an assigned VM.");
        }
        VmPacket packet = new VmPacket(this.getCloudlet().getVm(), destinationCloudlet.getVm(), dataLength, this.getCloudlet(), destinationCloudlet);
        this.packetsToSend.add(packet);
        return packet;
    }

    public List<VmPacket> getPacketsToSend() {
        return Collections.unmodifiableList(this.packetsToSend);
    }

    public List<VmPacket> getPacketsToSend(double sendTime) {
        this.packetsToSend.forEach(pkt -> pkt.setSendTime(sendTime));
        if (this.isFinished()) {
            this.packetsToSend.clear();
        } else {
            this.setFinished(true);
        }
        return this.packetsToSend;
    }
}

