/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import org.cloudbus.cloudsim.cloudlets.network.NetworkCloudlet;
import org.cloudbus.cloudsim.core.Identificable;

public abstract class CloudletTask
implements Identificable {
    private boolean finished = false;
    private int id;
    private double startTime;
    private double finishTime;
    private long memory;
    private NetworkCloudlet cloudlet;

    public CloudletTask(int id) {
        this.id = id;
        this.startTime = -1.0;
        this.finishTime = -1.0;
        this.memory = 0L;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public NetworkCloudlet getCloudlet() {
        return this.cloudlet;
    }

    public void setCloudlet(NetworkCloudlet cloudlet) {
        this.cloudlet = cloudlet;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void setFinished(boolean finished) {
        if (this.finished && !finished) {
            throw new IllegalArgumentException("The task is already finished. You cannot set it as unfinished.");
        }
        if (!this.finished && finished) {
            this.finishTime = this.cloudlet.getSimulation().clock();
        }
        this.finished = finished;
    }

    public double getExecutionTime() {
        return this.finished ? this.finishTime - this.startTime : -1.0;
    }

    public double getFinishTime() {
        return this.finishTime;
    }
}

