/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.cloudlets.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.cloudlets.network.CloudletExecutionTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletTask;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;

public class NetworkCloudlet
extends CloudletSimple {
    private int currentTaskNum = -1;
    private final List<CloudletTask> tasks = new ArrayList<CloudletTask>();
    private long memory = 0L;

    public NetworkCloudlet(int id, long cloudletLength, int pesNumber) {
        super(id, cloudletLength, pesNumber);
    }

    @Deprecated
    public NetworkCloudlet(int id, long cloudletLength, int pesNumber, long cloudletFileSize, long cloudletOutputSize, long memory, UtilizationModel utilizationModelCpu, UtilizationModel utilizationModelRam, UtilizationModel utilizationModelBw) {
        this(id, cloudletLength, pesNumber);
        this.setFileSize(cloudletFileSize).setOutputSize(cloudletOutputSize).setUtilizationModelCpu(utilizationModelCpu).setUtilizationModelRam(utilizationModelRam).setUtilizationModelBw(utilizationModelBw);
        this.memory = memory;
    }

    public double getNumberOfTasks() {
        return this.tasks.size();
    }

    public List<CloudletTask> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public long getMemory() {
        return this.memory;
    }

    public NetworkCloudlet setMemory(long memory) {
        this.memory = memory;
        return this;
    }

    public boolean isTasksStarted() {
        return this.currentTaskNum > -1;
    }

    public boolean startNextTaskIfCurrentIsFinished(double nextTaskStartTime) {
        CloudletTask nextTask = this.getNextTaskIfCurrentIfFinished();
        if (nextTask == null) {
            return false;
        }
        nextTask.setStartTime(nextTaskStartTime);
        return true;
    }

    public CloudletTask getCurrentTask() {
        if (this.currentTaskNum < 0 || this.currentTaskNum >= this.tasks.size()) {
            return null;
        }
        return this.tasks.get(this.currentTaskNum);
    }

    protected CloudletTask getNextTaskIfCurrentIfFinished() {
        if (this.getCurrentTask() != null && !this.getCurrentTask().isFinished()) {
            return null;
        }
        if (this.currentTaskNum <= this.tasks.size() - 1) {
            ++this.currentTaskNum;
        }
        return this.getCurrentTask();
    }

    @Override
    public boolean isFinished() {
        boolean allTasksFinished = this.tasks.stream().allMatch(CloudletTask::isFinished);
        return super.isFinished() && allTasksFinished;
    }

    @Override
    public long getLength() {
        return this.getTasks().stream().filter(t -> t instanceof CloudletExecutionTask).mapToLong(t -> ((CloudletExecutionTask)t).getLength()).sum();
    }

    @Override
    public boolean setFinishedLengthSoFar(long length) {
        return super.setFinishedLengthSoFar(length);
    }

    public NetworkCloudlet addTask(CloudletTask task) {
        task.setCloudlet(this);
        this.tasks.add(task);
        return this;
    }

    protected long numberOfExecutionTasks() {
        return this.getTasks().stream().filter(t -> t instanceof CloudletExecutionTask).count();
    }
}

