/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.Identificable;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.util.Log;

public class CloudInformationService
extends CloudSimEntity {
    private final Set<Datacenter> datacenterList = new TreeSet<Datacenter>();
    private final Set<CloudInformationService> cisList = new TreeSet<CloudInformationService>();

    CloudInformationService(CloudSim simulation) {
        super(simulation);
    }

    @Override
    protected void startEntity() {
    }

    @Override
    public void processEvent(SimEvent ev) {
        switch (ev.getTag()) {
            case 13: {
                this.cisList.add((CloudInformationService)ev.getData());
                break;
            }
            case 14: {
                int id = ev.getSource();
                super.send(id, 0.0, ev.getTag(), this.cisList);
                break;
            }
            case 2: {
                this.datacenterList.add((Datacenter)ev.getData());
                break;
            }
            case 4: {
                int id = ev.getSource();
                super.send(id, 0.0, ev.getTag(), this.datacenterList);
                break;
            }
            default: {
                this.processOtherEvent(ev);
            }
        }
    }

    @Override
    public void shutdownEntity() {
        this.notifyAllEntity();
    }

    public Set<Datacenter> getDatacenterList() {
        return this.datacenterList;
    }

    public boolean datacenterExists(Integer id) {
        if (Objects.isNull(id) || id < 0) {
            return false;
        }
        return this.datacenterExists(this.datacenterList, id);
    }

    private boolean datacenterExists(Collection<Datacenter> list, Integer datacenterId) {
        if (Objects.isNull(list) || Objects.isNull(datacenterId) || datacenterId < 0) {
            return false;
        }
        return list.stream().map(Identificable::getId).anyMatch(datacenterId::equals);
    }

    protected void processOtherEvent(SimEvent ev) {
        if (Objects.isNull(ev)) {
            Log.printConcatLine("CloudInformationService.processOtherEvent(): ", "Unable to handle a request since the event is null.");
            return;
        }
        Log.printLine("CloudInformationSevice.processOtherEvent(): Unable to handle a request from " + this.getSimulation().getEntityName(ev.getSource()) + " with event tag = " + ev.getTag());
    }

    protected void processEndSimulation() {
    }

    private void notifyAllEntity() {
        Log.printConcatLine(super.getName(), ": Notify all CloudSim Plus entities to shutdown.");
        this.signalShutdown(this.datacenterList);
        this.signalShutdown(this.cisList);
        this.datacenterList.clear();
        this.cisList.clear();
    }

    protected void signalShutdown(Collection<? extends SimEntity> list) {
        if (Objects.isNull(list)) {
            return;
        }
        list.forEach(entity -> super.send(entity.getId(), 0.0, -1));
    }
}

