/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.CloudInformationService;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.CloudSimEvent;
import org.cloudbus.cloudsim.core.events.DeferredQueue;
import org.cloudbus.cloudsim.core.events.EventQueue;
import org.cloudbus.cloudsim.core.events.FutureQueue;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.util.Log;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public class CloudSim
implements Simulation {
    public static final String VERSION = "1.2.6";
    private static final int NOT_FOUND = -1;
    private final double[] circularClockTimesQueue;
    private double lastTimeClockTickListenersWereUpdated = 0.0;
    private NetworkTopology networkTopology;
    private CloudInformationService cis;
    private Calendar calendar;
    private double terminationTime = -1.0;
    private double minTimeBetweenEvents = 0.1;
    private List<CloudSimEntity> entities = new ArrayList<CloudSimEntity>();
    private FutureQueue future;
    private DeferredQueue deferred;
    private double clockTime = 0.0;
    private boolean running = false;
    private Map<String, SimEntity> entitiesByName = new LinkedHashMap<String, SimEntity>();
    private Map<SimEntity, Predicate<SimEvent>> waitPredicates;
    private boolean paused;
    private double pauseAt = -1.0;
    private boolean abortRequested;
    private boolean alreadyRunOnce = false;
    private Set<EventListener<SimEvent>> onEventProcessingListeners;
    private Set<EventListener<EventInfo>> onSimulationPausedListeners;
    private Set<EventListener<EventInfo>> onClockTickListeners;

    public CloudSim() {
        this(null);
    }

    public CloudSim(Calendar cal) {
        this.future = new FutureQueue();
        this.deferred = new DeferredQueue();
        this.waitPredicates = new HashMap<SimEntity, Predicate<SimEvent>>();
        this.networkTopology = NetworkTopology.NULL;
        this.onEventProcessingListeners = new HashSet<EventListener<SimEvent>>();
        this.onSimulationPausedListeners = new HashSet<EventListener<EventInfo>>();
        this.onClockTickListeners = new HashSet<EventListener<EventInfo>>();
        this.circularClockTimesQueue = new double[]{0.0, -1.0};
        this.calendar = Objects.isNull(this.calendar) ? Calendar.getInstance() : this.calendar;
        this.cis = new CloudInformationService(this);
    }

    @Deprecated
    public CloudSim(int numUser, Calendar cal, boolean traceFlag, double periodBetweenEvents) {
        this(cal);
        if (periodBetweenEvents <= 0.0) {
            throw new IllegalArgumentException("The minimal time between events should be positive, but is:" + periodBetweenEvents);
        }
        this.minTimeBetweenEvents = periodBetweenEvents;
    }

    @Override
    public double start() {
        Log.printConcatLine("Starting CloudSim Plus ", VERSION);
        return this.run();
    }

    @Override
    public boolean terminate() {
        if (this.running) {
            this.running = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean terminateAt(double time) {
        if (time <= this.clockTime) {
            return false;
        }
        this.terminationTime = time;
        return true;
    }

    @Override
    public double getMinTimeBetweenEvents() {
        return this.minTimeBetweenEvents;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public int getCloudInfoServiceEntityId() {
        return this.cis.getId();
    }

    @Override
    public Set<Datacenter> getDatacenterList() {
        return this.cis.getDatacenterList();
    }

    @Override
    public double clock() {
        return this.clockTime;
    }

    @Override
    public double clockInMinutes() {
        return this.clock() / 60.0;
    }

    @Override
    public double clockInHours() {
        return this.clock() / 3600.0;
    }

    private double setClock(double newTime) {
        double oldTime = this.clockTime;
        this.clockTime = newTime;
        return oldTime;
    }

    private void addCurrentTimeToCircularQueue() {
        this.circularClockTimesQueue[0] = this.circularClockTimesQueue[1];
        this.circularClockTimesQueue[1] = this.clockTime;
    }

    @Override
    public int getNumEntities() {
        return this.entities.size();
    }

    @Override
    public SimEntity getEntity(int id) {
        return this.entities.get(id);
    }

    @Override
    public SimEntity getEntity(String name) {
        return this.entitiesByName.get(name);
    }

    @Override
    public int getEntityId(String name) {
        SimEntity obj = this.entitiesByName.get(name);
        return Objects.isNull(obj) ? -1 : obj.getId();
    }

    @Override
    public String getEntityName(int entityId) {
        return this.getEntity(entityId).getName();
    }

    @Override
    public List<SimEntity> getEntityList() {
        return Collections.unmodifiableList(this.entities);
    }

    @Override
    public void addEntity(CloudSimEntity e) {
        if (this.running) {
            CloudSimEvent evt = new CloudSimEvent(this, SimEvent.Type.CREATE, this.clockTime, 1, 0, 0, e);
            this.future.addEvent(evt);
        }
        if (e.getId() == -1) {
            e.setId(this.entities.size());
            this.entities.add(e);
            this.entitiesByName.put(e.getName(), e);
        }
    }

    @Override
    public boolean updateEntityName(String oldName) {
        SimEntity entity = this.entitiesByName.remove(oldName);
        if (!Objects.isNull(entity)) {
            this.entitiesByName.put(entity.getName(), entity);
            return true;
        }
        return false;
    }

    protected void addEntityDynamically(SimEntity e) {
        if (Objects.isNull(e)) {
            throw new IllegalArgumentException("Adding null entity.");
        }
        this.printMessage("Adding: " + e.getName());
        e.start();
    }

    private void runClockTickAndProcessFutureEventQueue() {
        this.executeRunnableEntities();
        if (this.future.isEmpty()) {
            this.running = false;
            this.printMessage("Simulation: No more future events");
        } else {
            this.future.stream().findFirst().ifPresent(this::processAllFutureEventsHappeningAtSameTimeOfTheFirstOne);
        }
    }

    private void processAllFutureEventsHappeningAtSameTimeOfTheFirstOne(SimEvent firstEvent) {
        this.processEvent(firstEvent);
        this.future.remove(firstEvent);
        List eventsToProcess = this.future.stream().filter(e -> e.eventTime() == firstEvent.eventTime()).collect(Collectors.toList());
        for (SimEvent evt : eventsToProcess) {
            this.processEvent(evt);
            this.future.remove(evt);
        }
    }

    private void executeRunnableEntities() {
        List<SimEntity> runableEntities = this.entities.stream().filter(ent -> ent.getState() == SimEntity.State.RUNNABLE).collect(Collectors.toList());
        runableEntities.forEach(SimEntity::run);
    }

    @Override
    public void sendNow(int src, int dest, int tag, Object data) {
        this.send(src, dest, 0.0, tag, data);
    }

    @Override
    public void send(int src, int dest, double delay, int tag, Object data) {
        this.validateDelay(delay);
        CloudSimEvent evt = new CloudSimEvent(this, SimEvent.Type.SEND, this.clockTime + delay, src, dest, tag, data);
        this.future.addEvent(evt);
    }

    @Override
    public void sendFirst(int src, int dest, double delay, int tag, Object data) {
        this.validateDelay(delay);
        CloudSimEvent evt = new CloudSimEvent(this, SimEvent.Type.SEND, this.clockTime + delay, src, dest, tag, data);
        this.future.addEventFirst(evt);
    }

    private void validateDelay(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Send delay can't be negative.");
        }
    }

    @Override
    public void wait(CloudSimEntity src, Predicate<SimEvent> p) {
        src.setState(SimEntity.State.WAITING);
        if (p != SIM_ANY) {
            this.waitPredicates.put(src, p);
        }
    }

    @Override
    public long waiting(int dest, Predicate<SimEvent> p) {
        return this.filterEventsToDestinationEntity(this.deferred, p, dest).count();
    }

    @Override
    public SimEvent select(int dest, Predicate<SimEvent> p) {
        SimEvent evt = this.findFirstDeferred(dest, p);
        this.deferred.remove(evt);
        return evt;
    }

    @Override
    public SimEvent findFirstDeferred(int dest, Predicate<SimEvent> p) {
        return this.filterEventsToDestinationEntity(this.deferred, p, dest).findFirst().orElse(SimEvent.NULL);
    }

    private Stream<SimEvent> filterEventsToDestinationEntity(EventQueue queue, Predicate<SimEvent> p, int dest) {
        return this.filterEvents(queue, p.and(e -> e.getDestination() == dest));
    }

    @Override
    public SimEvent cancel(int src, Predicate<SimEvent> p) {
        SimEvent evt = this.future.stream().filter(p.and(e -> e.getSource() == src)).findFirst().orElse(SimEvent.NULL);
        this.future.remove(evt);
        return evt;
    }

    @Override
    public boolean cancelAll(int src, Predicate<SimEvent> p) {
        int previousSize = this.future.size();
        List<SimEvent> cancelList = this.filterEventsFromSourceEntity(this.future, p, src).collect(Collectors.toList());
        this.future.removeAll(cancelList);
        return previousSize < this.future.size();
    }

    private Stream<SimEvent> filterEventsFromSourceEntity(EventQueue queue, Predicate<SimEvent> p, int src) {
        return this.filterEvents(queue, p.and(e -> e.getSource() == src));
    }

    private Stream<SimEvent> filterEvents(EventQueue queue, Predicate<SimEvent> p) {
        return queue.stream().filter(p);
    }

    private void processEvent(SimEvent e) {
        if (e.eventTime() < this.clockTime) {
            throw new IllegalArgumentException("Past event detected.");
        }
        this.setClock(e.eventTime());
        this.processEventByType(e);
        this.notifyOnClockTickListenersIfClockChanged();
        this.notifyOnEventProcessingListeners(e);
    }

    private void notifyOnClockTickListenersIfClockChanged() {
        if (this.clockTime != this.circularClockTimesQueue[0] || this.clockTime != this.circularClockTimesQueue[1]) {
            if (this.lastTimeClockTickListenersWereUpdated != this.circularClockTimesQueue[0] && this.lastTimeClockTickListenersWereUpdated != this.circularClockTimesQueue[1]) {
                this.lastTimeClockTickListenersWereUpdated = this.circularClockTimesQueue[0];
                EventInfo info = EventInfo.of(this.clockTime);
                this.onClockTickListeners.forEach(l -> l.update(info));
            }
            this.addCurrentTimeToCircularQueue();
        }
    }

    private void processEventByType(SimEvent e) {
        switch (e.getType()) {
            case NULL: {
                throw new IllegalArgumentException("Event has a null type.");
            }
            case CREATE: {
                this.processCreateEvent(e);
                break;
            }
            case SEND: {
                this.processSendEvent(e);
                break;
            }
            case HOLD_DONE: {
                this.processHoldEvent(e);
            }
        }
    }

    private void processCreateEvent(SimEvent e) {
        SimEntity newEvent = (SimEntity)e.getData();
        this.addEntityDynamically(newEvent);
    }

    private void processHoldEvent(SimEvent e) {
        if (e.getSource() < 0) {
            throw new IllegalArgumentException("Null entity holding.");
        }
        this.entities.get(e.getSource()).setState(SimEntity.State.RUNNABLE);
    }

    private void processSendEvent(SimEvent e) {
        if (e.getDestination() < 0) {
            throw new IllegalArgumentException("Attempt to send to a null entity detected.");
        }
        CloudSimEntity destEnt = this.entities.get(e.getDestination());
        if (destEnt.getState() == SimEntity.State.WAITING) {
            Predicate<SimEvent> p = this.waitPredicates.get(destEnt);
            if (Objects.isNull(p) || e.getTag() == 9999 || p.test(e)) {
                destEnt.setEventBuffer(new CloudSimEvent(e));
                destEnt.setState(SimEntity.State.RUNNABLE);
                this.waitPredicates.remove(destEnt);
            } else {
                this.deferred.addEvent(e);
            }
        } else {
            this.deferred.addEvent(e);
        }
    }

    private void notifyOnEventProcessingListeners(SimEvent e) {
        this.onEventProcessingListeners.forEach(l -> l.update(e));
    }

    private void runStart() {
        this.running = true;
        this.entities.forEach(SimEntity::start);
        this.printMessage("Entities started.");
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean pause() {
        return this.pause(this.clockTime);
    }

    @Override
    public boolean pause(double time) {
        if (time < this.clockTime) {
            return false;
        }
        this.pauseAt = time;
        return true;
    }

    @Override
    public boolean resume() {
        boolean wasPaused = this.paused;
        this.paused = false;
        if (this.pauseAt <= this.clockTime) {
            this.pauseAt = -1.0;
        }
        return wasPaused;
    }

    @Override
    public void pauseEntity(int src, double delay) {
        CloudSimEvent evt = new CloudSimEvent(this, SimEvent.Type.HOLD_DONE, this.clockTime + delay, src);
        this.future.addEvent(evt);
        this.entities.get(src).setState(SimEntity.State.HOLDING);
    }

    @Override
    public void holdEntity(int src, long delay) {
        CloudSimEvent evt = new CloudSimEvent(this, SimEvent.Type.HOLD_DONE, this.clockTime + (double)delay, src);
        this.future.addEvent(evt);
        this.entities.get(src).setState(SimEntity.State.HOLDING);
    }

    private double run() {
        if (this.alreadyRunOnce) {
            throw new UnsupportedOperationException("You can't run a simulation that already ran previously. If you've paused the simulation and want to resume it, you should call resume().");
        }
        if (!this.running) {
            this.runStart();
        }
        this.alreadyRunOnce = true;
        while (this.running) {
            this.runClockTickAndProcessFutureEventQueue();
            if (this.isThereRequestToTerminateSimulationAndItWasAttended()) {
                Log.printFormattedLine("\nSimulation finished at time %.2f, before completing, in reason of an explicit request to terminate() or terminateAt().\n", this.clockTime);
                break;
            }
            this.checkIfThereIsRequestToPauseSimulation();
        }
        double lastSimulationTime = this.clock();
        this.finishSimulation();
        this.printMessage("Simulation completed.");
        return lastSimulationTime;
    }

    private boolean isThereRequestToTerminateSimulationAndItWasAttended() {
        if (this.abortRequested) {
            return true;
        }
        if (this.isTerminationRequested() && this.clockTime >= this.terminationTime) {
            this.terminate();
            this.setClock(this.terminationTime);
            return true;
        }
        return false;
    }

    private void checkIfThereIsRequestToPauseSimulation() {
        if ((this.isThereFutureEvtsAndNextOneHappensAfterTimeToPause() || this.isNotThereNextFutureEvtsAndIsTimeToPause()) && this.doPause()) {
            this.waitsForSimulationToBeResumedIfPaused();
        }
    }

    public boolean doPause() {
        if (this.running && this.isPauseRequested()) {
            this.paused = true;
            this.setClock(this.pauseAt);
            this.notifyOnSimulationPausedListeners();
            return true;
        }
        return false;
    }

    private void notifyOnSimulationPausedListeners() {
        this.onSimulationPausedListeners.forEach(l -> l.update(EventInfo.of(this.clockTime)));
    }

    private boolean isPauseRequested() {
        return this.pauseAt > -1.0;
    }

    private void waitsForSimulationToBeResumedIfPaused() {
        while (this.paused) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.pauseAt = -1.0;
    }

    @Override
    public long getNumberOfFutureEvents(Predicate<SimEvent> predicate) {
        return this.future.stream().filter(predicate).count();
    }

    private boolean isThereFutureEvtsAndNextOneHappensAfterTimeToPause() {
        return !this.future.isEmpty() && this.clockTime <= this.pauseAt && this.isNextFutureEventHappeningAfterTimeToPause();
    }

    private boolean isNotThereNextFutureEvtsAndIsTimeToPause() {
        return this.future.isEmpty() && this.clockTime >= this.pauseAt;
    }

    private boolean isTerminationRequested() {
        return this.terminationTime > 0.0;
    }

    private boolean isNextFutureEventHappeningAfterTimeToPause() {
        return this.future.iterator().next().eventTime() >= this.pauseAt;
    }

    private void finishSimulation() {
        if (!this.abortRequested) {
            this.entities.stream().filter(e -> e.getState() != SimEntity.State.FINISHED).forEach(SimEntity::run);
        }
        this.entities.forEach(SimEntity::shutdownEntity);
        this.running = false;
    }

    @Override
    public void abort() {
        this.abortRequested = true;
    }

    private void printMessage(String message) {
        Log.printLine(message);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public final Simulation addOnSimulationPausedListener(EventListener<EventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onSimulationPausedListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnSimulationPausedListener(EventListener<EventInfo> listener) {
        return this.onSimulationPausedListeners.remove(listener);
    }

    @Override
    public final Simulation addOnEventProcessingListener(EventListener<SimEvent> listener) {
        Objects.requireNonNull(listener);
        this.onEventProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnEventProcessingListener(EventListener<SimEvent> listener) {
        return this.onEventProcessingListeners.remove(listener);
    }

    @Override
    public Simulation addOnClockTickListener(EventListener<EventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onClockTickListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnClockTickListener(EventListener<EventInfo> listener) {
        return this.onClockTickListeners.remove(listener);
    }

    @Override
    public NetworkTopology getNetworkTopology() {
        return this.networkTopology;
    }

    @Override
    public void setNetworkTopology(NetworkTopology networkTopology) {
        this.networkTopology = networkTopology;
    }

    @Override
    public Map<String, SimEntity> getEntitiesByName() {
        return Collections.unmodifiableMap(this.entitiesByName);
    }
}

