/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Objects;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.util.Log;

public abstract class CloudSimEntity
implements SimEntity {
    private boolean started;
    private Simulation simulation;
    private String name;
    private int id;
    private SimEvent buffer;
    private SimEntity.State state;
    private boolean log;

    public CloudSimEntity(Simulation simulation) {
        this.setSimulation(simulation);
        this.id = -1;
        this.state = SimEntity.State.RUNNABLE;
        this.name = String.format("%s%d", this.getClass().getSimpleName(), this.simulation.getNumEntities());
        this.simulation.addEntity(this);
        this.started = false;
        this.log = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void start() {
        this.startEntity();
        this.setStarted(true);
    }

    protected abstract void startEntity();

    public void schedule(int dest, double delay, int tag, Object data) {
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.send(this.id, dest, delay, tag, data);
    }

    @Override
    public void schedule(int dest, double delay, int tag) {
        this.schedule(dest, delay, tag, null);
    }

    public void schedule(String dest, double delay, int tag, Object data) {
        this.schedule(this.simulation.getEntityId(dest), delay, tag, data);
    }

    public void schedule(String dest, double delay, int tag) {
        this.schedule(dest, delay, tag, null);
    }

    public void scheduleNow(int dest, int tag, Object data) {
        this.schedule(dest, 0.0, tag, data);
    }

    public void scheduleNow(int dest, int tag) {
        this.schedule(dest, 0.0, tag, null);
    }

    public void scheduleNow(String dest, int tag, Object data) {
        this.schedule(this.simulation.getEntityId(dest), 0.0, tag, data);
    }

    public void scheduleNow(String dest, int tag) {
        this.schedule(dest, 0.0, tag, null);
    }

    public void scheduleFirst(int dest, double delay, int tag, Object data) {
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.sendFirst(this.id, dest, delay, tag, data);
    }

    public void scheduleFirst(int dest, double delay, int tag) {
        this.scheduleFirst(dest, delay, tag, null);
    }

    public void scheduleFirst(String dest, double delay, int tag, Object data) {
        this.scheduleFirst(this.simulation.getEntityId(dest), delay, tag, data);
    }

    public void scheduleFirst(String dest, double delay, int tag) {
        this.scheduleFirst(dest, delay, tag, null);
    }

    public void scheduleFirstNow(int dest, int tag, Object data) {
        this.scheduleFirst(dest, 0.0, tag, data);
    }

    public void scheduleFirstNow(int dest, int tag) {
        this.scheduleFirst(dest, 0.0, tag, null);
    }

    public void scheduleFirstNow(String dest, int tag, Object data) {
        this.scheduleFirst(this.simulation.getEntityId(dest), 0.0, tag, data);
    }

    public void scheduleFirstNow(String dest, int tag) {
        this.scheduleFirst(dest, 0.0, tag, null);
    }

    public void pause(double delay) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Negative delay supplied.");
        }
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.pauseEntity(this.id, delay);
    }

    public long numEventsWaiting(Predicate<SimEvent> p) {
        return this.simulation.waiting(this.id, p);
    }

    public long numEventsWaiting() {
        return this.simulation.waiting(this.id, Simulation.SIM_ANY);
    }

    public SimEvent selectEvent(Predicate<SimEvent> p) {
        if (!this.simulation.isRunning()) {
            return null;
        }
        return this.simulation.select(this.id, p);
    }

    public SimEvent cancelEvent(Predicate<SimEvent> p) {
        return this.simulation.isRunning() ? this.simulation.cancel(this.id, p) : SimEvent.NULL;
    }

    public SimEvent getNextEvent(Predicate<SimEvent> p) {
        if (!this.simulation.isRunning()) {
            return null;
        }
        if (this.numEventsWaiting(p) > 0L) {
            return this.selectEvent(p);
        }
        return null;
    }

    public SimEvent getNextEvent() {
        return this.getNextEvent(Simulation.SIM_ANY);
    }

    public void waitForEvent(Predicate<SimEvent> p) {
        if (!this.simulation.isRunning()) {
            return;
        }
        this.simulation.wait(this, p);
        this.state = SimEntity.State.WAITING;
    }

    @Override
    public void run() {
        SimEvent ev;
        SimEvent simEvent = ev = this.buffer == null ? this.getNextEvent() : this.buffer;
        while (ev != null) {
            this.processEvent(ev);
            if (this.state != SimEntity.State.RUNNABLE) break;
            ev = this.getNextEvent();
        }
        this.buffer = null;
    }

    protected final Object clone() throws CloneNotSupportedException {
        CloudSimEntity copy = (CloudSimEntity)super.clone();
        copy.setName(this.name);
        copy.setSimulation(this.simulation);
        copy.setEventBuffer(null);
        return copy;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final SimEntity setSimulation(Simulation simulation) {
        if (Objects.isNull(simulation)) {
            simulation = Simulation.NULL;
        }
        this.simulation = simulation;
        return this;
    }

    @Override
    public SimEntity setName(String newName) throws IllegalArgumentException {
        if (Objects.isNull(newName)) {
            throw new IllegalArgumentException("Entity names can't be null.");
        }
        if (newName.contains(" ")) {
            throw new IllegalArgumentException("Entity names can't contain spaces.");
        }
        if (newName.trim().equals("")) {
            throw new IllegalArgumentException("Entity names can't be empty.");
        }
        String oldName = this.name;
        this.name = newName;
        this.simulation.updateEntityName(oldName);
        return this;
    }

    public SimEntity.State getState() {
        return this.state;
    }

    protected SimEvent getEventBuffer() {
        return this.buffer;
    }

    public SimEntity setState(SimEntity.State state) {
        this.state = state;
        return this;
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setEventBuffer(SimEvent e) {
        this.buffer = e;
    }

    protected void send(int destEntityId, double delay, int cloudSimTag, Object data) {
        if (destEntityId < 0) {
            return;
        }
        if (delay < 0.0) {
            delay = 0.0;
        }
        if (Double.isInfinite(delay)) {
            throw new IllegalArgumentException("The specified delay is infinite value");
        }
        if (destEntityId < 0) {
            Log.printConcatLine(this.getName(), ".send(): Error - invalid entity id ", destEntityId);
            return;
        }
        int srcId = this.getId();
        if (destEntityId != srcId) {
            delay += this.getNetworkDelay(srcId, destEntityId);
        }
        this.schedule(destEntityId, delay, cloudSimTag, data);
    }

    protected void send(int destEntityId, double delay, int cloudSimTag) {
        this.send(destEntityId, delay, cloudSimTag, null);
    }

    protected void send(String destEntityName, double delay, int cloudSimTag, Object data) {
        this.send(this.simulation.getEntityId(destEntityName), delay, cloudSimTag, data);
    }

    protected void send(String destEntityName, double delay, int cloudSimTag) {
        this.send(destEntityName, delay, cloudSimTag, null);
    }

    protected void sendNow(int destEntityId, int cloudSimTag, Object data) {
        this.send(destEntityId, 0.0, cloudSimTag, data);
    }

    protected void sendNow(int destEntityId, int cloudSimTag) {
        this.send(destEntityId, 0.0, cloudSimTag, null);
    }

    protected void sendNow(String destEntityName, int cloudSimTag, Object data) {
        this.send(this.simulation.getEntityId(destEntityName), 0.0, cloudSimTag, data);
    }

    protected void sendNow(String destEntityName, int cloudSimTag) {
        this.send(destEntityName, 0.0, cloudSimTag, null);
    }

    private double getNetworkDelay(int src, int dst) {
        return this.getSimulation().getNetworkTopology().getDelay(src, dst);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public int compareTo(SimEntity o) {
        return Integer.compare(this.getId(), o.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudSimEntity that = (CloudSimEntity)o;
        if (this.id != that.id) {
            return false;
        }
        return this.simulation.equals(that.simulation);
    }

    public int hashCode() {
        int result = this.simulation.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    @Override
    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public void println(String msg) {
        if (this.log) {
            Log.printLine(msg);
        }
    }
}

