/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.core.ChangeableId;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.SimulationNull;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.core.predicates.PredicateAny;
import org.cloudbus.cloudsim.core.predicates.PredicateNone;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public interface Simulation {
    public static final PredicateAny SIM_ANY = new PredicateAny();
    public static final PredicateNone SIM_NONE = new PredicateNone();
    public static final Simulation NULL = new SimulationNull();

    public void abort();

    public void addEntity(CloudSimEntity var1);

    public SimEvent cancel(int var1, Predicate<SimEvent> var2);

    public boolean cancelAll(int var1, Predicate<SimEvent> var2);

    public double clock();

    public double clockInMinutes();

    public double clockInHours();

    public SimEvent findFirstDeferred(int var1, Predicate<SimEvent> var2);

    public Calendar getCalendar();

    public int getCloudInfoServiceEntityId();

    public Set<Datacenter> getDatacenterList();

    public SimEntity getEntity(int var1);

    public SimEntity getEntity(String var1);

    public int getEntityId(String var1);

    public List<SimEntity> getEntityList();

    public String getEntityName(int var1);

    public double getMinTimeBetweenEvents();

    public int getNumEntities();

    public boolean removeOnEventProcessingListener(EventListener<SimEvent> var1);

    public Simulation addOnSimulationPausedListener(EventListener<EventInfo> var1);

    public boolean removeOnSimulationPausedListener(EventListener<EventInfo> var1);

    public Simulation addOnEventProcessingListener(EventListener<SimEvent> var1);

    public Simulation addOnClockTickListener(EventListener<EventInfo> var1);

    public boolean removeOnClockTickListener(EventListener<EventInfo> var1);

    public void pauseEntity(int var1, double var2);

    public void holdEntity(int var1, long var2);

    public boolean isPaused();

    public boolean pause();

    public boolean pause(double var1);

    public boolean resume();

    public boolean isRunning();

    public SimEvent select(int var1, Predicate<SimEvent> var2);

    public void send(int var1, int var2, double var3, int var5, Object var6);

    public void sendFirst(int var1, int var2, double var3, int var5, Object var6);

    public void sendNow(int var1, int var2, int var3, Object var4);

    public double start();

    public boolean terminate();

    public boolean terminateAt(double var1);

    public void wait(CloudSimEntity var1, Predicate<SimEvent> var2);

    public boolean updateEntityName(String var1);

    public long waiting(int var1, Predicate<SimEvent> var2);

    public NetworkTopology getNetworkTopology();

    public void setNetworkTopology(NetworkTopology var1);

    public Map<String, SimEntity> getEntitiesByName();

    public static <T extends ChangeableId> boolean setIdForEntitiesWithoutOne(List<? extends T> list) {
        return Simulation.setIdForEntitiesWithoutOne(list, null);
    }

    public static <T extends ChangeableId> boolean setIdForEntitiesWithoutOne(List<? extends T> list, T lastEntity) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            return false;
        }
        int id = Objects.isNull(lastEntity) ? ((ChangeableId)list.get(list.size() - 1)).getId() : lastEntity.getId();
        id = Math.max(id, -1);
        for (ChangeableId e : list) {
            if (e.getId() >= 0) continue;
            e.setId(++id);
        }
        return true;
    }

    public long getNumberOfFutureEvents(Predicate<SimEvent> var1);
}

