/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Objects;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;

public final class CloudSimEvent
implements SimEvent {
    private final Simulation simulation;
    private final SimEvent.Type type;
    private final double time;
    private double endWaitingTime;
    private int src;
    private int dest;
    private final int tag;
    private final Object data;
    private long serial = -1L;

    public CloudSimEvent(CloudSim simulation) {
        this.simulation = simulation;
        this.type = SimEvent.Type.NULL;
        this.time = -1.0;
        this.endWaitingTime = -1.0;
        this.src = -1;
        this.dest = -1;
        this.tag = -1;
        this.data = null;
    }

    public CloudSimEvent(SimEvent eventToClone) {
        this.simulation = eventToClone.getSimulation();
        this.type = eventToClone.getType();
        this.time = eventToClone.getTime();
        this.src = eventToClone.getSource();
        this.dest = eventToClone.getDestination();
        this.tag = eventToClone.getTag();
        this.data = eventToClone.getData();
    }

    public CloudSimEvent(CloudSim simulation, SimEvent.Type type, double time, int src, int dest, int tag, Object data) {
        this.simulation = simulation;
        this.type = type;
        this.time = time;
        this.src = src;
        this.dest = dest;
        this.tag = tag;
        this.data = data;
    }

    public CloudSimEvent(CloudSim simulation, SimEvent.Type type, double time, int src) {
        this.simulation = simulation;
        this.type = type;
        this.time = time;
        this.src = src;
        this.dest = -1;
        this.tag = -1;
        this.data = null;
    }

    @Override
    public void setSerial(long serial) {
        this.serial = serial;
    }

    private void setEndWaitingTime(double endWaitingTime) {
        this.endWaitingTime = endWaitingTime;
    }

    public String toString() {
        return "Event tag = " + this.tag + " source = " + this.simulation.getEntity(this.src).getName() + " target = " + this.simulation.getEntity(this.dest).getName() + " time = " + this.time;
    }

    @Override
    public SimEvent.Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(SimEvent event) {
        if (Objects.isNull(event)) {
            return 1;
        }
        if (this.time < event.getTime()) {
            return -1;
        }
        if (this.time > event.getTime()) {
            return 1;
        }
        if (this.serial < event.getSerial()) {
            return -1;
        }
        if (this == event) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getDestination() {
        return this.dest;
    }

    @Override
    public int getSource() {
        return this.src;
    }

    @Override
    public double eventTime() {
        return this.time;
    }

    @Override
    public double endWaitingTime() {
        return this.endWaitingTime;
    }

    @Override
    public int scheduledBy() {
        return this.src;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public SimEvent setSource(int source) {
        this.src = source;
        return this;
    }

    @Override
    public SimEvent setDestination(int destination) {
        this.dest = destination;
        return this;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }
}

