/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters;

import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.lists.HostList;
import org.cloudbus.cloudsim.lists.PeList;
import org.cloudbus.cloudsim.resources.Pe;

public class DatacenterCharacteristicsSimple
implements DatacenterCharacteristics {
    private int id;
    private String architecture;
    private String os;
    private List<? extends Host> hostList;
    private double timeZone;
    private double costPerSecond;
    private String vmm;
    private double costPerMem;
    private double costPerStorage;
    private double costPerBw;
    private Datacenter datacenter;

    public DatacenterCharacteristicsSimple(List<? extends Host> hostList) {
        this.setId(-1);
        this.setHostList(hostList);
        this.setArchitecture("x86");
        this.setOs("Linux");
        this.setHostList(hostList);
        this.setTimeZone(0.0);
        this.setVmm("Xen");
        this.setCostPerSecond(0.0);
        this.setCostPerMem(0.0);
        this.setCostPerStorage(0.0);
        this.setCostPerBw(0.0);
        this.datacenter = Datacenter.NULL;
    }

    @Deprecated
    public DatacenterCharacteristicsSimple(String architecture, String os, String vmm, List<? extends Host> hostList, double timeZone, double costPerSec, double costPerMem, double costPerStorage, double costPerBw) {
        this(hostList);
        this.setTimeZone(timeZone).setCostPerSecond(costPerSec).setCostPerMem(costPerMem).setCostPerStorage(costPerStorage).setCostPerBw(costPerBw);
    }

    @Override
    public String getResourceName() {
        return this.datacenter.getSimulation().getEntityName(this.getId());
    }

    @Override
    public Host getHostWithFreePe() {
        return HostList.getHostWithFreePe(this.getHostList());
    }

    @Override
    public Host getHostWithFreePe(int peNumber) {
        return HostList.getHostWithFreePe(this.getHostList(), peNumber);
    }

    @Override
    public long getMipsOfOnePe(int hostId, int peId) {
        if (this.getHostList().isEmpty()) {
            return -1L;
        }
        return PeList.getMips(HostList.getById(this.getHostList(), hostId).getPeList(), peId);
    }

    @Override
    public double getMips() {
        return this.getHostList().stream().mapToDouble(Host::getTotalMipsCapacity).sum();
    }

    @Override
    public int getNumberOfPes() {
        return HostList.getNumberOfPes(this.getHostList());
    }

    @Override
    public int getNumberOfFreePes() {
        return HostList.getNumberOfFreePes(this.getHostList());
    }

    @Override
    public int getNumberOfBusyPes() {
        return HostList.getNumberOfBusyPes(this.getHostList());
    }

    @Override
    public boolean setPeStatus(Pe.Status status, int hostId, int peId) {
        return HostList.setPeStatus(this.getHostList(), status, hostId, peId);
    }

    @Override
    public int getNumberOfHosts() {
        return this.getHostList().size();
    }

    @Override
    public long getNumberOfFailedHosts() {
        return this.getHostList().stream().filter(Host::isFailed).count();
    }

    @Override
    public boolean isWorking() {
        boolean result = false;
        if (this.getNumberOfFailedHosts() == 0L) {
            result = true;
        }
        return result;
    }

    @Override
    public double getCostPerMem() {
        return this.costPerMem;
    }

    @Override
    public final DatacenterCharacteristics setCostPerMem(double costPerMem) {
        this.costPerMem = costPerMem;
        return this;
    }

    @Override
    public double getCostPerStorage() {
        return this.costPerStorage;
    }

    @Override
    public final DatacenterCharacteristics setCostPerStorage(double costPerStorage) {
        this.costPerStorage = costPerStorage;
        return this;
    }

    @Override
    public double getCostPerBw() {
        return this.costPerBw;
    }

    @Override
    public final DatacenterCharacteristics setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
        return this;
    }

    @Override
    public String getVmm() {
        return this.vmm;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected final void setId(int id) {
        this.id = id;
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public final DatacenterCharacteristics setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    @Override
    public final DatacenterCharacteristics setOs(String os) {
        this.os = os;
        return this;
    }

    @Override
    public <T extends Host> List<T> getHostList() {
        return this.hostList;
    }

    protected final void setHostList(List<? extends Host> hostList) {
        Objects.requireNonNull(hostList);
        this.hostList = hostList;
    }

    @Override
    public double getTimeZone() {
        return this.timeZone;
    }

    @Override
    public final DatacenterCharacteristics setTimeZone(double timeZone) {
        if (timeZone < -12.0 || timeZone > 13.0) {
            timeZone = 0.0;
        }
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public double getCostPerSecond() {
        return this.costPerSecond;
    }

    @Override
    public final DatacenterCharacteristics setCostPerSecond(double costPerSecond) {
        this.costPerSecond = costPerSecond;
        return this;
    }

    @Override
    public final DatacenterCharacteristics setVmm(String vmm) {
        this.vmm = vmm;
        return this;
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public DatacenterCharacteristics setDatacenter(Datacenter datacenter) {
        this.datacenter = datacenter;
        this.setId(datacenter.getId());
        return this;
    }
}

