/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletExecution;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.network.IcmpPacket;
import org.cloudbus.cloudsim.resources.File;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;

public class DatacenterSimple
extends CloudSimEntity
implements Datacenter {
    private DatacenterCharacteristics characteristics;
    private String regionalCisName;
    private VmAllocationPolicy vmAllocationPolicy;
    private double lastProcessTime;
    private List<FileStorage> storageList;
    private double schedulingInterval;

    @Deprecated
    public DatacenterSimple(Simulation simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy, List<FileStorage> storageList, double schedulingInterval) {
        this(simulation, characteristics, vmAllocationPolicy);
        this.setStorageList(storageList);
        this.setSchedulingInterval(schedulingInterval);
    }

    public DatacenterSimple(Simulation simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy) {
        super(simulation);
        if (characteristics.getNumberOfPes() == 0) {
            throw new IllegalArgumentException(super.getName() + " : Error - this entity has no PEs. Therefore, can't process any Cloudlets.");
        }
        this.setCharacteristics(characteristics);
        this.setSimulationInstanceForHosts(characteristics);
        this.setVmAllocationPolicy(vmAllocationPolicy);
        this.setLastProcessTime(0.0);
        this.setSchedulingInterval(0.0);
        this.setStorageList(new ArrayList<FileStorage>());
        this.assignHostsToCurrentDatacenter();
    }

    private void setSimulationInstanceForHosts(DatacenterCharacteristics characteristics) {
        characteristics.getHostList().forEach(host -> host.setSimulation(this.getSimulation()));
    }

    private void assignHostsToCurrentDatacenter() {
        this.characteristics.getHostList().forEach(host -> host.setDatacenter(this));
    }

    @Override
    public void processEvent(SimEvent ev) {
        int processed = 0;
        processed += this.processCloudletEvents(ev);
        processed += this.processVmEvents(ev);
        processed += this.processDatacenterEvents(ev);
        if ((processed += this.processNetworkEvents(ev)) == 0) {
            this.processOtherEvent(ev);
        }
    }

    private int processNetworkEvents(SimEvent ev) {
        switch (ev.getTag()) {
            case 105: {
                this.processPingRequest(ev);
                return 1;
            }
        }
        return 0;
    }

    private int processDatacenterEvents(SimEvent ev) {
        switch (ev.getTag()) {
            case 7: {
                int srcId = (Integer)ev.getData();
                this.sendNow(srcId, ev.getTag(), (Object)0);
                return 1;
            }
            case 8: {
                int srcId = (Integer)ev.getData();
                this.sendNow(srcId, ev.getTag(), (Object)this.getCharacteristics().getNumberOfPes());
                return 1;
            }
            case 9: {
                int srcId = (Integer)ev.getData();
                this.sendNow(srcId, ev.getTag(), (Object)this.getCharacteristics().getNumberOfFreePes());
                return 1;
            }
        }
        return 0;
    }

    private int processVmEvents(SimEvent ev) {
        switch (ev.getTag()) {
            case 31: {
                this.processVmCreate(ev, false);
                return 1;
            }
            case 32: {
                this.processVmCreate(ev, true);
                return 1;
            }
            case 42: {
                return BooleanUtils.toInteger((boolean)this.requestVmVerticalScaling(ev));
            }
            case 33: {
                this.processVmDestroy(ev, false);
                return 1;
            }
            case 34: {
                this.processVmDestroy(ev, true);
                return 1;
            }
            case 35: {
                this.processVmMigrate(ev, false);
                return 1;
            }
            case 36: {
                this.processVmMigrate(ev, true);
                return 1;
            }
            case 37: {
                this.processDataAdd(ev, false);
                return 1;
            }
            case 38: {
                this.processDataAdd(ev, true);
                return 1;
            }
            case 39: {
                this.processDataDelete(ev, false);
                return 1;
            }
            case 40: {
                this.processDataDelete(ev, true);
                return 1;
            }
            case 41: {
                this.updateCloudletProcessing();
                this.checkCloudletsCompletionForAllHosts();
                return 1;
            }
        }
        return 0;
    }

    private boolean requestVmVerticalScaling(SimEvent ev) {
        if (!(ev.getData() instanceof VerticalVmScaling)) {
            return false;
        }
        return this.vmAllocationPolicy.scaleVmVertically((VerticalVmScaling)ev.getData());
    }

    private int processCloudletEvents(SimEvent ev) {
        switch (ev.getTag()) {
            case 21: {
                this.processCloudletSubmit(ev, false);
                return 1;
            }
            case 22: {
                this.processCloudletSubmit(ev, true);
                return 1;
            }
            case 23: {
                this.processCloudlet(ev, 23);
                return 1;
            }
            case 25: {
                this.processCloudlet(ev, 25);
                return 1;
            }
            case 26: {
                this.processCloudlet(ev, 26);
                return 1;
            }
            case 27: {
                this.processCloudlet(ev, 27);
                return 1;
            }
            case 28: {
                this.processCloudlet(ev, 28);
                return 1;
            }
            case 29: {
                this.processCloudletMove((Object[])ev.getData(), 29);
                return 1;
            }
            case 30: {
                this.processCloudletMove((Object[])ev.getData(), 30);
                return 1;
            }
        }
        return 0;
    }

    protected void processPingRequest(SimEvent ev) {
        IcmpPacket pkt = (IcmpPacket)ev.getData();
        pkt.setTag(106);
        pkt.setDestination(pkt.getSource());
        this.sendNow(pkt.getSource().getId(), 106, (Object)pkt);
    }

    protected void processCloudlet(SimEvent ev, int type) {
        Cloudlet cloudlet;
        try {
            cloudlet = (Cloudlet)ev.getData();
        }
        catch (ClassCastException e) {
            Log.printConcatLine(super.getName(), ": Error in processing Cloudlet");
            Log.printLine(e.getMessage());
            return;
        }
        switch (type) {
            case 23: {
                this.processCloudletCancel(cloudlet);
                break;
            }
            case 25: {
                this.processCloudletPause(cloudlet, false);
                break;
            }
            case 26: {
                this.processCloudletPause(cloudlet, true);
                break;
            }
            case 27: {
                this.processCloudletResume(cloudlet, false);
                break;
            }
            case 28: {
                this.processCloudletResume(cloudlet, true);
                break;
            }
            default: {
                Log.printLine(this + ": Unable to handle a request from " + this.getSimulation().getEntityName(ev.getSource()) + " with event tag = " + ev.getTag());
            }
        }
    }

    protected void processCloudletSubmit(SimEvent ev, boolean ack) {
        Cloudlet cl = (Cloudlet)ev.getData();
        if (this.checksIfSubmittedCloudletIsAlreadyFinishedAndNotifyBroker(cl, ack)) {
            return;
        }
        cl.assignToDatacenter(this);
        this.submitCloudletToVm(cl, ack);
    }

    protected void processCloudletMove(Object[] receivedData, int type) {
        this.updateCloudletProcessing();
        Cloudlet cloudlet = (Cloudlet)receivedData[0];
        int destVmId = (Integer)receivedData[1];
        Vm sourceVm = cloudlet.getVm();
        Host sourceHost = sourceVm.getHost();
        Vm destVm = sourceHost.getVm(destVmId, cloudlet.getBroker().getId());
        int destDatacenterId = destVm.getHost().getDatacenter().getId();
        Cloudlet cl = sourceVm.getCloudletScheduler().cloudletCancel(cloudlet.getId());
        if (Cloudlet.NULL.equals(cl)) {
            return;
        }
        if (cl.getStatus() == Cloudlet.Status.SUCCESS) {
            this.sendNow(cl.getBroker().getId(), 22, (Object)cl);
            this.sendNow(cl.getBroker().getId(), 20, (Object)cl);
        }
        cl.setVm(destVm);
        if (destDatacenterId != this.getId()) {
            this.requestClodletMigrationToOtherDc(type, destDatacenterId, cl);
        } else {
            this.requestCloudletMigrationToOtherVm(destVm, cl);
        }
        if (type == 30) {
            this.sendNow(cl.getBroker().getId(), 22, (Object)cloudlet);
        }
    }

    private void requestCloudletMigrationToOtherVm(Vm destVm, Cloudlet cl) {
        if (destVm == Vm.NULL) {
            return;
        }
        double fileTransferTime = this.predictFileTransferTime(cl.getRequiredFiles());
        destVm.getCloudletScheduler().cloudletSubmit(cl, fileTransferTime);
    }

    private void requestClodletMigrationToOtherDc(int type, int destDatacenterId, Cloudlet cl) {
        int tag = type == 30 ? 22 : 21;
        this.sendNow(destDatacenterId, tag, (Object)cl);
    }

    protected void processCloudletResume(Cloudlet cloudlet, boolean ack) {
        double estimatedFinishTime = cloudlet.getVm().getCloudletScheduler().cloudletResume(cloudlet.getId());
        if (estimatedFinishTime > 0.0 && estimatedFinishTime > this.getSimulation().clock()) {
            this.schedule(this.getId(), this.getCloudletProcessingUpdateInterval(estimatedFinishTime), 41);
        }
        if (ack) {
            this.sendNow(cloudlet.getBroker().getId(), 28, (Object)cloudlet);
        }
    }

    protected void processCloudletPause(Cloudlet cloudlet, boolean ack) {
        cloudlet.getVm().getCloudletScheduler().cloudletPause(cloudlet.getId());
        if (ack) {
            this.sendNow(cloudlet.getBroker().getId(), 26, (Object)cloudlet);
        }
    }

    protected void processCloudletCancel(Cloudlet cloudlet) {
        cloudlet.getVm().getCloudletScheduler().cloudletCancel(cloudlet.getId());
        this.sendNow(cloudlet.getBroker().getId(), 23, (Object)cloudlet);
    }

    private void submitCloudletToVm(Cloudlet cl, boolean ack) {
        double fileTransferTime = this.predictFileTransferTime(cl.getRequiredFiles());
        CloudletScheduler scheduler = cl.getVm().getCloudletScheduler();
        double estimatedFinishTime = scheduler.cloudletSubmit(cl, fileTransferTime);
        if (estimatedFinishTime > 0.0 && !Double.isInfinite(estimatedFinishTime)) {
            this.send(this.getId(), this.getCloudletProcessingUpdateInterval(estimatedFinishTime), 41);
        }
        this.sendCloudletSubmitAckToBroker(ack, cl, true);
    }

    protected boolean processVmCreate(SimEvent ev, boolean ackRequested) {
        Vm vm = (Vm)ev.getData();
        boolean hostAllocatedForVm = this.vmAllocationPolicy.allocateHostForVm(vm);
        if (ackRequested) {
            this.send(vm.getBroker().getId(), this.getSimulation().getMinTimeBetweenEvents(), 32, (Object)vm);
        }
        if (hostAllocatedForVm) {
            if (!vm.isCreated()) {
                vm.setCreated(true);
            }
            List<Double> mipsList = vm.getHost().getVmScheduler().getAllocatedMips(vm);
            vm.updateProcessing(this.getSimulation().clock(), mipsList);
        }
        return hostAllocatedForVm;
    }

    protected void processVmDestroy(SimEvent ev, boolean ack) {
        Vm vm = (Vm)ev.getData();
        int cloudlets = vm.getCloudletScheduler().getCloudletList().size();
        this.vmAllocationPolicy.deallocateHostForVm(vm);
        if (ack) {
            this.sendNow(vm.getBroker().getId(), 34, (Object)vm);
        }
        String msg = cloudlets > 0 ? String.format("It had a total of %d cloudlets (running + waiting).", cloudlets) : "It had no running or waiting cloudlets.";
        Log.printFormatted("%.2f: %s: %s destroyed on %s. %s\n", this.getSimulation().clock(), this.getClass().getSimpleName(), vm, vm.getHost(), msg);
    }

    protected void processVmMigrate(SimEvent ev, boolean ack) {
        if (!(ev.getData() instanceof Map.Entry)) {
            throw new ClassCastException("The data object must be Map.Entry<Vm, Host>");
        }
        Map.Entry entry = (Map.Entry)ev.getData();
        Vm vm = (Vm)entry.getKey();
        Host targetHost = (Host)entry.getValue();
        this.vmAllocationPolicy.deallocateHostForVm(vm);
        targetHost.removeMigratingInVm(vm);
        boolean result = this.vmAllocationPolicy.allocateHostForVm(vm, targetHost);
        if (ack) {
            this.sendNow(ev.getSource(), 32, (Object)vm);
        }
        vm.setInMigration(false);
        if (result) {
            Log.printFormattedLine("%.2f: Migration of VM #%d to Host #%d is completed", this.getSimulation().clock(), vm.getId(), targetHost.getId());
        } else {
            Log.printFormattedLine("[Datacenter] VM %d allocation to the destination host failed!", vm.getId());
        }
    }

    protected double getCloudletProcessingUpdateInterval(double nextFinishingCloudletTime) {
        return this.schedulingInterval == 0.0 ? nextFinishingCloudletTime : Math.min(nextFinishingCloudletTime, this.schedulingInterval);
    }

    private boolean checksIfSubmittedCloudletIsAlreadyFinishedAndNotifyBroker(Cloudlet cl, boolean ack) {
        if (!cl.isFinished()) {
            return false;
        }
        String name = this.getSimulation().getEntityName(cl.getBroker().getId());
        Log.printConcatLine(this.getName(), ": Warning - Cloudlet #", cl.getId(), " owned by ", name, " is already completed/finished.");
        Log.printLine("Therefore, it is not being executed again");
        Log.printLine();
        this.sendCloudletSubmitAckToBroker(ack, cl, false);
        this.sendNow(cl.getBroker().getId(), 20, (Object)cl);
        return true;
    }

    private void sendCloudletSubmitAckToBroker(boolean ack, Cloudlet cl, boolean cloudletCreated) {
        if (!ack) {
            return;
        }
        this.sendNow(cl.getBroker().getId(), 22, (Object)cl);
    }

    protected double predictFileTransferTime(List<String> requiredFiles) {
        double time = 0.0;
        block0: for (String fileName : requiredFiles) {
            for (FileStorage storage : this.getStorageList()) {
                File file = storage.getFile(fileName);
                if (file == null) continue;
                time += (double)file.getSize() / storage.getMaxTransferRate();
                continue block0;
            }
        }
        return time;
    }

    protected void processDataDelete(SimEvent ev, boolean ack) {
        if (Objects.isNull(ev)) {
            return;
        }
        Object[] data = (Object[])ev.getData();
        if (Objects.isNull(data)) {
            return;
        }
        String filename = (String)data[0];
        int reqSource = (Integer)data[1];
        int msg = this.deleteFileFromStorage(filename);
        int tag = msg == 540 ? 620 : 531;
        if (ack) {
            Object[] pack = new Object[]{filename, msg};
            this.sendNow(reqSource, tag, (Object)pack);
        }
    }

    protected void processDataAdd(SimEvent ev, boolean ack) {
        if (Objects.isNull(ev)) {
            return;
        }
        Object[] pack = (Object[])ev.getData();
        if (Objects.isNull(pack)) {
            return;
        }
        File file = (File)pack[0];
        file.setMasterCopy(true);
        int sentFrom = (Integer)pack[1];
        Object[] data = new Object[3];
        data[0] = file.getName();
        int msg = this.addFile(file);
        if (ack) {
            data[1] = -1;
            data[2] = msg;
            this.sendNow(sentFrom, 511, (Object)data);
        }
    }

    protected double updateCloudletProcessing() {
        if (!this.isTimeToUpdateCloudletsProcessing()) {
            return Double.MAX_VALUE;
        }
        double nextSimulationTime = this.updateHostsProcessing();
        if (nextSimulationTime != Double.MAX_VALUE) {
            nextSimulationTime = this.getCloudletProcessingUpdateInterval(nextSimulationTime);
            this.schedule(this.getId(), nextSimulationTime, 41);
        }
        this.setLastProcessTime(this.getSimulation().clock());
        return nextSimulationTime;
    }

    protected boolean isTimeToUpdateCloudletsProcessing() {
        return this.getSimulation().clock() < 0.111 || this.getSimulation().clock() >= this.lastProcessTime + this.getSimulation().getMinTimeBetweenEvents();
    }

    protected double updateHostsProcessing() {
        double nextSimulationTime = Double.MAX_VALUE;
        for (Host host : this.getHostList()) {
            double time = host.updateProcessing(this.getSimulation().clock());
            nextSimulationTime = Math.min(time, nextSimulationTime);
        }
        double minTimeBetweenEvents = this.getSimulation().getMinTimeBetweenEvents() + 0.01;
        if ((nextSimulationTime = Math.max(nextSimulationTime, minTimeBetweenEvents)) == Double.MAX_VALUE) {
            return nextSimulationTime;
        }
        return nextSimulationTime;
    }

    protected void checkCloudletsCompletionForAllHosts() {
        List<Host> hosts = this.vmAllocationPolicy.getHostList();
        hosts.forEach(this::checkCloudletsCompletionForGivenHost);
    }

    protected void checkCloudletsCompletionForGivenHost(Host host) {
        host.getVmList().forEach(this::checkCloudletsCompletionForGivenVm);
    }

    public void checkCloudletsCompletionForGivenVm(Vm vm) {
        List nonReturnedCloudlets = vm.getCloudletScheduler().getCloudletFinishedList().stream().map(CloudletExecution::getCloudlet).filter(c -> !vm.getCloudletScheduler().isCloudletReturned((Cloudlet)c)).collect(Collectors.toList());
        nonReturnedCloudlets.stream().forEach(this::returnFinishedCloudletToBroker);
    }

    private void returnFinishedCloudletToBroker(Cloudlet cloudlet) {
        this.sendNow(cloudlet.getBroker().getId(), 20, (Object)cloudlet);
        cloudlet.getVm().getCloudletScheduler().addCloudletToReturnedList(cloudlet);
    }

    @Override
    public int addFile(File file) {
        if (Objects.isNull(file)) {
            return 522;
        }
        if (this.contains(file.getName())) {
            return 523;
        }
        if (this.getStorageList().isEmpty()) {
            return 521;
        }
        for (FileStorage storage : this.getStorageList()) {
            if (!storage.isResourceAmountAvailable(file.getSize())) continue;
            storage.addFile(file);
            return 520;
        }
        return 521;
    }

    protected boolean contains(File file) {
        if (Objects.isNull(file)) {
            return false;
        }
        return this.contains(file.getName());
    }

    protected boolean contains(String fileName) {
        if (Objects.isNull(fileName) || fileName.isEmpty()) {
            return false;
        }
        return this.storageList.stream().anyMatch(storage -> storage.contains(fileName));
    }

    private int deleteFileFromStorage(String fileName) {
        int msg = 541;
        for (FileStorage storage : this.getStorageList()) {
            storage.deleteFile(fileName);
            msg = 540;
        }
        return msg;
    }

    @Override
    public void shutdownEntity() {
        Log.printConcatLine(this.getName(), " is shutting down...");
    }

    @Override
    protected void startEntity() {
        Log.printConcatLine(this.getName(), " is starting...");
        int cisID = this.getSimulation().getEntityId(this.regionalCisName);
        if (cisID == -1) {
            cisID = this.getSimulation().getCloudInfoServiceEntityId();
        }
        this.sendNow(cisID, 2, (Object)this);
    }

    @Override
    public <T extends Host> List<T> getHostList() {
        return this.characteristics.getHostList();
    }

    @Override
    public DatacenterCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    protected final void setCharacteristics(DatacenterCharacteristics characteristics) {
        characteristics.setDatacenter(this);
        this.characteristics = characteristics;
        Simulation.setIdForEntitiesWithoutOne(characteristics.getHostList());
    }

    protected String getRegionalCisName() {
        return this.regionalCisName;
    }

    protected void setRegionalCisName(String regionalCisName) {
        this.regionalCisName = regionalCisName;
    }

    @Override
    public VmAllocationPolicy getVmAllocationPolicy() {
        return this.vmAllocationPolicy;
    }

    protected final Datacenter setVmAllocationPolicy(VmAllocationPolicy vmAllocationPolicy) {
        Objects.requireNonNull(vmAllocationPolicy);
        vmAllocationPolicy.setDatacenter(this);
        this.vmAllocationPolicy = vmAllocationPolicy;
        return this;
    }

    protected double getLastProcessTime() {
        return this.lastProcessTime;
    }

    protected final void setLastProcessTime(double lastProcessTime) {
        this.lastProcessTime = lastProcessTime;
    }

    @Override
    public List<FileStorage> getStorageList() {
        return Collections.unmodifiableList(this.storageList);
    }

    @Override
    public final Datacenter setStorageList(List<FileStorage> storageList) {
        if (Objects.isNull(storageList)) {
            storageList = new ArrayList<FileStorage>();
        }
        this.storageList = storageList;
        this.setAllFilesOfAllStoragesToThisDatacenter();
        return this;
    }

    private void setAllFilesOfAllStoragesToThisDatacenter() {
        this.storageList.stream().map(FileStorage::getFileList).flatMap(Collection::stream).forEach(file -> file.setDatacenter(this));
    }

    @Override
    public <T extends Vm> List<T> getVmList() {
        return Collections.unmodifiableList(this.getHostList().stream().flatMap(h -> h.getVmList().stream()).collect(Collectors.toList()));
    }

    @Override
    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    @Override
    public final Datacenter setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = Math.max(schedulingInterval, 0.0);
        return this;
    }

    @Override
    public Host getHost(int index) {
        if (index >= 0 && index < this.getHostList().size()) {
            return (Host)this.getHostList().get(index);
        }
        return Host.NULL;
    }

    protected void processOtherEvent(SimEvent ev) {
    }

    public String toString() {
        return String.format("Datacenter %d", this.getId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatacenterSimple that = (DatacenterSimple)o;
        return !this.characteristics.equals(that.characteristics);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.characteristics.hashCode();
        return result;
    }
}

