/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.datacenters.DatacenterSimple;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class NetworkDatacenter
extends DatacenterSimple {
    private final List<Switch> switchMap = new ArrayList<Switch>();

    public NetworkDatacenter(Simulation simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy) {
        super(simulation, characteristics, vmAllocationPolicy);
    }

    @Deprecated
    public NetworkDatacenter(CloudSim simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy, List<FileStorage> storageList, double schedulingInterval) {
        this(simulation, characteristics, vmAllocationPolicy);
        this.setStorageList(storageList);
        this.setSchedulingInterval(schedulingInterval);
    }

    public List<Switch> getEdgeSwitch() {
        return this.switchMap.stream().filter(sw -> sw.getLevel() == 2).collect(Collectors.toList());
    }

    @Override
    protected boolean processVmCreate(SimEvent ev, boolean ackRequested) {
        if (!super.processVmCreate(ev, ackRequested)) {
            return false;
        }
        Vm vm = (Vm)ev.getData();
        Log.printLine(vm.getId() + " VM is created on " + vm.getHost().getId());
        return true;
    }

    public void addSwitch(Switch sw) {
        this.switchMap.add(sw);
    }

    @Override
    protected void processCloudletSubmit(SimEvent ev, boolean ack) {
        this.updateCloudletProcessing();
        Cloudlet cl = (Cloudlet)ev.getData();
        if (cl.isFinished()) {
            String name = this.getSimulation().getEntityName(cl.getBroker().getId());
            Log.printConcatLine(this.getName(), ": Warning - Cloudlet #", cl.getId(), " owned by ", name, " is already completed/finished.");
            Log.printLine("Therefore, it is not being executed again\n");
            if (ack) {
                int tag = 22;
                this.sendNow(cl.getBroker().getId(), 22, (Object)cl);
            }
            this.sendNow(cl.getBroker().getId(), 20, (Object)cl);
            return;
        }
        cl.assignToDatacenter(this);
        double fileTransferTime = this.predictFileTransferTime(cl.getRequiredFiles());
        CloudletScheduler scheduler = cl.getVm().getCloudletScheduler();
        double estimatedFinishTime = scheduler.cloudletSubmit(cl, fileTransferTime);
        if (estimatedFinishTime > 0.0) {
            this.send(this.getId(), this.getCloudletProcessingUpdateInterval(estimatedFinishTime += fileTransferTime), 41);
            this.send(this.getId(), 1.0E-4, 41);
        }
        if (ack) {
            this.sendNow(cl.getBroker().getId(), 22, (Object)cl);
        }
        this.checkCloudletsCompletionForAllHosts();
    }

    public List<Switch> getSwitchMap() {
        return Collections.unmodifiableList(this.switchMap);
    }
}

