/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters.power;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.core.predicates.PredicateType;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.datacenters.DatacenterSimple;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.power.PowerHostSimple;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class PowerDatacenter
extends DatacenterSimple {
    private double bandwidthForMigrationPercent;
    private double power;
    private boolean migrationsEnabled;
    private double lastCloudletProcessingTime;
    private int migrationCount;

    public PowerDatacenter(CloudSim simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy) {
        super(simulation, characteristics, vmAllocationPolicy);
        this.setPower(0.0);
        this.setMigrationsEnabled(true);
        this.setLastCloudletProcessingTime(-1.0);
        this.setMigrationCount(0);
        this.bandwidthForMigrationPercent = 0.5;
    }

    @Deprecated
    public PowerDatacenter(CloudSim simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy, List<FileStorage> storageList, double schedulingInterval) {
        this(simulation, characteristics, vmAllocationPolicy);
        this.setStorageList(storageList);
        this.setSchedulingInterval(schedulingInterval);
    }

    @Override
    protected double updateCloudletProcessing() {
        double nextSimulationTime = super.updateCloudletProcessing();
        if (nextSimulationTime == Double.MAX_VALUE) {
            return nextSimulationTime;
        }
        this.executeVmMigrations();
        return nextSimulationTime;
    }

    private void executeVmMigrations() {
        if (!this.isMigrationsEnabled()) {
            return;
        }
        Map<Vm, Host> migrationMap = this.getVmAllocationPolicy().optimizeAllocation(this.getVmList());
        for (Map.Entry<Vm, Host> entry : migrationMap.entrySet()) {
            this.startVmMigration(entry);
        }
    }

    private void startVmMigration(Map.Entry<Vm, Host> entry) {
        double currentTime = this.getSimulation().clock();
        Host sourceHost = entry.getKey().getHost();
        Host targetHost = entry.getValue();
        double delay = this.timeToMigrateVm(entry.getKey(), targetHost);
        if (sourceHost == Host.NULL) {
            Log.printFormattedLine("%.2f: Migration of %s to %s is started.", currentTime, entry.getKey(), targetHost);
        } else {
            Log.printFormattedLine("%.2f: Migration of %s from %s to %s is started.", currentTime, entry.getKey(), sourceHost, targetHost);
        }
        Log.printFormattedLine("\tIt's expected to finish in %.2f seconds, considering the %.0f%% of bandwidth allowed for migration and the VM RAM size.", delay, this.getBandwidthForMigrationPercent() * 100.0);
        sourceHost.addVmMigratingOut(entry.getKey());
        targetHost.addMigratingInVm(entry.getKey());
        this.incrementMigrationCount();
        this.send(this.getId(), delay, 35, entry);
    }

    protected double timeToMigrateVm(Vm vm, Host targetHost) {
        return (double)vm.getRam().getCapacity() / Conversion.bitesToBytes((double)targetHost.getBw().getCapacity() * this.bandwidthForMigrationPercent);
    }

    @Override
    protected double updateHostsProcessing() {
        double currentTime = this.getSimulation().clock();
        this.println("\n--------------------------------------------------------------\n");
        this.println(String.format("New resource usage of %s for the time frame starting at %.2f:", this.getName(), currentTime));
        double nextCloudletFinishTime = super.updateHostsProcessing();
        double datacenterPowerUsageForTimeSpan = this.getDatacenterPowerUsageForTimeSpan();
        this.setPower(this.getPower() + datacenterPowerUsageForTimeSpan);
        this.getHostList().forEach(host -> this.println(String.format("%.2f: [%s] utilization is %6.2f%%", currentTime, host, host.getUtilizationOfCpu() * 100.0)));
        this.println();
        return nextCloudletFinishTime;
    }

    private double getDatacenterPowerUsageForTimeSpan() {
        double currentTime = this.getSimulation().clock();
        double timeSpan = currentTime - this.getLastProcessTime();
        if (timeSpan == 0.0) {
            return 0.0;
        }
        double datacenterTimeSpanPowerUse = 0.0;
        StringBuilder sb = new StringBuilder(this.getHostList().size() * 100);
        for (PowerHostSimple host : this.getHostList()) {
            double previousUseOfCpu = host.getPreviousUtilizationOfCpu();
            double utilizationOfCpu = host.getUtilizationOfCpu();
            double timeFrameHostEnergy = host.getEnergyLinearInterpolation(previousUseOfCpu, utilizationOfCpu, timeSpan);
            datacenterTimeSpanPowerUse += timeFrameHostEnergy;
            sb.append(String.format("%.2f: [%s] utilization at %.2f was %.2f%%, now is %.2f%%", currentTime, host, this.getLastProcessTime(), previousUseOfCpu * 100.0, utilizationOfCpu * 100.0));
            if (host.getPowerModel() == PowerModel.NULL) continue;
            sb.append(String.format("%.2f: [%s] energy is %.2f Watts/sec", currentTime, host, timeFrameHostEnergy));
        }
        if (datacenterTimeSpanPowerUse > 0.0) {
            this.println(String.format("\nDatacenter %d energy consumption for the last time frame from %.2f to %.2f:", this.getId(), this.getLastProcessTime(), currentTime));
            this.println(sb.toString());
            this.println(String.format("\n%.2f: Datacenter %d energy is %.2f Watts/sec\n", currentTime, this.getId(), datacenterTimeSpanPowerUse));
        }
        return datacenterTimeSpanPowerUse;
    }

    protected void removeFinishedVmsFromEveryHost() {
        for (PowerHostSimple host : this.getHostList()) {
            for (Vm vm : host.getFinishedVms()) {
                this.getVmAllocationPolicy().deallocateHostForVm(vm);
                Log.printFormattedLine(String.format("%.2f: %s has been deallocated from %s", this.getSimulation().clock(), vm, host), new Object[0]);
            }
        }
    }

    @Override
    protected void processVmMigrate(SimEvent ev, boolean ack) {
        if (this.getSimulation().clock() <= this.getLastProcessTime()) {
            return;
        }
        super.updateHostsProcessing();
        super.processVmMigrate(ev, ack);
        SimEvent event = this.getSimulation().findFirstDeferred(this.getId(), new PredicateType(35));
        if (Objects.isNull(event) || event.eventTime() > this.getSimulation().clock()) {
            super.updateHostsProcessing();
        }
    }

    @Override
    protected void processCloudletSubmit(SimEvent ev, boolean ack) {
        super.processCloudletSubmit(ev, ack);
        this.setLastCloudletProcessingTime(this.getSimulation().clock());
    }

    public double getPower() {
        return this.power;
    }

    public double getPowerInKWattsHour() {
        return this.getPower() / 3600000.0;
    }

    protected final void setPower(double power) {
        this.power = power;
    }

    protected boolean isInMigration() {
        return this.getVmList().stream().anyMatch(Vm::isInMigration);
    }

    public boolean isMigrationsEnabled() {
        return this.migrationsEnabled;
    }

    public final PowerDatacenter setMigrationsEnabled(boolean enable) {
        this.migrationsEnabled = enable;
        return this;
    }

    protected double getLastCloudletProcessingTime() {
        return this.lastCloudletProcessingTime;
    }

    protected final void setLastCloudletProcessingTime(double lastCloudletProcessingTime) {
        this.lastCloudletProcessingTime = lastCloudletProcessingTime;
    }

    public int getMigrationCount() {
        return this.migrationCount;
    }

    public double getBandwidthForMigrationPercent() {
        return this.bandwidthForMigrationPercent;
    }

    public void setBandwidthForMigrationPercent(double bandwidthForMigrationPercent) {
        if (bandwidthForMigrationPercent <= 0.0) {
            throw new IllegalArgumentException("The bandwidth migration percentage must be greater than 0.");
        }
        this.bandwidthForMigrationPercent = bandwidthForMigrationPercent;
    }

    protected final void setMigrationCount(int migrationCount) {
        this.migrationCount = migrationCount;
    }

    protected void incrementMigrationCount() {
        this.setMigrationCount(this.getMigrationCount() + 1);
    }
}

