/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters.power;

import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.predicates.PredicateType;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.datacenters.power.PowerDatacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.power.PowerHostSimple;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class PowerDatacenterNonPowerAware
extends PowerDatacenter {
    public PowerDatacenterNonPowerAware(CloudSim simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy) {
        super(simulation, characteristics, vmAllocationPolicy);
    }

    @Deprecated
    public PowerDatacenterNonPowerAware(CloudSim simulation, DatacenterCharacteristics characteristics, VmAllocationPolicy vmAllocationPolicy, List<FileStorage> storageList, double schedulingInterval) {
        this(simulation, characteristics, vmAllocationPolicy);
        this.setStorageList(storageList);
        this.setSchedulingInterval(schedulingInterval);
    }

    @Override
    protected double updateCloudletProcessing() {
        if (this.getLastCloudletProcessingTime() == -1.0 || this.getLastCloudletProcessingTime() == this.getSimulation().clock()) {
            this.getSimulation().cancelAll(this.getId(), new PredicateType(41));
            this.schedule(this.getId(), this.getSchedulingInterval(), 41);
            return Double.MAX_VALUE;
        }
        double currentTime = this.getSimulation().clock();
        if (currentTime > this.getLastProcessTime()) {
            Log.printLine("\n");
            double dcPowerUsageForTimeSpan = this.getDatacenterPowerUsageForTimeSpan();
            Log.printFormattedLine("\n%.2f: Consumed energy is %.2f W*sec\n", this.getSimulation().clock(), dcPowerUsageForTimeSpan);
            Log.printLine("\n\n--------------------------------------------------------------\n\n");
            double nextCloudletFinishTime = this.getNextCloudletFinishTime(currentTime);
            this.setPower(this.getPower() + dcPowerUsageForTimeSpan);
            this.checkCloudletsCompletionForAllHosts();
            this.removeFinishedVmsFromEveryHost();
            Log.printLine();
            this.migrateVmsOutIfMigrationIsEnabled();
            this.scheduleUpdateOfCloudletsProcessingForFutureTime(nextCloudletFinishTime);
            this.setLastProcessTime(currentTime);
            return nextCloudletFinishTime;
        }
        return Double.MAX_VALUE;
    }

    private void scheduleUpdateOfCloudletsProcessingForFutureTime(double nextCloudletFinishTime) {
        if (nextCloudletFinishTime != Double.MAX_VALUE) {
            this.getSimulation().cancelAll(this.getId(), new PredicateType(41));
            this.send(this.getId(), this.getSchedulingInterval(), 41);
        }
    }

    private void migrateVmsOutIfMigrationIsEnabled() {
        if (this.isMigrationsEnabled()) {
            Map<Vm, Host> migrationMap = this.getVmAllocationPolicy().optimizeAllocation(this.getVmList());
            for (Map.Entry<Vm, Host> entry : migrationMap.entrySet()) {
                Host targetHost = entry.getValue();
                Host oldHost = entry.getKey().getHost();
                if (oldHost.equals(Host.NULL)) {
                    Log.printFormattedLine("%.2f: Migration of VM #%d to Host #%d is started", this.getSimulation().clock(), entry.getKey().getId(), targetHost.getId());
                } else {
                    Log.printFormattedLine("%.2f: Migration of VM #%d from Host #%d to Host #%d is started", this.getSimulation().clock(), entry.getKey().getId(), oldHost.getId(), targetHost.getId());
                }
                targetHost.addMigratingInVm(entry.getKey());
                this.incrementMigrationCount();
                double delay = this.timeToMigrateVm(entry.getKey(), targetHost);
                this.send(this.getId(), delay, 35, entry);
            }
        }
    }

    private double getNextCloudletFinishTime(double currentTime) {
        double minTime = Double.MAX_VALUE;
        for (PowerHostSimple host : this.getHostList()) {
            Log.printFormattedLine("\n%.2f: Host #%d", this.getSimulation().clock(), host.getId());
            double nextCloudletFinishTime = host.updateProcessing(currentTime);
            minTime = Math.min(nextCloudletFinishTime, minTime);
        }
        return minTime;
    }

    private double getDatacenterPowerUsageForTimeSpan() {
        double timeSpan = this.getSimulation().clock() - this.getLastProcessTime();
        double datacenterPowerUsageForTimeSpan = 0.0;
        for (PowerHostSimple host : this.getHostList()) {
            Log.printFormattedLine("%.2f: Host #%d", this.getSimulation().clock(), host.getId());
            double hostPower = this.getHostConsumedPowerForTimeSpan(host, timeSpan);
            datacenterPowerUsageForTimeSpan += hostPower;
            this.println(String.format("%.2f: Host #%d utilization is %.2f%%", this.getSimulation().clock(), host.getId(), host.getUtilizationOfCpu() * 100.0));
            this.println(String.format("%.2f: Host #%d energy is %.2f W*sec", this.getSimulation().clock(), host.getId(), hostPower));
        }
        return datacenterPowerUsageForTimeSpan;
    }

    private double getHostConsumedPowerForTimeSpan(PowerHostSimple host, double timeSpan) {
        double hostPower;
        try {
            hostPower = host.getMaxPower() * timeSpan;
        }
        catch (IllegalArgumentException e) {
            hostPower = 0.0;
        }
        return hostPower;
    }
}

