/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import java.util.Random;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.cloudbus.cloudsim.distributions.ContinuousDistributionAbstract;

public class UniformDistr
extends ContinuousDistributionAbstract {
    private boolean applyAntitheticVariatesTechnique = false;

    public UniformDistr() {
        this(0.0, 1.0);
    }

    public UniformDistr(long seed) {
        this(0.0, 1.0, seed);
    }

    public UniformDistr(double max) {
        this(0.0, max, -1L);
    }

    public UniformDistr(double min, double max) {
        this(min, max, -1L);
    }

    public UniformDistr(double min, double max, long seed) {
        super((RealDistribution)new UniformRealDistribution(min, max), seed);
    }

    @Override
    public double sample() {
        return this.applyAntitheticVariatesTechnique ? 1.0 - super.sample() : super.sample();
    }

    public static double sample(Random rd, double min, double max) {
        if (min >= max) {
            throw new IllegalArgumentException("Maximum must be greater than the minimum.");
        }
        return rd.nextDouble() * (max - min) + min;
    }

    public boolean isApplyAntitheticVariatesTechnique() {
        return this.applyAntitheticVariatesTechnique;
    }

    public UniformDistr setApplyAntitheticVariatesTechnique(boolean applyAntitheticVariatesTechnique) {
        this.applyAntitheticVariatesTechnique = applyAntitheticVariatesTechnique;
        return this;
    }
}

