/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostDynamicWorkload;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.hosts.HostStateHistoryEntry;
import org.cloudbus.cloudsim.lists.PeList;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmStateHistoryEntry;

public class HostDynamicWorkloadSimple
extends HostSimple
implements HostDynamicWorkload {
    private double previousUtilizationMips;
    private final List<HostStateHistoryEntry> stateHistory;

    public HostDynamicWorkloadSimple(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
        this.setPreviousUtilizationMips(0.0);
        this.stateHistory = new LinkedList<HostStateHistoryEntry>();
    }

    @Deprecated
    public HostDynamicWorkloadSimple(int id, ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList, VmScheduler vmScheduler) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setVmScheduler(vmScheduler);
    }

    @Override
    public double updateProcessing(double currentTime) {
        this.setPreviousUtilizationMips(this.getUtilizationOfCpuMips());
        double smallerTime = super.updateProcessing(currentTime);
        double hostTotalRequestedMips = 0.0;
        for (Vm vm : this.getVmList()) {
            double totalRequestedMips = vm.getCurrentRequestedTotalMips();
            this.showVmResourceUsageOnHost(vm);
            double totalAllocatedMips = this.addVmResourceUseToHistoryIfNotMigratingIn(vm, currentTime);
            hostTotalRequestedMips += totalRequestedMips;
        }
        this.addStateHistoryEntry(currentTime, this.getUtilizationOfCpuMips(), hostTotalRequestedMips, this.getUtilizationOfCpuMips() > 0.0);
        return smallerTime;
    }

    private double addVmResourceUseToHistoryIfNotMigratingIn(Vm vm, double currentTime) {
        double totalAllocatedMips = this.getVmScheduler().getTotalAllocatedMipsForVm(vm);
        if (this.getVmsMigratingIn().contains(vm)) {
            Log.printFormattedLine("%.2f: [" + this + "] " + vm + " is migrating in", this.getSimulation().clock());
            return totalAllocatedMips;
        }
        double totalRequestedMips = vm.getCurrentRequestedTotalMips();
        if (totalAllocatedMips + 0.1 < totalRequestedMips) {
            String reason = this.getVmsMigratingOut().contains(vm) ? "migration overhead" : "capacity unavailability";
            double notAllocatedMipsByPe = (totalRequestedMips - totalAllocatedMips) / (double)vm.getNumberOfPes();
            Log.printFormattedLine("%.2f: [%s] %.0f MIPS not allocated for each one of the %d PEs from %s due to %s.", this.getSimulation().clock(), this, notAllocatedMipsByPe, vm.getNumberOfPes(), vm, reason);
        }
        VmStateHistoryEntry entry = new VmStateHistoryEntry(currentTime, totalAllocatedMips, totalRequestedMips, vm.isInMigration() && !this.getVmsMigratingIn().contains(vm));
        vm.addStateHistoryEntry(entry);
        if (vm.isInMigration()) {
            Log.printFormattedLine("%.2f: [" + this + "] " + vm + " is migrating out ", this.getSimulation().clock());
            totalAllocatedMips /= this.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        }
        return totalAllocatedMips;
    }

    @Override
    public void addStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean isActive) {
        HostStateHistoryEntry previousState;
        HostStateHistoryEntry newState = new HostStateHistoryEntry(time, allocatedMips, requestedMips, isActive);
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == time) {
            this.stateHistory.set(this.stateHistory.size() - 1, newState);
            return;
        }
        this.stateHistory.add(newState);
    }

    private void showVmResourceUsageOnHost(Vm vm) {
        if (Log.isDisabled() || vm.getHost() == Host.NULL) {
            return;
        }
        double totalRequestedMips = vm.getCurrentRequestedTotalMips();
        double totalAllocatedMips = this.getVmScheduler().getTotalAllocatedMipsForVm(vm);
        this.getDatacenter().println(String.format("%.2f: [" + this + "] Total allocated MIPS for " + vm + " (" + vm.getHost() + ") is %.2f. Vm requested %.2f out of its total %.2f MIPS (%.2f%%)", this.getSimulation().clock(), totalAllocatedMips, totalRequestedMips, vm.getTotalMipsCapacity(), totalRequestedMips / vm.getTotalMipsCapacity() * 100.0));
        List<Pe> pes = this.getVmScheduler().getPesAllocatedForVm(vm);
        StringBuilder pesString = new StringBuilder();
        pes.forEach(pe -> pesString.append(String.format(" PE #%d: %d.", pe.getId(), pe.getPeProvisioner().getAllocatedResourceForVm(vm))));
        this.getDatacenter().println(String.format("%.2f: [" + this + "] MIPS for " + vm + " working PEs (" + this.getNumberOfWorkingPes() + " * " + this.getVmScheduler().getPeCapacity() + "): " + pesString, this.getSimulation().clock()));
    }

    @Override
    public List<Vm> getFinishedVms() {
        return this.getVmList().stream().filter(vm -> !vm.isInMigration()).filter(vm -> vm.getCurrentRequestedTotalMips() == 0.0).collect(Collectors.toList());
    }

    @Override
    public double getMaxUtilization() {
        return PeList.getMaxUtilization(this.getPeList());
    }

    @Override
    public double getMaxUtilizationAmongVmsPes(Vm vm) {
        return PeList.getMaxUtilizationAmongVmsPes(this.getPeList(), vm);
    }

    @Override
    public double getPreviousUtilizationOfCpu() {
        return this.computeCpuUtilizationPercent(this.getPreviousUtilizationMips());
    }

    @Override
    public double getPreviousUtilizationMips() {
        return this.previousUtilizationMips;
    }

    protected final void setPreviousUtilizationMips(double previousUtilizationMips) {
        this.previousUtilizationMips = previousUtilizationMips;
    }

    @Override
    public List<HostStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }
}

