/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.core.Identificable;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.lists.PeList;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.resources.Storage;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;

public class HostSimple
implements Host {
    private int id;
    private Ram ram;
    private Bandwidth bw;
    private Storage storage;
    private ResourceProvisioner ramProvisioner;
    private ResourceProvisioner bwProvisioner;
    private VmScheduler vmScheduler;
    private final List<Vm> vmList = new ArrayList<Vm>();
    private List<Pe> peList;
    private boolean failed;
    private final Set<Vm> vmsMigratingIn;
    private final Set<Vm> vmsMigratingOut;
    private Datacenter datacenter;
    private Set<EventListener<HostUpdatesVmsProcessingEventInfo>> onUpdateProcessingListeners;
    private Simulation simulation;
    private List<ResourceManageable> resources;
    private List<ResourceProvisioner> provisioners;
    private boolean active;
    private List<Vm> vmCreatedList;

    public HostSimple(long ram, long bw, long storage, List<Pe> peList) {
        this.setId(-1);
        this.setActive(true);
        this.setSimulation(Simulation.NULL);
        this.ram = new Ram(ram);
        this.bw = new Bandwidth(bw);
        this.setStorage(storage);
        this.setRamProvisioner(ResourceProvisioner.NULL);
        this.setBwProvisioner(ResourceProvisioner.NULL);
        this.setVmScheduler(VmScheduler.NULL);
        this.setPeList(peList);
        this.setFailed(false);
        this.setDatacenter(Datacenter.NULL);
        this.onUpdateProcessingListeners = new HashSet<EventListener<HostUpdatesVmsProcessingEventInfo>>();
        this.resources = new ArrayList<ResourceManageable>();
        this.vmCreatedList = new ArrayList<Vm>();
        this.provisioners = new ArrayList<ResourceProvisioner>();
        this.vmsMigratingIn = new HashSet<Vm>();
        this.vmsMigratingOut = new HashSet<Vm>();
    }

    @Deprecated
    public HostSimple(int id, ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList, VmScheduler vmScheduler) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setPeList(peList);
        this.setVmScheduler(vmScheduler);
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.peList.stream().filter(Pe::isWorking).mapToDouble(Pe::getCapacity).sum();
    }

    @Override
    public double updateProcessing(double currentTime) {
        double nextSimulationTime = this.vmList.stream().mapToDouble(vm -> vm.updateProcessing(currentTime, this.vmScheduler.getAllocatedMips((Vm)vm))).min().orElse(Double.MAX_VALUE);
        this.notifyOnUpdateProcessingListeners(nextSimulationTime);
        return nextSimulationTime;
    }

    private void notifyOnUpdateProcessingListeners(double nextSimulationTime) {
        HostUpdatesVmsProcessingEventInfo info = HostUpdatesVmsProcessingEventInfo.of(this, nextSimulationTime);
        this.onUpdateProcessingListeners.forEach(l -> l.update(info));
    }

    @Override
    public boolean removeVmMigratingIn(Vm vm) {
        return this.vmsMigratingIn.remove(vm);
    }

    @Override
    public boolean createVm(Vm vm) {
        boolean result = this.createVmInternal(vm);
        if (result) {
            this.vmCreatedList.add(vm);
            vm.setHost(this);
            vm.notifyOnHostAllocationListeners();
            if (vm.getStartTime() < 0.0) {
                vm.setStartTime(this.getSimulation().clock());
            }
        }
        return result;
    }

    @Override
    public boolean createTemporaryVm(Vm vm) {
        return this.createVmInternal(vm);
    }

    private boolean createVmInternal(Vm vm) {
        if (!this.allocateResourcesForVm(vm, false)) {
            return false;
        }
        this.vmList.add(vm);
        return true;
    }

    private boolean allocateResourcesForVm(Vm vm, boolean inMigration) {
        String msg;
        String string = msg = inMigration ? "VM Migration" : "VM Creation";
        if (!this.storage.isResourceAmountAvailable(vm.getStorage())) {
            Log.printFormattedLine("%.2f: %s: [%s] Allocation of %s to %s failed due to lack of storage. Required %d but there is just %d MB available.", this.simulation.clock(), this.getClass().getSimpleName(), msg, vm, this, vm.getStorage().getCapacity(), this.storage.getAvailableResource());
            return false;
        }
        if (!this.ramProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedRam())) {
            Log.printFormattedLine("%.2f: %s: [%s] Allocation of %s to %s failed due to lack of RAM. Required %d but there is just %d MB available.", this.simulation.clock(), this.getClass().getSimpleName(), msg, vm, this, vm.getRam().getCapacity(), this.ram.getAvailableResource());
            return false;
        }
        if (!this.bwProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedBw())) {
            Log.printFormattedLine("%.2f: %s: [%s] Allocation of %s to %s failed due to lack of BW. Required %d but there is just %d Mbps available.", this.simulation.clock(), this.getClass().getSimpleName(), msg, vm, this, vm.getBw().getCapacity(), this.bw.getAvailableResource());
            return false;
        }
        if (!this.vmScheduler.isSuitableForVm(vm)) {
            Log.printFormattedLine("%.2f: %s: [%s] Allocation of %s to %s failed due to lack of PEs.\n\t  Required %d PEs of %.0f MIPS (%.0f MIPS total). However, there are just %d working PEs of %.0f MIPS, from which %.0f MIPS are available.", this.getSimulation().clock(), this.getClass().getSimpleName(), msg, vm, this, vm.getNumberOfPes(), vm.getMips(), vm.getTotalMipsCapacity(), this.vmScheduler.getWorkingPeList().size(), this.getMips(), this.vmScheduler.getAvailableMips());
            return false;
        }
        vm.setInMigration(inMigration);
        this.storage.allocateResource(vm.getStorage());
        this.ramProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedRam());
        this.bwProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedBw());
        this.vmScheduler.allocatePesForVm(vm, vm.getCurrentRequestedMips());
        return true;
    }

    @Override
    public void reallocateMigratingInVms() {
        for (Vm vm : this.getVmsMigratingIn()) {
            if (!this.vmList.contains(vm)) {
                this.vmList.add(vm);
            }
            this.ramProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedRam());
            this.bwProvisioner.allocateResourceForVm(vm, vm.getCurrentRequestedBw());
            this.vmScheduler.allocatePesForVm(vm, vm.getCurrentRequestedMips());
            this.storage.allocateResource(vm.getStorage());
        }
    }

    @Override
    public boolean isSuitableForVm(Vm vm) {
        return this.active && (double)this.vmScheduler.getPeCapacity() >= vm.getCurrentRequestedMaxMips() && this.vmScheduler.getAvailableMips() >= vm.getCurrentRequestedTotalMips() && this.ramProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedRam()) && this.bwProvisioner.isSuitableForVm(vm, vm.getCurrentRequestedBw());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public final Host setActive(boolean active) {
        this.active = active;
        return this;
    }

    @Override
    public void destroyVm(Vm vm) {
        this.destroyVmInternal(vm);
        vm.notifyOnHostDeallocationListeners(this);
        vm.setStopTime(this.getSimulation().clock());
    }

    @Override
    public void destroyTemporaryVm(Vm vm) {
        this.destroyVmInternal(vm);
    }

    private void destroyVmInternal(Vm vm) {
        if (!Objects.isNull(vm)) {
            this.deallocateResourcesOfVm(vm);
            this.vmList.remove(vm);
        }
    }

    protected void deallocateResourcesOfVm(Vm vm) {
        vm.setCreated(false);
        this.ramProvisioner.deallocateResourceForVm(vm);
        this.bwProvisioner.deallocateResourceForVm(vm);
        this.vmScheduler.deallocatePesFromVm(vm);
        this.storage.deallocateResource(vm.getStorage());
    }

    @Override
    public void destroyAllVms() {
        this.deallocateResourcesOfAllVms();
        for (Vm vm : this.vmList) {
            vm.setCreated(false);
            this.storage.deallocateResource(vm.getStorage());
        }
        this.vmList.clear();
    }

    protected void deallocateResourcesOfAllVms() {
        this.ramProvisioner.deallocateResourceForAllVms();
        this.bwProvisioner.deallocateResourceForAllVms();
        this.vmScheduler.deallocatePesForAllVms();
    }

    @Override
    public Vm getVm(int vmId, int brokerId) {
        return this.vmList.stream().filter(vm -> vm.getId() == vmId && vm.getBroker().getId() == brokerId).findFirst().orElse(Vm.NULL);
    }

    @Override
    public long getNumberOfPes() {
        return this.peList.size();
    }

    @Override
    public int getNumberOfFreePes() {
        return PeList.getNumberOfFreePes(this.getPeList());
    }

    @Override
    public boolean allocatePesForVm(Vm vm, List<Double> mipsShare) {
        return this.vmScheduler.allocatePesForVm(vm, mipsShare);
    }

    @Override
    public void deallocatePesForVm(Vm vm) {
        this.vmScheduler.deallocatePesFromVm(vm);
    }

    @Override
    public List<Double> getAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getAllocatedMips(vm);
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.vmScheduler.getTotalAllocatedMipsForVm(vm);
    }

    @Override
    public double getMaxAvailableMips() {
        return this.vmScheduler.getMaxAvailableMips();
    }

    @Override
    public double getMips() {
        return this.peList.stream().mapToDouble(Pe::getCapacity).findFirst().orElse(0.0);
    }

    @Override
    public double getAvailableMips() {
        return this.vmScheduler.getAvailableMips();
    }

    @Override
    public Resource getBw() {
        return this.bwProvisioner.getResource();
    }

    @Override
    public Resource getRam() {
        return this.ramProvisioner.getResource();
    }

    @Override
    public Resource getStorage() {
        return this.storage;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final void setId(int id) {
        this.id = id;
    }

    @Override
    public ResourceProvisioner getRamProvisioner() {
        return this.ramProvisioner;
    }

    @Override
    public final Host setRamProvisioner(ResourceProvisioner ramProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("RAM");
        this.ramProvisioner = ramProvisioner;
        this.ramProvisioner.setResource(this.ram);
        return this;
    }

    private void checkSimulationIsRunningAndAttemptedToChangeHost(String resourceName) {
        if (this.simulation.isRunning()) {
            throw new UnsupportedOperationException("It is not allowed to change a Host's " + resourceName + " after the simulation started.");
        }
    }

    @Override
    public ResourceProvisioner getBwProvisioner() {
        return this.bwProvisioner;
    }

    @Override
    public final Host setBwProvisioner(ResourceProvisioner bwProvisioner) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("BW");
        this.bwProvisioner = bwProvisioner;
        this.bwProvisioner.setResource(this.bw);
        return this;
    }

    @Override
    public VmScheduler getVmScheduler() {
        return this.vmScheduler;
    }

    @Override
    public final Host setVmScheduler(VmScheduler vmScheduler) {
        if (Objects.isNull(vmScheduler)) {
            vmScheduler = VmScheduler.NULL;
        }
        vmScheduler.setHost(this);
        this.vmScheduler = vmScheduler;
        return this;
    }

    @Override
    public List<Pe> getPeList() {
        return this.peList;
    }

    protected final Host setPeList(List<Pe> peList) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("List of PE");
        this.peList = Objects.isNull(peList) ? new ArrayList() : peList;
        int peId = this.peList.stream().filter(pe -> pe.getId() > 0).mapToInt(Identificable::getId).max().orElse(-1);
        List pesWithoutIds = this.peList.stream().filter(pe -> pe.getId() < 0).collect(Collectors.toList());
        for (Pe pe2 : pesWithoutIds) {
            pe2.setId(++peId);
        }
        return this;
    }

    @Override
    public <T extends Vm> List<T> getVmList() {
        return Collections.unmodifiableList(this.vmList);
    }

    @Override
    public <T extends Vm> List<T> getVmCreatedList() {
        return Collections.unmodifiableList(this.vmCreatedList);
    }

    protected void addVmToList(Vm vm) {
        Objects.requireNonNull(vm);
        this.vmList.add(vm);
    }

    protected void removeVmFromList(Vm vm) {
        Objects.requireNonNull(vm);
        this.vmList.remove(vm);
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public final boolean setFailed(boolean failed) {
        this.failed = failed;
        PeList.setStatusFailed(this.peList, this.getId(), failed);
        return true;
    }

    @Override
    public boolean setPeStatus(int peId, Pe.Status status) {
        return PeList.setPeStatus(this.peList, peId, status);
    }

    @Override
    public <T extends Vm> Set<T> getVmsMigratingIn() {
        return this.vmsMigratingIn;
    }

    @Override
    public boolean addMigratingInVm(Vm vm) {
        if (this.vmsMigratingIn.contains(vm)) {
            return false;
        }
        this.vmsMigratingIn.add(vm);
        if (!this.allocateResourcesForVm(vm, true)) {
            this.vmsMigratingIn.remove(vm);
            return false;
        }
        this.updateProcessing(this.simulation.clock());
        vm.getHost().updateProcessing(this.simulation.clock());
        return true;
    }

    @Override
    public void removeMigratingInVm(Vm vm) {
        this.deallocateResourcesOfVm(vm);
        this.vmsMigratingIn.remove(vm);
        this.vmList.remove(vm);
        vm.setInMigration(false);
    }

    @Override
    public Set<Vm> getVmsMigratingOut() {
        return Collections.unmodifiableSet(this.vmsMigratingOut);
    }

    @Override
    public boolean addVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.add(vm);
    }

    @Override
    public boolean removeVmMigratingOut(Vm vm) {
        return this.vmsMigratingOut.remove(vm);
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public final void setDatacenter(Datacenter datacenter) {
        this.checkSimulationIsRunningAndAttemptedToChangeHost("Datacenter");
        this.datacenter = datacenter;
    }

    public String toString() {
        String dc = Datacenter.NULL.equals(this.datacenter) ? "" : String.format("/DC %d", this.datacenter.getId());
        return String.format("Host %d%s", this.getId(), dc);
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public Host addOnUpdateProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public long getAvailableStorage() {
        return this.storage.getAvailableResource();
    }

    @Override
    public long getNumberOfWorkingPes() {
        return (long)this.peList.size() - this.getNumberOfFailedPes();
    }

    @Override
    public long getNumberOfFailedPes() {
        return this.peList.stream().filter(Pe::isFailed).count();
    }

    private Host setStorage(long size) {
        this.storage = new Storage(size);
        return this;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public final Host setSimulation(Simulation simulation) {
        this.simulation = simulation;
        return this;
    }

    @Override
    public int compareTo(Host o) {
        return Double.compare(this.getTotalMipsCapacity(), o.getTotalMipsCapacity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostSimple that = (HostSimple)o;
        if (this.id != that.id) {
            return false;
        }
        return this.simulation.equals(that.simulation);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.simulation.hashCode();
        return result;
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.simulation.isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ramProvisioner.getResource(), this.bwProvisioner.getResource());
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceProvisioner getProvisioner(Class<? extends ResourceManageable> resourceClass) {
        if (this.simulation.isRunning() && this.provisioners.isEmpty()) {
            this.provisioners = Arrays.asList(this.ramProvisioner, this.bwProvisioner);
        }
        return this.provisioners.stream().filter(r -> r.getResource().isObjectSubClassOf(resourceClass)).findFirst().orElse(ResourceProvisioner.NULL);
    }

    @Override
    public List<Pe> getWorkingPeList() {
        return this.peList.stream().filter(Pe::isWorking).collect(Collectors.toList());
    }

    @Override
    public double getUtilizationOfCpu() {
        return this.computeCpuUtilizationPercent(this.getUtilizationOfCpuMips());
    }

    protected double computeCpuUtilizationPercent(double mipsUsage) {
        double totalMips = this.getTotalMipsCapacity();
        if (totalMips == 0.0) {
            return 0.0;
        }
        double utilization = mipsUsage / totalMips;
        return utilization > 1.0 && utilization < 1.01 ? 1.0 : utilization;
    }

    @Override
    public double getUtilizationOfCpuMips() {
        return this.vmList.stream().mapToDouble(vm -> this.vmScheduler.getTotalAllocatedMipsForVm((Vm)vm)).sum();
    }

    @Override
    public long getUtilizationOfRam() {
        return this.ramProvisioner.getTotalAllocatedResource();
    }

    @Override
    public long getUtilizationOfBw() {
        return this.bwProvisioner.getTotalAllocatedResource();
    }
}

