/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts.network;

import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.lists.PeList;
import org.cloudbus.cloudsim.lists.VmList;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.PacketScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.PacketSchedulerSimple;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class NetworkHost
extends HostSimple {
    private int totalDataTransferBytes;
    private final List<HostPacket> pktsToSendForLocalVms;
    private final List<HostPacket> pktsToSendForExternalVms;
    private final List<HostPacket> hostPktsReceived = new ArrayList<HostPacket>();
    private EdgeSwitch edgeSwitch;
    private double bandwidth;

    public NetworkHost(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
        this.pktsToSendForExternalVms = new ArrayList<HostPacket>();
        this.pktsToSendForLocalVms = new ArrayList<HostPacket>();
    }

    @Deprecated
    public NetworkHost(int id, ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList, VmScheduler vmScheduler) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setVmScheduler(vmScheduler);
    }

    @Override
    public double updateProcessing(double currentTime) {
        double timeOfNextFinishingCloudlet = super.updateProcessing(currentTime);
        this.receivePackets();
        this.sendAllPacketListsOfAllVms();
        return timeOfNextFinishingCloudlet;
    }

    private void receivePackets() {
        for (HostPacket hostPkt : this.hostPktsReceived) {
            hostPkt.getVmPacket().setReceiveTime(this.getSimulation().clock());
            Object destinationVm = VmList.getById(this.getVmList(), hostPkt.getVmPacket().getDestination().getId());
            if (destinationVm.equals(Vm.NULL)) {
                Log.println(Log.Level.ERROR, this.getClass(), this.getSimulation().clock(), "Destination VM %d was not found inside the Host %d", hostPkt.getVmPacket().getDestination().getId(), this.getId());
                return;
            }
            PacketScheduler pktScheduler = this.getVmPacketScheduler((Vm)destinationVm);
            pktScheduler.addPacketToListOfPacketsSentFromVm(hostPkt.getVmPacket());
            Log.println(Log.Level.DEBUG, this.getClass(), this.getSimulation().clock(), "Host %d received pkt with %d bytes from Cloudlet %d in VM %d and forwarded it to Cloudlet %d in VM %d", this.getId(), hostPkt.getVmPacket().getSize(), hostPkt.getVmPacket().getSenderCloudlet().getId(), hostPkt.getVmPacket().getSource().getId(), hostPkt.getVmPacket().getReceiverCloudlet().getId(), hostPkt.getVmPacket().getDestination().getId());
        }
        this.hostPktsReceived.clear();
    }

    private void sendAllPacketListsOfAllVms() {
        this.getVmList().forEach(this::collectListOfPacketsToSendFromVm);
        this.sendPacketsToLocalVms();
        this.sendPacketsToExternalVms();
    }

    private void sendPacketsToLocalVms() {
        for (HostPacket hostPkt : this.pktsToSendForLocalVms) {
            hostPkt.setSendTime(hostPkt.getReceiveTime());
            hostPkt.getVmPacket().setReceiveTime(this.getSimulation().clock());
            Vm destinationVm = hostPkt.getVmPacket().getDestination();
            this.getVmPacketScheduler(destinationVm).addPacketToListOfPacketsSentFromVm(hostPkt.getVmPacket());
        }
        if (!this.pktsToSendForLocalVms.isEmpty()) {
            for (Vm vm : this.getVmList()) {
                vm.updateProcessing(this.getSimulation().clock(), this.getVmScheduler().getAllocatedMips(vm));
            }
        }
        this.pktsToSendForLocalVms.clear();
    }

    private void sendPacketsToExternalVms() {
        double availableBwByPacket = this.getBandwidthByPacket(this.pktsToSendForExternalVms.size());
        for (HostPacket hostPkt : this.pktsToSendForExternalVms) {
            double delay = Conversion.bytesToMegaBits(hostPkt.getVmPacket().getSize()) / availableBwByPacket;
            this.totalDataTransferBytes = (int)((long)this.totalDataTransferBytes + hostPkt.getVmPacket().getSize());
            this.getSimulation().send(this.getDatacenter().getId(), this.getEdgeSwitch().getId(), delay, 43, hostPkt);
        }
        this.pktsToSendForExternalVms.clear();
    }

    private double getBandwidthByPacket(double numberOfPackets) {
        return numberOfPackets == 0.0 ? this.bandwidth : this.bandwidth / numberOfPackets;
    }

    private PacketScheduler getVmPacketScheduler(Vm vm) {
        return vm.getCloudletScheduler().getPacketScheduler();
    }

    @Override
    public boolean createVm(Vm vm) {
        boolean isVmCreated = super.createVm(vm);
        this.setPacketScheduler(vm);
        return isVmCreated;
    }

    private void setPacketScheduler(Vm vm) {
        CloudletScheduler cs = vm.getCloudletScheduler();
        if (!cs.isTherePacketScheduler()) {
            cs.setPacketScheduler(new PacketSchedulerSimple());
        }
    }

    private void collectListOfPacketsToSendFromVm(Vm sourceVm) {
        PacketScheduler packetScheduler = this.getVmPacketScheduler(sourceVm);
        for (VmPacket vmPkt : packetScheduler.getVmPacketsToSend()) {
            this.collectPacketToSendFromVm(vmPkt);
        }
        packetScheduler.clearVmPacketsToSend();
    }

    private void collectPacketToSendFromVm(VmPacket vmPkt) {
        HostPacket hostPkt = new HostPacket(this, vmPkt);
        Object receiverVm = VmList.getById(this.getVmList(), vmPkt.getDestination().getId());
        if (!receiverVm.equals(Vm.NULL)) {
            this.pktsToSendForLocalVms.add(hostPkt);
        } else {
            this.pktsToSendForExternalVms.add(hostPkt);
        }
    }

    public double getMaxUtilizationAmongVmsPes(Vm vm) {
        return PeList.getMaxUtilizationAmongVmsPes(this.getPeList(), vm);
    }

    public EdgeSwitch getEdgeSwitch() {
        return this.edgeSwitch;
    }

    public void setEdgeSwitch(EdgeSwitch sw) {
        this.edgeSwitch = sw;
        this.bandwidth = sw.getDownlinkBandwidth();
    }

    public int getTotalDataTransferBytes() {
        return this.totalDataTransferBytes;
    }

    public void addReceivedNetworkPacket(HostPacket hostPacket) {
        this.hostPktsReceived.add(hostPacket);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }
}

