/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts.power;

import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.hosts.HostDynamicWorkloadSimple;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;

public class PowerHostSimple
extends HostDynamicWorkloadSimple
implements PowerHost {
    private PowerModel powerModel;

    public PowerHostSimple(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
        this.setPowerModel(PowerModel.NULL);
    }

    @Deprecated
    public PowerHostSimple(int id, ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList, VmScheduler vmScheduler, PowerModel powerModel) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setVmScheduler(vmScheduler);
        this.setPowerModel(powerModel);
    }

    @Override
    public double getPower() {
        return this.getPower(this.getUtilizationOfCpu());
    }

    protected double getPower(double utilization) {
        try {
            return this.getPowerModel().getPower(utilization);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getMaxPower() {
        return this.getPowerModel().getPower(1.0);
    }

    @Override
    public double getEnergyLinearInterpolation(double fromUtilization, double toUtilization, double time) {
        if (fromUtilization == 0.0) {
            return 0.0;
        }
        double fromPower = this.getPower(fromUtilization);
        double toPower = this.getPower(toUtilization);
        return (fromPower + (toPower - fromPower) / 2.0) * time;
    }

    @Override
    public final PowerHost setPowerModel(PowerModel powerModel) {
        Objects.requireNonNull(powerModel);
        this.powerModel = powerModel;
        this.powerModel.setHost(this);
        return this;
    }

    @Override
    public PowerModel getPowerModel() {
        return this.powerModel;
    }
}

