/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.hosts.power;

import java.util.List;
import org.cloudbus.cloudsim.hosts.power.PowerHostSimple;
import org.cloudbus.cloudsim.power.models.PowerModel;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.power.PowerVm;

public class PowerHostUtilizationHistory
extends PowerHostSimple {
    public PowerHostUtilizationHistory(long ram, long bw, long storage, List<Pe> peList) {
        super(ram, bw, storage, peList);
    }

    @Deprecated
    public PowerHostUtilizationHistory(int id, ResourceProvisioner ramProvisioner, ResourceProvisioner bwProvisioner, long storage, List<Pe> peList, VmScheduler vmScheduler, PowerModel powerModel) {
        this(ramProvisioner.getCapacity(), bwProvisioner.getCapacity(), storage, peList);
        this.setRamProvisioner(ramProvisioner);
        this.setBwProvisioner(bwProvisioner);
        this.setVmScheduler(vmScheduler);
        this.setPowerModel(powerModel);
    }

    public double[] getUtilizationHistory() {
        double[] utilizationHistory = new double[30];
        double totalMipsCapacity = this.getTotalMipsCapacity();
        for (PowerVm vm : this.getVmCreatedList()) {
            for (int i = 0; i < vm.getUtilizationHistory().size(); ++i) {
                int n = i;
                utilizationHistory[n] = utilizationHistory[n] + vm.getUtilizationHistory().get(i) * vm.getTotalMipsCapacity() / totalMipsCapacity;
            }
        }
        return MathUtil.trimZeroTail(utilizationHistory);
    }
}

