/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.lists;

import java.util.List;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.lists.PeList;
import org.cloudbus.cloudsim.resources.Pe;

public final class HostList {
    private HostList() {
    }

    public static <T extends Host> T getById(List<T> hostList, int id) {
        return (T)hostList.stream().filter(h -> h.getId() == id).findFirst().orElse(Host.NULL);
    }

    public static int getNumberOfPes(List<? extends Host> hostList) {
        return hostList.stream().mapToInt(h -> h.getPeList().size()).sum();
    }

    public static int getNumberOfFreePes(List<? extends Host> hostList) {
        return hostList.stream().mapToInt(h -> PeList.getNumberOfFreePes(h.getPeList())).sum();
    }

    public static int getNumberOfBusyPes(List<? extends Host> hostList) {
        return hostList.stream().map(host -> PeList.getNumberOfBusyPes(host.getPeList())).reduce(0, Integer::sum);
    }

    public static <T extends Host> T getHostWithFreePe(List<T> hostList) {
        return HostList.getHostWithFreePe(hostList, 1);
    }

    public static <T extends Host> T getHostWithFreePe(List<T> hostList, int pesNumber) {
        return (T)hostList.stream().filter(host -> PeList.getNumberOfFreePes(host.getPeList()) >= pesNumber).findFirst().orElse(Host.NULL);
    }

    public static boolean setPeStatus(List<? extends Host> hostList, Pe.Status status, int hostId, int peId) {
        Host host = HostList.getById(hostList, hostId);
        return host.setPeStatus(peId, status);
    }
}

