/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.lists;

import java.util.List;
import org.cloudbus.cloudsim.provisioners.PeProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.vms.Vm;

public final class PeList {
    private PeList() {
    }

    public static <T extends Pe> T getById(List<T> peList, int id) {
        return (T)peList.stream().filter(pe -> pe.getId() == id).findFirst().orElse(Pe.NULL);
    }

    public static long getMips(List<? extends Pe> peList, int id) {
        Pe pe = PeList.getById(peList, id);
        return pe == Pe.NULL ? -1L : pe.getCapacity();
    }

    public static long getTotalMips(List<? extends Pe> peList) {
        return peList.stream().mapToLong(Pe::getCapacity).sum();
    }

    public static double getMaxUtilization(List<? extends Pe> peList) {
        return peList.stream().map(Pe::getPeProvisioner).mapToDouble(PeProvisioner::getUtilization).max().orElse(0.0);
    }

    public static double getMaxUtilizationAmongVmsPes(List<? extends Pe> peList, Vm vm) {
        return peList.stream().map(Pe::getPeProvisioner).filter(pv -> pv.getAllocatedResourceForVm(vm) > 0L).mapToDouble(PeProvisioner::getUtilization).max().orElse(0.0);
    }

    public static <T extends Pe> T getFreePe(List<T> peList) {
        return (T)peList.stream().filter(Pe::isFree).findFirst().orElse(Pe.NULL);
    }

    public static boolean setPeStatus(List<? extends Pe> peList, int id, Pe.Status status) {
        Pe pe = PeList.getById(peList, id);
        return pe.setStatus(status);
    }

    public static int getNumberOfBusyPes(List<? extends Pe> peList) {
        return (int)peList.stream().filter(Pe::isBuzy).count();
    }

    public static int getNumberOfFreePes(List<? extends Pe> peList) {
        return (int)peList.stream().filter(Pe::isFree).count();
    }

    public static void setStatusFailed(List<? extends Pe> peList, int hostId, boolean failed) {
        PeList.setStatusFailed(peList, failed);
    }

    public static <T extends Pe> void setStatusFailed(List<T> peList, boolean failed) {
        Pe.Status status = failed ? Pe.Status.FAILED : Pe.Status.FREE;
        peList.forEach(pe -> pe.setStatus(status));
    }
}

