/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.lists;

import java.util.Comparator;
import java.util.List;
import org.cloudbus.cloudsim.vms.Vm;

public final class VmList {
    private VmList() {
    }

    public static <T extends Vm> T getById(List<T> vmList, int id) {
        return (T)vmList.stream().filter(vm -> vm.getId() == id).findFirst().orElse(Vm.NULL);
    }

    public static <T extends Vm> T getByIdAndUserId(List<T> vmList, int id, int userId) {
        return (T)vmList.stream().filter(vm -> vm.getId() == id && vm.getBroker().getId() == userId).findFirst().orElse(Vm.NULL);
    }

    public static void sortByCpuUtilization(List<? extends Vm> vmList, double simulationTime) {
        Comparator<Vm> comparator = Comparator.comparingDouble(vm -> vm.getTotalCpuMipsUsage(simulationTime));
        vmList.sort(comparator.reversed());
    }
}

