/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.network.NetworkPacket;

public class IcmpPacket
implements NetworkPacket<SimEntity> {
    private int tag;
    private final String name;
    private long size;
    private final int packetId;
    private SimEntity source;
    private SimEntity destination;
    private SimEntity lastHop;
    private int netServiceLevel;
    private double bandwidth;
    private final List<SimEntity> entities;
    private final List<Double> entryTimes;
    private final List<Double> exitTimes;
    private final List<Double> baudRates;
    private final DecimalFormat num;
    private double sendTime;
    private double receiveTime;

    public IcmpPacket(String name, int packetID, long size, SimEntity source, SimEntity destination, int netServiceLevel) {
        this.name = name;
        this.packetId = packetID;
        this.source = source;
        this.destination = destination;
        this.size = size;
        this.netServiceLevel = netServiceLevel;
        this.entities = new ArrayList<SimEntity>();
        this.entryTimes = new ArrayList<Double>();
        this.exitTimes = new ArrayList<Double>();
        this.baudRates = new ArrayList<Double>();
        this.lastHop = this.source;
        this.tag = 105;
        this.bandwidth = -1.0;
        this.num = new DecimalFormat("#0.000#");
    }

    public int getId() {
        return this.packetId;
    }

    public String toString() {
        if (Objects.isNull(this.name)) {
            return "Empty IcmpPacket that contains no ping information.";
        }
        int SIZE = 1000;
        StringBuilder sb = new StringBuilder(1000);
        sb.append("Ping information for ").append(this.name).append('\n').append("Entity Name\tEntry Time\tExit Time\t Bandwidth\n").append("----------------------------------------------------------\n");
        String tab = "    ";
        for (int i = 0; i < this.entities.size(); ++i) {
            int resID = this.entities.get(i).getId();
            String entry = this.getData(this.entryTimes, i);
            String exit = this.getData(this.exitTimes, i);
            String bw = this.getData(this.baudRates, i);
            sb.append("Entity ").append(resID).append("\t\t").append(String.format("%s%s%s%s%s%s%s\n", entry, "    ", "    ", exit, "    ", "    ", bw));
        }
        sb.append("\nRound Trip Time : ").append(this.num.format(this.getTotalResponseTime())).append(" seconds").append("\nNumber of Hops  : ").append(this.getNumberOfHops()).append("\nBottleneck Bandwidth : ").append(this.bandwidth).append(" bits/s");
        return sb.toString();
    }

    private String getData(List<Double> v, int index) {
        try {
            double id = v.get(index);
            return this.num.format(id);
        }
        catch (Exception e) {
            return "    N/A";
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public boolean setSize(long size) {
        if (size < 0L) {
            return false;
        }
        this.size = size;
        return true;
    }

    @Override
    public SimEntity getSource() {
        return this.source;
    }

    @Override
    public void setSource(SimEntity source) {
        this.source = source;
    }

    @Override
    public SimEntity getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(SimEntity destination) {
        this.destination = destination;
    }

    @Override
    public double getSendTime() {
        return this.sendTime;
    }

    @Override
    public void setSendTime(double time) {
        this.sendTime = time;
    }

    @Override
    public double getReceiveTime() {
        return this.receiveTime;
    }

    @Override
    public void setReceiveTime(double time) {
        this.receiveTime = time;
    }

    public int getNumberOfHops() {
        int PAIR = 2;
        return (this.entities.size() - 2 + 1) / 2;
    }

    public double getTotalResponseTime() {
        try {
            double startTime = this.exitTimes.stream().findFirst().orElse(0.0);
            double receiveTime = this.entryTimes.stream().findFirst().orElse(0.0);
            return receiveTime - startTime;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getBaudRate() {
        return this.bandwidth;
    }

    public void addHop(SimEntity entity) {
        this.entities.add(entity);
    }

    public void addEntryTime(double time) {
        this.entryTimes.add(Math.min(time, 0.0));
    }

    public void addExitTime(double time) {
        this.exitTimes.add(Math.min(time, 0.0));
    }

    public void addBaudRate(double baudRate) {
        this.baudRates.add(baudRate);
        if (this.bandwidth < 0.0 || baudRate < this.bandwidth) {
            this.bandwidth = baudRate;
        }
    }

    public List<Double> getDetailBaudRate() {
        return Collections.unmodifiableList(this.baudRates);
    }

    public List<SimEntity> getHopsList() {
        return Collections.unmodifiableList(this.entities);
    }

    public List<Double> getDetailEntryTimes() {
        return Collections.unmodifiableList(this.entryTimes);
    }

    public List<Double> getDetailExitTimes() {
        return Collections.unmodifiableList(this.exitTimes);
    }

    public SimEntity getLastHop() {
        return this.lastHop;
    }

    public void setLastHop(SimEntity entity) {
        this.lastHop = entity;
    }

    public int getNetServiceLevel() {
        return this.netServiceLevel;
    }

    public void setNetServiceLevel(int netServiceLevel) {
        this.netServiceLevel = netServiceLevel;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean setTag(int tag) {
        if (tag < 105 || tag > 106) {
            return false;
        }
        this.tag = tag;
        return true;
    }
}

