/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.core.predicates.PredicateType;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.lists.VmList;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.util.Conversion;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class AbstractSwitch
extends CloudSimEntity
implements Switch {
    private final Map<Switch, List<HostPacket>> uplinkSwitchPacketMap;
    private final Map<Switch, List<HostPacket>> downlinkSwitchPacketMap;
    private final List<NetworkHost> hostList;
    private final List<Switch> uplinkSwitches;
    private final List<Switch> downlinkSwitches;
    private final Map<NetworkHost, List<HostPacket>> packetToHostMap;
    private double uplinkBandwidth;
    private double downlinkBandwidth;
    private int ports;
    private NetworkDatacenter datacenter;
    private final List<HostPacket> packetList = new ArrayList<HostPacket>();
    private double switchingDelay;

    public AbstractSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation);
        this.hostList = new ArrayList<NetworkHost>();
        this.packetToHostMap = new HashMap<NetworkHost, List<HostPacket>>();
        this.uplinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitches = new ArrayList<Switch>();
        this.uplinkSwitches = new ArrayList<Switch>();
        this.datacenter = dc;
    }

    @Override
    protected void startEntity() {
        Log.printConcatLine(this.getName(), " is starting...");
        this.schedule(this.getId(), 0.0, 4);
    }

    @Override
    public void processEvent(SimEvent ev) {
        switch (ev.getTag()) {
            case 43: {
                this.processPacketUp(ev);
                break;
            }
            case 46: {
                this.processPacketDown(ev);
                break;
            }
            case 44: {
                this.processPacketForward(ev);
                break;
            }
            case 47: {
                this.processHostPacket(ev);
                break;
            }
            case 45: {
                this.registerHost(ev);
                break;
            }
            default: {
                this.processOtherEvent(ev);
            }
        }
    }

    protected void processHostPacket(SimEvent ev) {
        HostPacket pkt = (HostPacket)ev.getData();
        NetworkHost host = pkt.getDestination();
        host.addReceivedNetworkPacket(pkt);
    }

    protected void processPacketDown(SimEvent ev) {
        this.getSimulation().cancelAll(this.getId(), new PredicateType(44));
        this.schedule(this.getId(), this.getSwitchingDelay(), 44);
    }

    protected NetworkHost getVmHost(Vm vm) {
        return (NetworkHost)vm.getHost();
    }

    protected void processPacketUp(SimEvent ev) {
        this.getSimulation().cancelAll(this.getId(), new PredicateType(44));
        this.schedule(this.getId(), this.switchingDelay, 44);
    }

    private void registerHost(SimEvent ev) {
        NetworkHost host = (NetworkHost)ev.getData();
        this.hostList.add(host);
    }

    protected void processOtherEvent(SimEvent ev) {
    }

    protected void processPacketForward(SimEvent ev) {
        this.forwardPacketsToDownlinkSwitches();
        this.forwardPacketsToUplinkSwitches();
        this.forwardPacketsToHosts();
    }

    private void forwardPacketsToDownlinkSwitches() {
        for (Switch destinationSwitch : this.downlinkSwitchPacketMap.keySet()) {
            List<HostPacket> netPktList = this.getDownlinkSwitchPacketList(destinationSwitch);
            for (HostPacket pkt : netPktList) {
                double delay = this.networkDelayForPacketTransmission(pkt, this.downlinkBandwidth, netPktList);
                this.send(destinationSwitch.getId(), delay, 46, (Object)pkt);
            }
            netPktList.clear();
        }
    }

    private void forwardPacketsToUplinkSwitches() {
        for (Switch destinationSwitch : this.uplinkSwitchPacketMap.keySet()) {
            List<HostPacket> packetList = this.getUplinkSwitchPacketList(destinationSwitch);
            for (HostPacket pkt : packetList) {
                double delay = this.networkDelayForPacketTransmission(pkt, this.uplinkBandwidth, packetList);
                this.send(destinationSwitch.getId(), delay, 43, (Object)pkt);
            }
            packetList.clear();
        }
    }

    private void forwardPacketsToHosts() {
        for (NetworkHost host : this.packetToHostMap.keySet()) {
            List<HostPacket> packetList = this.getHostPacketList(host);
            for (HostPacket pkt : packetList) {
                double delay = this.networkDelayForPacketTransmission(pkt, this.downlinkBandwidth, packetList);
                this.send(this.getId(), delay, 47, (Object)pkt);
            }
            packetList.clear();
        }
    }

    protected double networkDelayForPacketTransmission(HostPacket netPkt, double bwCapacity, List<HostPacket> netPktList) {
        return Conversion.bytesToMegaBits(netPkt.getVmPacket().getSize()) / this.getAvailableBwForEachPacket(bwCapacity, netPktList);
    }

    private double getAvailableBwForEachPacket(double bwCapacity, List<HostPacket> netPktList) {
        return netPktList.isEmpty() ? bwCapacity : bwCapacity / (double)netPktList.size();
    }

    protected NetworkHost getHostOfVm(int vmId) {
        for (NetworkHost host : this.hostList) {
            Object vm = VmList.getById(host.getVmList(), vmId);
            if (vm == Vm.NULL) continue;
            return host;
        }
        return null;
    }

    @Override
    public void shutdownEntity() {
        Log.printConcatLine(this.getName(), " is shutting down...");
    }

    @Override
    public double getUplinkBandwidth() {
        return this.uplinkBandwidth;
    }

    @Override
    public final void setUplinkBandwidth(double uplinkBandwidth) {
        this.uplinkBandwidth = uplinkBandwidth;
    }

    @Override
    public double getDownlinkBandwidth() {
        return this.downlinkBandwidth;
    }

    @Override
    public final void setDownlinkBandwidth(double downlinkBandwidth) {
        this.downlinkBandwidth = downlinkBandwidth;
    }

    @Override
    public int getPorts() {
        return this.ports;
    }

    @Override
    public final void setPorts(int ports) {
        this.ports = ports;
    }

    @Override
    public double getSwitchingDelay() {
        return this.switchingDelay;
    }

    @Override
    public final void setSwitchingDelay(double switchingDelay) {
        this.switchingDelay = switchingDelay;
    }

    @Override
    public List<Switch> getUplinkSwitches() {
        return this.uplinkSwitches;
    }

    @Override
    public List<NetworkHost> getHostList() {
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public void connectHost(NetworkHost host) {
        this.hostList.add(host);
    }

    @Override
    public boolean disconnectHost(NetworkHost host) {
        return this.hostList.remove(host);
    }

    @Override
    public Map<NetworkHost, List<HostPacket>> getPacketToHostMap() {
        return Collections.unmodifiableMap(this.packetToHostMap);
    }

    @Override
    public List<Switch> getDownlinkSwitches() {
        return this.downlinkSwitches;
    }

    @Override
    public List<HostPacket> getDownlinkSwitchPacketList(Switch downlinkSwitch) {
        this.downlinkSwitchPacketMap.putIfAbsent(downlinkSwitch, new ArrayList());
        return this.downlinkSwitchPacketMap.get(downlinkSwitch);
    }

    @Override
    public List<HostPacket> getUplinkSwitchPacketList(Switch uplinkSwitch) {
        this.uplinkSwitchPacketMap.putIfAbsent(uplinkSwitch, new ArrayList());
        return this.uplinkSwitchPacketMap.get(uplinkSwitch);
    }

    @Override
    public List<HostPacket> getHostPacketList(NetworkHost host) {
        this.packetToHostMap.putIfAbsent(host, new ArrayList());
        return this.packetToHostMap.get(host);
    }

    @Override
    public Map<Switch, List<HostPacket>> getUplinkSwitchPacketMap() {
        return Collections.unmodifiableMap(this.uplinkSwitchPacketMap);
    }

    @Override
    public void addPacketToBeSentToDownlinkSwitch(Switch downlinkSwitch, HostPacket packet) {
        this.getDownlinkSwitchPacketList(downlinkSwitch).add(packet);
    }

    @Override
    public void addPacketToBeSentToUplinkSwitch(Switch uplinkSwitch, HostPacket packet) {
        this.getUplinkSwitchPacketList(uplinkSwitch).add(packet);
    }

    @Override
    public void addPacketToBeSentToHost(NetworkHost host, HostPacket packet) {
        this.getHostPacketList(host).add(packet);
    }

    @Override
    public NetworkDatacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public void setDatacenter(NetworkDatacenter datacenter) {
        this.datacenter = datacenter;
    }

    @Override
    public List<HostPacket> getPacketList() {
        return this.packetList;
    }

    protected EdgeSwitch getVmEdgeSwitch(Vm vm) {
        return ((NetworkHost)vm.getHost()).getEdgeSwitch();
    }
}

