/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.vms.Vm;

public class AggregateSwitch
extends AbstractSwitch {
    public static final int LEVEL = 1;
    public static final double SWITCHING_DELAY = 0.00245;
    public static final long DOWNLINK_BW = 0x32000000L;
    public static final int PORTS = 1;

    public AggregateSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(3.5184372088832E14);
        this.setDownlinkBandwidth(8.388608E8);
        this.setSwitchingDelay(0.00245);
        this.setPorts(1);
    }

    @Override
    protected void processPacketDown(SimEvent ev) {
        super.processPacketDown(ev);
        HostPacket netPkt = (HostPacket)ev.getData();
        Vm receiverVm = netPkt.getVmPacket().getDestination();
        EdgeSwitch netSwitch = this.getVmEdgeSwitch(receiverVm);
        this.addPacketToBeSentToDownlinkSwitch(netSwitch, netPkt);
    }

    @Override
    protected void processPacketUp(SimEvent ev) {
        super.processPacketUp(ev);
        HostPacket netPkt = (HostPacket)ev.getData();
        Vm receiverVm = netPkt.getVmPacket().getDestination();
        EdgeSwitch edgeSwitch = this.getVmEdgeSwitch(receiverVm);
        if (this.findConnectedEdgeSwitch(edgeSwitch)) {
            this.addPacketToBeSentToDownlinkSwitch(edgeSwitch, netPkt);
        } else {
            Switch sw = this.getUplinkSwitches().get(0);
            this.addPacketToBeSentToUplinkSwitch(sw, netPkt);
        }
    }

    private boolean findConnectedEdgeSwitch(Switch edgeSwitch) {
        return this.getDownlinkSwitches().stream().anyMatch(edgeSwitch::equals);
    }

    @Override
    public int getLevel() {
        return 1;
    }
}

